/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import elec332.core.client.render.AbstractBlockRenderer;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;

public class RenderHelper {
    public static final float renderUnit = 0.0625f;
    private static List<Block> itemRenders = Lists.newArrayList();
    private static List<Block> blockRenders = Lists.newArrayList();
    private static List<Class<? extends TileEntity>> tileRenders = Lists.newArrayList();
    private static Map<Block, Integer> renderData = Maps.newHashMap();
    private static Tessellator tessellator = Tessellator.field_78398_a;

    public static <A extends AbstractBlockRenderer> A registerBlockRenderer(A renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Cannot register a null renderer!");
        }
        if (!(renderer.isISBRH() || renderer.isItemRenderer() || renderer.isTESR())) {
            throw new IllegalArgumentException("Useless render handler detected: " + ((Object)renderer).getClass());
        }
        if (renderer.isItemRenderer() || renderer.isISBRH()) {
            if (renderer.block == null) {
                throw new IllegalArgumentException("Cannot register IItemRenderer or ISBRH for a null Block!");
            }
            if (renderer.isItemRenderer() && itemRenders.contains(renderer.block) || renderer.isISBRH() && blockRenders.contains(renderer.block)) {
                throw new IllegalArgumentException("Renderer already registered for " + renderer.block.getClass());
            }
        }
        if (renderer.isTESR()) {
            if (renderer.tileClass == null) {
                throw new IllegalArgumentException("Cannot register TESR for a null TileEntity class!");
            }
            if (tileRenders.contains(renderer.tileClass)) {
                throw new IllegalArgumentException("Renderer already registered for " + renderer.tileClass);
            }
        }
        if (renderer.isISBRH()) {
            int r;
            if (renderer.renderID != -1) {
                throw new UnsupportedOperationException();
            }
            renderer.renderID = r = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((int)r, renderer);
            blockRenders.add(renderer.block);
            renderData.put(renderer.block, r);
        }
        if (renderer.isItemRenderer()) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)renderer.block), renderer);
            itemRenders.add(renderer.block);
        }
        if (renderer.isTESR()) {
            ClientRegistry.bindTileEntitySpecialRenderer(renderer.tileClass, renderer);
            tileRenders.add(renderer.tileClass);
        }
        return renderer;
    }

    public static int getRenderID(Block block) {
        return renderData.get(block);
    }

    public static Vec3 getPlayerVec(float partialTicks) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        return Vec3.func_72443_a((double)dX, (double)dY, (double)dZ);
    }

    public static Vec3 getPlayerVec() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
    }

    public static void drawLine(Vec3 from, Vec3 to, Vec3 player, float thickness) {
        RenderHelper.drawQuad(from, from.func_72441_c((double)thickness, (double)thickness, (double)thickness), to, to.func_72441_c((double)thickness, (double)thickness, (double)thickness));
    }

    public static void drawQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
        tessellator.func_78374_a(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0, 0.0);
        tessellator.func_78374_a(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 1.0, 0.0);
        tessellator.func_78374_a(v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 1.0, 1.0);
        tessellator.func_78374_a(v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 0.0, 1.0);
    }

    public static Vec3 multiply(Vec3 original, double m) {
        return Vec3.func_72443_a((double)(original.field_72450_a * m), (double)(original.field_72448_b * m), (double)(original.field_72449_c * m));
    }

    public static void bindBlockTextures() {
        RenderHelper.bindTexture(RenderHelper.getBlocksResourceLocation());
    }

    public static void bindTexture(ResourceLocation rl) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rl);
    }

    public static IIcon checkIcon(IIcon icon) {
        if (icon == null) {
            return RenderHelper.getMissingTextureIcon();
        }
        return icon;
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        if (fluid == null) {
            return RenderHelper.getMissingTextureIcon();
        }
        return RenderHelper.checkIcon(flowing ? fluid.getFlowingIcon() : fluid.getStillIcon());
    }

    public static IIcon getMissingTextureIcon() {
        return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(RenderHelper.getBlocksResourceLocation())).func_110572_b("missingno");
    }

    public static ResourceLocation getBlocksResourceLocation() {
        return TextureMap.field_110575_b;
    }

    public void spawnParticle(EntityFX particle) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }
}

