/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.basic;

import elec332.core.grid.basic.AbstractGridTile;
import elec332.core.grid.basic.AbstractWiringTypeHelper;
import elec332.core.grid.basic.AbstractWorldGridHolder;
import elec332.core.main.ElecCore;
import elec332.core.registry.AbstractWorldRegistryHolder;
import elec332.core.util.BlockLoc;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractCableGrid<G extends AbstractCableGrid<G, T, W, A>, T extends AbstractGridTile<G, T, W, A>, W extends AbstractWiringTypeHelper, A extends AbstractWorldGridHolder<A, G, T, W>> {
    protected final UUID identifier;
    protected final World world;
    protected List<GridData> acceptors = new ArrayList<GridData>();
    protected List<GridData> providers = new ArrayList<GridData>();
    protected List<GridData> specialProviders;
    protected List<GridData> transmitters;
    protected List<BlockLoc> locations = new ArrayList<BlockLoc>();
    private final AbstractWorldRegistryHolder<A> worldGridHolder;

    public AbstractCableGrid(World world, T p, ForgeDirection direction, W wiringHelper, AbstractWorldRegistryHolder<A> worldGridHolder) {
        this.specialProviders = new ArrayList<GridData>();
        this.transmitters = new ArrayList<GridData>();
        this.world = world;
        this.locations.add(((AbstractGridTile)p).getLocation());
        if (((AbstractWiringTypeHelper)wiringHelper).isTransmitter(((AbstractGridTile)p).getTile())) {
            this.transmitters.add(new GridData(((AbstractGridTile)p).getLocation(), direction));
        }
        if (((AbstractWiringTypeHelper)wiringHelper).isSource(((AbstractGridTile)p).getTile()) && ((AbstractWiringTypeHelper)wiringHelper).canSourceProvideTo(((AbstractGridTile)p).getTile(), direction)) {
            this.providers.add(new GridData(((AbstractGridTile)p).getLocation(), direction));
        }
        if (((AbstractWiringTypeHelper)wiringHelper).isReceiver(((AbstractGridTile)p).getTile()) && ((AbstractWiringTypeHelper)wiringHelper).canReceiverReceiveFrom(((AbstractGridTile)p).getTile(), direction)) {
            this.acceptors.add(new GridData(((AbstractGridTile)p).getLocation(), direction));
        }
        this.identifier = UUID.randomUUID();
        this.worldGridHolder = worldGridHolder;
    }

    public List<BlockLoc> getLocations() {
        return this.locations;
    }

    public final G mergeGrids(G grid) {
        if (this.world.field_73011_w.field_76574_g != ((AbstractCableGrid)grid).world.field_73011_w.field_76574_g) {
            throw new RuntimeException();
        }
        if (this.equals(grid)) {
            return (G)this;
        }
        this.uponGridMerge(grid);
        for (BlockLoc vec : ((AbstractCableGrid)grid).locations) {
            Object powerTile = ((AbstractWorldGridHolder)this.getWorldHolder()).getPowerTile(vec);
            if (powerTile == null) continue;
            ((AbstractGridTile)powerTile).replaceGrid(grid, (AbstractCableGrid)this);
        }
        ((AbstractWorldGridHolder)this.getWorldHolder()).removeGrid(grid);
        ElecCore.systemPrintDebug("MERGED");
        return (G)this;
    }

    protected void uponGridMerge(G grid) {
        this.locations.addAll(((AbstractCableGrid)grid).locations);
        this.acceptors.addAll(((AbstractCableGrid)grid).acceptors);
        this.providers.addAll(((AbstractCableGrid)grid).providers);
        this.transmitters.addAll(((AbstractCableGrid)grid).transmitters);
        this.specialProviders.addAll(((AbstractCableGrid)grid).specialProviders);
    }

    protected void onTileRemoved(T tile) {
    }

    public abstract void onTick();

    protected A getWorldHolder() {
        return (A)((AbstractWorldGridHolder)this.worldGridHolder.get(this.world));
    }

    protected void invalidate() {
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((AbstractCableGrid)obj).identifier.equals(this.identifier);
    }

    public static class GridData {
        private BlockLoc loc;
        private ForgeDirection direction;

        public GridData(BlockLoc blockLoc, ForgeDirection direction) {
            this.loc = blockLoc;
            this.direction = direction;
        }

        public BlockLoc getLoc() {
            return this.loc;
        }

        public ForgeDirection getDirection() {
            return this.direction;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof GridData && ((GridData)obj).loc.equals(this.loc) && ((GridData)obj).direction.equals((Object)this.direction);
        }
    }
}

