/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.basic;

import com.google.common.collect.Lists;
import elec332.core.grid.basic.AbstractCableGrid;
import elec332.core.grid.basic.AbstractWiringTypeHelper;
import elec332.core.grid.basic.AbstractWorldGridHolder;
import elec332.core.main.ElecCore;
import elec332.core.registry.AbstractWorldRegistryHolder;
import elec332.core.util.BlockLoc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractGridTile<G extends AbstractCableGrid<G, T, W, A>, T extends AbstractGridTile<G, T, W, A>, W extends AbstractWiringTypeHelper, A extends AbstractWorldGridHolder<A, G, T, W>> {
    private TileEntity tile;
    private boolean hasInit = false;
    private BlockLoc location;
    private Object[] grids;
    private AbstractWiringTypeHelper.ConnectType connectType;
    private final AbstractWorldRegistryHolder<A> worldGridHolder;

    public AbstractGridTile(TileEntity tileEntity, W wiringHelper, AbstractWorldRegistryHolder<A> worldGridHolder) {
        if (!((AbstractWiringTypeHelper)wiringHelper).isTileValid(tileEntity)) {
            throw new IllegalArgumentException();
        }
        this.tile = tileEntity;
        this.location = new BlockLoc(tileEntity);
        this.grids = new Object[6];
        this.worldGridHolder = worldGridHolder;
        if (((AbstractWiringTypeHelper)wiringHelper).isTransmitter(tileEntity)) {
            this.grids[0] = this.newGridP(ForgeDirection.UNKNOWN);
            this.connectType = AbstractWiringTypeHelper.ConnectType.CONNECTOR;
        } else if (((AbstractWiringTypeHelper)wiringHelper).isReceiver(tileEntity) && ((AbstractWiringTypeHelper)wiringHelper).isSource(tileEntity)) {
            this.connectType = AbstractWiringTypeHelper.ConnectType.SEND_RECEIVE;
        } else if (((AbstractWiringTypeHelper)wiringHelper).isReceiver(tileEntity)) {
            this.connectType = AbstractWiringTypeHelper.ConnectType.RECEIVE;
        } else if (((AbstractWiringTypeHelper)wiringHelper).isSource(tileEntity)) {
            this.connectType = AbstractWiringTypeHelper.ConnectType.SEND;
        }
        this.hasInit = true;
    }

    private G getGrid(int i) {
        return (G)((AbstractCableGrid)this.grids[i]);
    }

    private boolean singleGrid() {
        return this.connectType == AbstractWiringTypeHelper.ConnectType.CONNECTOR;
    }

    public AbstractWiringTypeHelper.ConnectType getConnectType() {
        return this.connectType;
    }

    public BlockLoc getLocation() {
        return this.location;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public boolean hasInit() {
        return this.hasInit;
    }

    public void replaceGrid(G old, G newGrid) {
        if (this.singleGrid()) {
            this.grids[0] = newGrid;
        } else {
            int q = 0;
            for (Object grid : this.grids) {
                if (grid == null) continue;
                ++q;
            }
            ElecCore.systemPrintDebug("OldSizeBeforeMerge: " + q);
            int i = this.removeGrid(old);
            ElecCore.systemPrintDebug(i);
            this.grids[i] = newGrid;
            q = 0;
            for (Object grid : this.grids) {
                if (grid == null) continue;
                ++q;
            }
            ElecCore.systemPrintDebug("NewSizeAfterMerge " + q);
            ElecCore.systemPrintDebug(this.grids.length);
        }
    }

    public void resetGrid(G grid) {
        this.removeGrid(grid);
        if (this.singleGrid()) {
            this.getGrid();
        }
    }

    public int removeGrid(G grid) {
        if (this.grids.length == 0) {
            throw new RuntimeException();
        }
        for (int i = 0; i < this.grids.length; ++i) {
            if (!((AbstractCableGrid)grid).equals(this.grids[i])) continue;
            this.grids[i] = null;
            return i;
        }
        return -1;
    }

    public List<G> getGrids() {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < this.grids.length; ++i) {
            ret.add(this.getGrid(i));
        }
        return ret;
    }

    public G getGridFromSide(ForgeDirection forgeDirection) {
        return this.singleGrid() ? this.getGrid() : this.getFromSide(forgeDirection);
    }

    private G getFromSide(ForgeDirection direction) {
        G grid = this.getGrid(direction.ordinal());
        if (grid == null) {
            grid = this.newGridP(direction);
            this.grids[direction.ordinal()] = grid;
        }
        return grid;
    }

    public G getGrid() {
        if (!this.singleGrid()) {
            throw new UnsupportedOperationException("Request grid when tile has multiple grids");
        }
        G grid = this.getGrid(0);
        if (grid == null) {
            grid = this.newGridP(ForgeDirection.UNKNOWN);
            this.grids[0] = grid;
        }
        return grid;
    }

    protected AbstractWorldRegistryHolder<A> getWorldGridHolder() {
        return this.worldGridHolder;
    }

    private G newGridP(ForgeDirection direction) {
        return ((AbstractWorldGridHolder)this.worldGridHolder.get(this.tile.func_145831_w())).registerGrid(this.newGrid(direction));
    }

    protected abstract G newGrid(ForgeDirection var1);

    public boolean equals(Object obj) {
        return obj.getClass().equals(this.getClass()) && this.location.equals(((AbstractGridTile)obj).getLocation());
    }
}

