/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.basic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.grid.basic.AbstractCableGrid;
import elec332.core.grid.basic.AbstractGridTile;
import elec332.core.grid.basic.AbstractWiringTypeHelper;
import elec332.core.main.ElecCore;
import elec332.core.registry.IWorldRegistry;
import elec332.core.util.BlockLoc;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractWorldGridHolder<A extends AbstractWorldGridHolder<A, G, T, W>, G extends AbstractCableGrid<G, T, W, A>, T extends AbstractGridTile<G, T, W, A>, W extends AbstractWiringTypeHelper>
implements IWorldRegistry {
    private World world;
    private List<G> grids;
    private Queue<T> pending;
    private Map<BlockLoc, T> registeredTiles;
    private int oldInt;
    private W wiringHelper;

    public AbstractWorldGridHolder(World world, W wiringHelper) {
        this.world = world;
        this.grids = Lists.newArrayList();
        this.registeredTiles = Maps.newHashMap();
        this.pending = new ArrayDeque<T>();
        this.oldInt = 0;
        this.wiringHelper = wiringHelper;
    }

    public G registerGrid(G grid) {
        this.grids.add(grid);
        return grid;
    }

    protected void removeGrid(G grid) {
        ((AbstractCableGrid)grid).invalidate();
        this.grids.remove(grid);
    }

    public void addTile(TileEntity tile) {
        T powerTile = this.newGridTile(tile);
        this.registeredTiles.put(this.genCoords(tile), powerTile);
        this.addTile(powerTile);
        ElecCore.systemPrintDebug("Tile placed at " + this.genCoords(tile).toString());
    }

    protected abstract T newGridTile(TileEntity var1);

    public void addTile(T powerTile) {
        if (!this.world.field_72995_K) {
            ElecCore.systemPrintDebug("Processing tile at " + ((AbstractGridTile)powerTile).getLocation().toString());
            TileEntity theTile = ((AbstractGridTile)powerTile).getTile();
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                ElecCore.systemPrintDebug("Processing tile at " + ((AbstractGridTile)powerTile).getLocation().toString() + " for side " + direction.toString());
                TileEntity possTile = this.world.func_147438_o(theTile.field_145851_c + direction.offsetX, theTile.field_145848_d + direction.offsetY, theTile.field_145849_e + direction.offsetZ);
                if (possTile != null && ((AbstractWiringTypeHelper)this.wiringHelper).isTileValid(possTile)) {
                    T powerTile1 = this.getPowerTile(this.genCoords(possTile));
                    if (powerTile1 == null || !((AbstractGridTile)powerTile1).hasInit()) {
                        this.pending.add(powerTile);
                        break;
                    }
                    if (!this.canConnect(powerTile, direction, powerTile1)) continue;
                    Object grid = ((AbstractGridTile)powerTile1).getGridFromSide(direction.getOpposite());
                    ((AbstractCableGrid)((AbstractGridTile)powerTile).getGridFromSide(direction)).mergeGrids(grid);
                    continue;
                }
                ElecCore.systemPrintDebug("There is no tile at side " + direction.toString() + " that is valid for connection");
            }
        }
    }

    private boolean canConnect(T powerTile1, ForgeDirection direction, T powerTile2) {
        TileEntity mainTile = ((AbstractGridTile)powerTile1).getTile();
        boolean flag1 = false;
        boolean flag2 = false;
        if (((AbstractGridTile)powerTile1).getConnectType() == ((AbstractGridTile)powerTile2).getConnectType() && (((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.SEND || ((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.RECEIVE)) {
            return false;
        }
        if (((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.CONNECTOR && ((AbstractGridTile)powerTile2).getConnectType() == AbstractWiringTypeHelper.ConnectType.CONNECTOR) {
            return ((AbstractWiringTypeHelper)this.wiringHelper).canTransmitterConnectTo(mainTile, ((AbstractGridTile)powerTile2).getTile()) && ((AbstractWiringTypeHelper)this.wiringHelper).canTransmitterConnectTo(mainTile, direction) && this.canConnectFromSide(direction.getOpposite(), powerTile2);
        }
        if (((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.CONNECTOR) {
            return this.canConnectFromSide(direction.getOpposite(), powerTile2);
        }
        if (((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.SEND_RECEIVE) {
            if (((AbstractWiringTypeHelper)this.wiringHelper).canSourceProvideTo(mainTile, direction)) {
                flag1 = this.canConnectFromSide(direction.getOpposite(), powerTile2);
            }
            if (((AbstractWiringTypeHelper)this.wiringHelper).canReceiverReceiveFrom(mainTile, direction)) {
                flag2 = this.canConnectFromSide(direction.getOpposite(), powerTile2);
            }
            return flag1 || flag2;
        }
        if (((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.RECEIVE ? ((AbstractWiringTypeHelper)this.wiringHelper).canReceiverReceiveFrom(mainTile, direction) : ((AbstractGridTile)powerTile1).getConnectType() == AbstractWiringTypeHelper.ConnectType.SEND && ((AbstractWiringTypeHelper)this.wiringHelper).canSourceProvideTo(mainTile, direction)) {
            return this.canConnectFromSide(direction.getOpposite(), powerTile2);
        }
        return false;
    }

    private boolean canConnectFromSide(ForgeDirection direction, T powerTile2) {
        TileEntity secondTile = ((AbstractGridTile)powerTile2).getTile();
        boolean flag1 = false;
        boolean flag2 = false;
        if (((AbstractWiringTypeHelper)this.wiringHelper).isTransmitter(secondTile)) {
            return ((AbstractWiringTypeHelper)this.wiringHelper).canTransmitterConnectTo(secondTile, direction);
        }
        if (((AbstractWiringTypeHelper)this.wiringHelper).isReceiver(secondTile)) {
            flag1 = ((AbstractWiringTypeHelper)this.wiringHelper).canReceiverReceiveFrom(secondTile, direction);
        }
        if (((AbstractWiringTypeHelper)this.wiringHelper).isSource(secondTile)) {
            flag2 = ((AbstractWiringTypeHelper)this.wiringHelper).canSourceProvideTo(secondTile, direction);
        }
        return flag1 || flag2;
    }

    public void removeTile(TileEntity tile) {
        if (!((AbstractWiringTypeHelper)this.wiringHelper).isTileValid(tile)) {
            throw new IllegalArgumentException();
        }
        this.removeTile(this.getPowerTile(this.genCoords(tile)));
    }

    public void removeTile(T powerTile) {
        if (powerTile != null) {
            for (AbstractCableGrid grid : ((AbstractGridTile)powerTile).getGrids()) {
                if (grid == null) continue;
                ElecCore.systemPrintDebug("Removing tile at " + ((AbstractGridTile)powerTile).getLocation().toString());
                ArrayList<BlockLoc> vec3List = new ArrayList<BlockLoc>();
                vec3List.addAll(grid.getLocations());
                vec3List.remove(((AbstractGridTile)powerTile).getLocation());
                ElecCore.systemPrintDebug(this.grids.size());
                grid.onTileRemoved(powerTile);
                this.removeGrid(grid);
                ElecCore.systemPrintDebug(this.grids.size());
                ElecCore.systemPrintDebug(this.registeredTiles.keySet().size());
                this.registeredTiles.remove(((AbstractGridTile)powerTile).getLocation());
                ElecCore.systemPrintDebug(this.registeredTiles.keySet().size());
                ArrayList<BlockLoc> vec3List2 = new ArrayList<BlockLoc>();
                for (BlockLoc vec : vec3List) {
                    T pt;
                    if (vec.equals(((AbstractGridTile)powerTile).getLocation()) || (pt = this.getPowerTile(vec)) == null) continue;
                    ((AbstractGridTile)pt).resetGrid((AbstractCableGrid)grid);
                    vec3List2.add(vec);
                }
                for (BlockLoc vec : vec3List2) {
                    ElecCore.systemPrintDebug("Re-adding tile at " + vec.toString());
                    TileEntity tileEntity1 = this.getTile(vec);
                    if (!((AbstractWiringTypeHelper)this.wiringHelper).isTileValid(tileEntity1) || this.getPowerTile(vec) == null) continue;
                    this.addTile(this.getPowerTile(vec));
                }
            }
        }
    }

    @Override
    public void tick() {
        this.onServerTickInternal();
    }

    private void onServerTickInternal() {
        ElecCore.systemPrintDebug("Tick! " + this.world.field_73011_w.field_76574_g);
        if (!this.pending.isEmpty() && this.pending.size() == this.oldInt) {
            AbstractGridTile powerTile = (AbstractGridTile)this.pending.poll();
            while (powerTile != null) {
                this.addTile(powerTile);
                powerTile = (AbstractGridTile)this.pending.poll();
            }
            this.pending.clear();
        }
        this.oldInt = this.pending.size();
        for (int i = 0; i < this.grids.size(); ++i) {
            try {
                ((AbstractCableGrid)this.grids.get(i)).onTick();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ElecCore.systemPrintDebug(i);
        }
    }

    public T getPowerTile(BlockLoc loc) {
        return (T)((AbstractGridTile)this.registeredTiles.get(loc));
    }

    private BlockLoc genCoords(TileEntity tileEntity) {
        return new BlockLoc(tileEntity);
    }

    private TileEntity getTile(BlockLoc vec) {
        return this.world.func_147438_o(vec.xCoord, vec.yCoord, vec.zCoord);
    }

    @Override
    public void onWorldUnload() {
    }
}

