/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import com.google.common.collect.Lists;
import elec332.core.inventory.widget.WidgetButton;
import java.util.List;

public class WidgetEnumChange<E extends Enum>
extends WidgetButton {
    private final Class<E> enumClass;
    private List<IEnumChangedEvent<WidgetEnumChange<E>>> list;
    private int index;

    public WidgetEnumChange(int x, int y, int width, int height, Class<E> clazz) {
        super(x, y, 0, 0, width, height);
        this.enumClass = clazz;
        this.index = 0;
        this.list = Lists.newArrayList();
        this.setDisplayString(((Enum)this.getEnum()).toString());
    }

    public WidgetEnumChange<E> addButtonEvent(IEnumChangedEvent<WidgetEnumChange<E>> event) {
        this.list.add(event);
        return this;
    }

    public E getEnum() {
        return (E)((Enum[])this.enumClass.getEnumConstants())[this.index];
    }

    public void setEnum(E e) {
        boolean b = true;
        for (int i = 0; i < ((Enum[])this.enumClass.getEnumConstants()).length; ++i) {
            Enum en = ((Enum[])this.enumClass.getEnumConstants())[i];
            if (e != en) continue;
            this.setDisplayString(en.toString());
            this.index = i;
            b = false;
        }
        this.distributeEvents();
        if (b) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void onButtonClicked() {
        super.onButtonClicked();
        ++this.index;
        if (this.index >= ((Enum[])this.enumClass.getEnumConstants()).length) {
            this.index = 0;
        }
        this.setDisplayString(((Enum)this.getEnum()).toString());
        this.distributeEvents();
    }

    private void distributeEvents() {
        for (IEnumChangedEvent<WidgetEnumChange<WidgetEnumChange>> iEnumChangedEvent : this.list) {
            iEnumChangedEvent.onEnumChanged(this);
        }
    }

    public static interface IEnumChangedEvent<E extends WidgetEnumChange> {
        public void onEnumChanged(E var1);
    }
}

