/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.modBaseUtils;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import elec332.core.config.ConfigCore;
import elec332.core.helper.LogHelper;
import elec332.core.helper.ModInfoHelper;
import elec332.core.main.ElecCore;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;

public abstract class ModBase
extends LogHelper {
    public ConfigCore config;
    boolean outdated = false;
    boolean uptodate = false;
    String onlineVer;
    public static boolean developmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    protected abstract File configFile();

    @Override
    public abstract String modID();

    @Override
    protected ConfigCore configCore() {
        return this.config;
    }

    public void loadConfiguration() {
        if (this.config == null) {
            this.config = new ConfigCore(this.configFile());
        }
        this.config.syncConfiguration();
    }

    protected void notifyEvent(FMLPreInitializationEvent event) {
        this.info(this.modID() + " has " + event.getModState());
    }

    protected void notifyEvent(FMLInitializationEvent event) {
        this.info(this.modID() + " has " + event.getModState());
    }

    protected void notifyEvent(FMLPostInitializationEvent event) {
        this.info(this.modID() + " has " + event.getModState());
    }

    @Deprecated
    public void loadConfiguration(Configuration config) {
        config.load();
        config.save();
    }

    protected void runUpdateCheck(FMLPreInitializationEvent event, String versionURL) {
        String modID_V = ModInfoHelper.getModID(event);
        String versionInternal = ModInfoHelper.getModVersion(event);
        event.getModLog().info("Starting version check");
        ArrayList<String> updateInfo = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(versionURL).openStream()));
            this.onlineVer = reader.readLine().replace("mod_version=", "");
            reader.close();
            String[] unparsed = this.onlineVer.replace(".", " ").split(" ");
            String[] qr = versionInternal.replace(".", " ").split(" ");
            if (unparsed.length == qr.length) {
                for (int i = 0; i < unparsed.length; ++i) {
                    String mr = qr[i];
                    String nr = unparsed[i];
                    int v = Integer.parseInt(nr);
                    if (versionInternal.equalsIgnoreCase(this.onlineVer)) continue;
                    if (v < Integer.parseInt(mr)) {
                        this.uptodate = true;
                    }
                    if (this.uptodate || v <= Integer.parseInt(mr)) continue;
                    this.outdated = true;
                }
            } else {
                event.getModLog().warn("The online version length and the internal version length differs, report this to the mod author!");
                event.getModLog().warn("Assuming you are using an outdated version");
                this.outdated = true;
            }
            if (this.outdated) {
                updateInfo.add(versionInternal);
                updateInfo.add(this.onlineVer);
                event.getModLog().info("Marking as outdated");
                ElecCore.outdatedModList.add(modID_V);
                ElecCore.Updates.put(modID_V, updateInfo);
            } else {
                event.getModLog().info("Marking as up-to-date");
            }
            event.getModLog().info("Version check complete");
        }
        catch (Exception e) {
            event.getModLog().warn("Couldn't run VersionCheck: ", (Throwable)e);
        }
    }
}

