/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.ImmutableList;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockRegistry;
import elec332.core.util.BlockLoc;
import java.util.List;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class IMultiBlock {
    private final UUID identifier = UUID.randomUUID();
    private BlockLoc loc;
    private ForgeDirection facing;
    private List<BlockLoc> allMultiBlockLocations;
    private MultiBlockRegistry.MultiBlockWorldRegistry multiBlockRegistry;
    private State multiBlockState;
    private String structureID;

    public final void initMain(BlockLoc location, ForgeDirection facing, List<BlockLoc> allMultiBlockLocations, MultiBlockRegistry.MultiBlockWorldRegistry registry, String structureID) {
        if (this.loc != null) {
            throw new RuntimeException();
        }
        this.loc = location;
        this.facing = facing;
        this.allMultiBlockLocations = ImmutableList.copyOf(allMultiBlockLocations);
        this.multiBlockRegistry = registry;
        this.structureID = structureID;
        this.init();
        this.multiBlockState = State.active;
    }

    public final String getStructureID() {
        return this.structureID;
    }

    public final BlockLoc getLocation() {
        return this.loc;
    }

    public final ForgeDirection getMultiBlockFacing() {
        return this.facing;
    }

    public final List<BlockLoc> getAllMultiBlockLocations() {
        return this.allMultiBlockLocations;
    }

    public abstract void init();

    public abstract void onTick();

    public abstract void invalidate();

    public World getWorldObj() {
        return this.multiBlockRegistry.getWorldObj();
    }

    public void tileEntityInvalidate() {
        this.multiBlockRegistry.invalidateMultiBlock(this);
    }

    public void tileEntityValidate() {
        if (this.multiBlockState == State.paused) {
            System.out.println("reactivating...");
            this.multiBlockRegistry.reactivateMultiBlock(this);
            this.multiBlockState = State.active;
            System.out.println("reactivated");
        }
    }

    public void tileEntityChunkUnload(IMultiBlockTile tile) {
        this.multiBlockRegistry.deactivateMultiBlock(this);
        this.multiBlockState = State.paused;
    }

    public static void tileEntityInvalidate(IMultiBlock multiBlock) {
        if (multiBlock == null) {
            return;
        }
        multiBlock.tileEntityInvalidate();
    }

    public static void tileEntityChunkUnload(IMultiBlock multiBlock, IMultiBlockTile tile) {
        if (multiBlock == null) {
            return;
        }
        multiBlock.tileEntityChunkUnload(tile);
    }

    public static void tileEntityValidate(IMultiBlockTile tile, IMultiBlock multiBlock, MultiBlockRegistry multiBlockRegistry) {
        if (!tile.isValidMultiBlock()) {
            return;
        }
        if (multiBlock != null) {
            multiBlock.tileEntityValidate();
        } else {
            multiBlockRegistry.getStructureRegistry().attemptReCreate(tile.getStructureIdentifier(), (TileEntity)tile, tile.getMultiBlockFacing());
        }
    }

    public int hashCode() {
        return this.loc.hashCode() * this.allMultiBlockLocations.size();
    }

    public boolean equals(Object obj) {
        return obj instanceof IMultiBlock && ((IMultiBlock)obj).identifier.equals(this.identifier) && obj.hashCode() == this.hashCode();
    }

    protected static enum State {
        active,
        paused;

    }
}

