/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import elec332.core.multiblock.IMultiBlock;
import elec332.core.multiblock.IMultiBlockStructure;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockStructureRegistry;
import elec332.core.network.NetworkHandler;
import elec332.core.registry.AbstractWorldRegistryHolder;
import elec332.core.registry.IWorldRegistry;
import elec332.core.util.BlockLoc;
import elec332.core.util.EventHelper;
import elec332.core.world.WorldHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class MultiBlockRegistry
extends AbstractWorldRegistryHolder<MultiBlockWorldRegistry> {
    private HashMap<Class<? extends IMultiBlockStructure>, Class<? extends IMultiBlock>> registry = Maps.newHashMap();
    private final MultiBlockStructureRegistry structureRegistry;
    protected final NetworkHandler networkHandler;

    public MultiBlockRegistry() {
        this(new NetworkHandler(Loader.instance().activeModContainer().getModId() + "|MultiBlocks"));
    }

    public MultiBlockRegistry(NetworkHandler networkHandler) {
        this.networkHandler = networkHandler;
        this.structureRegistry = new MultiBlockStructureRegistry(this);
        EventHelper.registerHandlerForge(this);
    }

    @Override
    public boolean serverOnly() {
        return false;
    }

    @Override
    public MultiBlockWorldRegistry newRegistry(World world) {
        return new MultiBlockWorldRegistry(world);
    }

    public void registerMultiBlock(IMultiBlockStructure multiBlockStructure, String name, Class<? extends IMultiBlock> multiBlock) {
        this.registry.put(multiBlockStructure.getClass(), multiBlock);
        this.structureRegistry.registerMultiBlockStructure(multiBlockStructure, name);
    }

    public MultiBlockStructureRegistry getStructureRegistry() {
        return this.structureRegistry;
    }

    public class MultiBlockWorldRegistry
    implements IWorldRegistry {
        private final World world;
        private List<IMultiBlock> activeMultiBlocks;
        private List<IMultiBlock> pausedMultiBlocks;

        protected MultiBlockWorldRegistry(World world) {
            this.world = world;
            this.activeMultiBlocks = Lists.newArrayList();
            this.pausedMultiBlocks = Lists.newArrayList();
        }

        protected World getWorldObj() {
            return this.world;
        }

        protected void invalidateMultiBlock(IMultiBlock multiBlock) {
            for (BlockLoc loc : multiBlock.getAllMultiBlockLocations()) {
                TileEntity tile = WorldHelper.getTileAt((IBlockAccess)this.world, loc);
                if (!(tile instanceof IMultiBlockTile)) continue;
                ((IMultiBlockTile)tile).invalidateMultiBlock();
            }
            this.activeMultiBlocks.remove(multiBlock);
            multiBlock.invalidate();
        }

        protected void deactivateMultiBlock(IMultiBlock multiBlock) {
            this.activeMultiBlocks.remove(multiBlock);
            this.pausedMultiBlocks.add(multiBlock);
        }

        protected void reactivateMultiBlock(IMultiBlock multiBlock) {
            this.pausedMultiBlocks.remove(multiBlock);
            this.activeMultiBlocks.add(multiBlock);
        }

        protected void createNewMultiBlock(IMultiBlockStructure multiBlockStructure, BlockLoc bottomLeft, List<BlockLoc> allLocations, World world, ForgeDirection facing) {
            IMultiBlock multiBlock;
            Class clazz = (Class)MultiBlockRegistry.this.registry.get(multiBlockStructure.getClass());
            try {
                multiBlock = (IMultiBlock)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking class: " + clazz.getName() + " Please make sure the constructor has no arguments!", e);
            }
            boolean one = false;
            for (BlockLoc loc : allLocations) {
                TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, loc);
                if (!(tile instanceof IMultiBlockTile)) continue;
                ((IMultiBlockTile)tile).setMultiBlock(multiBlock, facing, MultiBlockRegistry.this.structureRegistry.getIdentifier(multiBlockStructure));
                one = true;
            }
            if (!one) {
                throw new IllegalArgumentException("A multiblock must contain at LEAST 1 IMultiBlockTile");
            }
            multiBlock.initMain(bottomLeft, facing, allLocations, this, MultiBlockRegistry.this.structureRegistry.getIdentifier(multiBlockStructure));
            this.activeMultiBlocks.add(multiBlock);
        }

        @Override
        public void tick() {
            for (IMultiBlock multiBlock : this.activeMultiBlocks) {
                multiBlock.onTick();
            }
        }

        @Override
        public void onWorldUnload() {
        }
    }
}

