/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock.dynamic;

import com.google.common.collect.Lists;
import elec332.core.main.ElecCore;
import elec332.core.multiblock.dynamic.AbstractDynamicMultiBlock;
import elec332.core.multiblock.dynamic.IDynamicMultiBlockTile;
import elec332.core.registry.IWorldRegistry;
import elec332.core.util.BlockLoc;
import elec332.core.world.WorldHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractDynamicMultiBlockWorldHolder<A extends AbstractDynamicMultiBlockWorldHolder<A, M>, M extends AbstractDynamicMultiBlock<A, M>>
implements IWorldRegistry {
    private World world;
    private List<BlockLoc> registeredTiles;
    private Queue<BlockLoc> pending;
    private List<M> multiBlocks;
    private int oldInt;

    public AbstractDynamicMultiBlockWorldHolder(World world) {
        this.world = world;
        this.registeredTiles = Lists.newArrayList();
        this.pending = new ArrayDeque<BlockLoc>();
        this.multiBlocks = Lists.newArrayList();
        this.oldInt = 0;
    }

    public final M registerGrid(M m) {
        if (this.multiBlocks.contains(m)) {
            throw new IllegalArgumentException("MultiBlock is already registered!");
        }
        this.multiBlocks.add(m);
        return m;
    }

    protected void removeGrid(M m) {
        ((AbstractDynamicMultiBlock)m).invalidate();
        this.multiBlocks.remove(m);
    }

    public M getMultiBlock(IDynamicMultiBlockTile tile) {
        return tile.getMultiBlock();
    }

    public void setMultiBlock(IDynamicMultiBlockTile tile, M m) {
        tile.setMultiBlock(m);
    }

    public abstract boolean isTileValid(TileEntity var1);

    public abstract boolean canConnect(TileEntity var1, ForgeDirection var2, TileEntity var3);

    public abstract M newMultiBlock(TileEntity var1);

    public void addTile(TileEntity tile) {
        this.addTile(tile, false);
    }

    private void addTile(TileEntity tile, boolean recreate) {
        if (tile == null) {
            System.out.println("ERROR, NULL TILE!");
            return;
        }
        if (!this.isTileValid(tile) || !(tile instanceof IDynamicMultiBlockTile)) {
            throw new IllegalArgumentException("Invalid tile");
        }
        if (!this.world.field_72995_K && this.getMultiBlock((IDynamicMultiBlockTile)tile) == null) {
            BlockLoc loc = new BlockLoc(tile);
            this.registeredTiles.add(loc);
            M newM = this.registerGrid(this.newMultiBlock(tile));
            this.setMultiBlock((IDynamicMultiBlockTile)tile, newM);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity possTile = WorldHelper.getTileAt((IBlockAccess)this.world, loc.atSide(direction));
                if (possTile != null && possTile instanceof IDynamicMultiBlockTile && this.isTileValid(possTile)) {
                    BlockLoc fromPossTile = new BlockLoc(possTile);
                    if (!this.registeredTiles.contains(fromPossTile) || !this.canConnect(tile, direction, possTile)) continue;
                    M mb = this.getMultiBlock((IDynamicMultiBlockTile)possTile);
                    if (mb != null && mb.getClass() != newM.getClass()) {
                        throw new RuntimeException("Weird mess of multiblock types.");
                    }
                    if (mb == null) {
                        System.out.println("Something weird was detected, fixing now...");
                        M weirdM = this.registerGrid(this.newMultiBlock(possTile));
                        this.setMultiBlock((IDynamicMultiBlockTile)possTile, weirdM);
                        mb = this.getMultiBlock((IDynamicMultiBlockTile)possTile);
                    }
                    if (mb == null) {
                        throw new RuntimeException("I have no idea what kind of weird stuff happened here...");
                    }
                    if (((AbstractDynamicMultiBlock)newM).equals(mb)) continue;
                    for (BlockLoc mbLoc : ((AbstractDynamicMultiBlock)mb).getAllLocations()) {
                        this.setMultiBlock((IDynamicMultiBlockTile)WorldHelper.getTileAt((IBlockAccess)this.world, mbLoc), newM);
                    }
                    ((AbstractDynamicMultiBlock)newM).mergeWith(mb);
                    ((AbstractDynamicMultiBlock)mb).invalidate();
                    this.removeGrid(mb);
                    continue;
                }
                ElecCore.systemPrintDebug("There is no tile at side " + direction.toString() + " that is valid for connection");
            }
        } else if (!this.world.field_72995_K) {
            System.out.println("------------------------------------");
            System.out.println("ERROR!!!  Tile at " + new BlockLoc(tile) + " is trying to register whilst already being registered!");
            System.out.println("------------------------------------");
        }
    }

    public void removeTile(TileEntity tile) {
        if (tile == null || !this.isTileValid(tile) || !(tile instanceof IDynamicMultiBlockTile)) {
            throw new IllegalArgumentException("Invalid tile");
        }
        M m = this.getMultiBlock((IDynamicMultiBlockTile)tile);
        if (m != null) {
            ArrayList vec3List = Lists.newArrayList();
            vec3List.addAll(((AbstractDynamicMultiBlock)m).getAllLocations());
            ((AbstractDynamicMultiBlock)m).onTileRemoved(tile);
            this.removeGrid(m);
            this.registeredTiles.removeAll(vec3List);
            for (BlockLoc vec : vec3List) {
                TileEntity mbTile = WorldHelper.getTileAt((IBlockAccess)this.world, vec);
                if (mbTile == null) continue;
                this.setMultiBlock((IDynamicMultiBlockTile)mbTile, null);
            }
            vec3List.remove(new BlockLoc(tile));
            for (BlockLoc vec : vec3List) {
                TileEntity tileEntity1 = WorldHelper.getTileAt((IBlockAccess)this.world, vec);
                this.addTile(tileEntity1);
            }
        }
    }

    @Override
    public void tick() {
        this.onServerTickInternal();
    }

    private void onServerTickInternal() {
        if (!this.pending.isEmpty() && this.pending.size() == this.oldInt) {
            BlockLoc loc = this.pending.poll();
            while (loc != null) {
                this.addTile(WorldHelper.getTileAt((IBlockAccess)this.world, loc));
                loc = this.pending.poll();
            }
            this.pending.clear();
        }
        this.oldInt = this.pending.size();
        for (AbstractDynamicMultiBlock m : this.multiBlocks) {
            m.tick();
        }
    }

    @Override
    public void onWorldUnload() {
    }
}

