/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.nbt;

import elec332.core.nbt.NBTData;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.Validate;

public class NBTHelper {
    public static void save(NBTTagCompound tagCompound, Object object) {
        Class<?> objClass = object.getClass();
        for (Field field : NBTHelper.getFieldsListWithAnnotation(objClass, NBTData.class)) {
            try {
                if (field.getType().equals(Integer.TYPE)) {
                    System.out.println(field.getName() + " was a valid integer");
                    tagCompound.func_74768_a(field.getName(), field.getInt(object));
                    System.out.println(field.getName() + " was saved to NBT");
                    continue;
                }
                if (!field.getType().equals(Boolean.TYPE)) continue;
                System.out.println(field.getName() + " was a valid boolean");
                tagCompound.func_74757_a(field.getName(), field.getBoolean(object));
                System.out.println(field.getName() + " was saved to NBT");
            }
            catch (Throwable throwable) {
                NBTHelper.spam("ERROR SAVING");
                throw new RuntimeException(throwable);
            }
        }
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        Validate.isTrue((annotationCls != null ? 1 : 0) != 0, (String)"The annotation class must not be null", (Object[])new Object[0]);
        Field[] allFields = cls.getDeclaredFields();
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (field.getAnnotation(annotationCls) == null) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static void load(NBTTagCompound tagCompound, Object object) {
        Class<?> objClass = object.getClass();
        for (Field field : objClass.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                System.out.println("Running for field: " + field.getName());
                if (!field.isAnnotationPresent(NBTData.class)) continue;
                if (field.getType().equals(Integer.TYPE)) {
                    System.out.println(field.getName() + " was a valid integer");
                    field.set(object, tagCompound.func_74762_e(field.getName()));
                    System.out.println(field.getName() + " was loaded from NBT");
                    continue;
                }
                if (!field.getType().equals(Boolean.TYPE)) continue;
                System.out.println(field.getName() + " was a valid boolean");
                field.set(object, tagCompound.func_74767_n(field.getName()));
                System.out.println(field.getName() + " was loaded from NBT");
            }
            catch (Throwable throwable) {
                NBTHelper.spam("ERROR LOADING");
                throw new RuntimeException(throwable);
            }
        }
    }

    private static void spam(String s) {
        for (int i = 0; 100 > i; ++i) {
            System.out.println(s);
        }
    }
}

