/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.registry;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import elec332.core.registry.IWorldRegistry;
import elec332.core.util.EventHelper;
import elec332.core.world.WorldHelper;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public abstract class AbstractWorldRegistryHolder<T extends IWorldRegistry> {
    private WeakHashMap<World, T> mappings = new WeakHashMap();
    private List<World> worlds = Lists.newArrayList();

    public AbstractWorldRegistryHolder() {
        EventHelper.registerHandlerForgeAndFML(this);
    }

    public T get(World world) {
        return this.get(world, true);
    }

    protected T get(World world, boolean create) {
        if (world == null) {
            throw new IllegalArgumentException();
        }
        if (!world.field_72995_K || !this.serverOnly()) {
            IWorldRegistry ret = (IWorldRegistry)this.mappings.get(world);
            if (ret == null && create) {
                ret = this.newRegistry(world);
                this.mappings.put(world, ret);
                this.worlds.add(world);
            }
            return (T)ret;
        }
        return null;
    }

    public abstract boolean serverOnly();

    public abstract T newRegistry(World var1);

    private void unload(World world) {
        ((IWorldRegistry)this.mappings.get(world)).onWorldUnload();
        this.mappings.remove(world);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        T t;
        if (event.phase == TickEvent.Phase.START && (t = this.get(event.world, false)) != null) {
            t.tick();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world_unload = null;
        for (World world : this.worlds) {
            if (WorldHelper.getDimID(event.world) != WorldHelper.getDimID(world)) continue;
            world_unload = world;
            this.unload(world);
            break;
        }
        if (world_unload != null) {
            this.worlds.remove(world_unload);
        }
    }
}

