/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.server;

import com.google.common.collect.Maps;
import elec332.core.server.ServerHelper;
import elec332.core.util.NBTHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ElecPlayer {
    private Map<String, ExtendedProperties> extendedProperties;
    private boolean online;
    private NBTHelper data;
    private UUID uuid;

    protected ElecPlayer(UUID uuid) {
        this.uuid = uuid;
        this.online = false;
    }

    protected final void setExtendedProperties(Map<String, Class<? extends ExtendedProperties>> extendedProperties) {
        if (this.extendedProperties != null) {
            throw new RuntimeException("You cannot set ExtendedProperties twice!");
        }
        HashMap toHandle = Maps.newHashMap();
        for (Map.Entry<String, Class<? extends ExtendedProperties>> entry : extendedProperties.entrySet()) {
            try {
                ExtendedProperties prop = entry.getValue().newInstance();
                prop.init(this);
                toHandle.put(entry.getKey(), prop);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error adding ExtendedProperties to player: " + entry.getValue().getName());
            }
        }
        this.extendedProperties = toHandle;
    }

    public ExtendedProperties getExtendedProperty(String s) {
        return this.extendedProperties.get(s);
    }

    public EntityPlayer getRealPlayer() {
        return ServerHelper.instance.getRealPlayer(this.uuid);
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.data = new NBTHelper(tag.func_74775_l("main"));
        NBTTagList tagList = tag.func_150295_c("props", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ExtendedProperties properties;
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            String name = tagCompound.func_74779_i("name");
            NBTTagCompound data = tagCompound.func_74775_l("data");
            if (data == null) {
                data = new NBTTagCompound();
            }
            if ((properties = this.extendedProperties.get(name)) == null) continue;
            properties.readFromNBT(data);
        }
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("main", (NBTBase)this.data.toNBT());
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<String, ExtendedProperties> entry : this.extendedProperties.entrySet()) {
            NBTTagCompound toAdd = new NBTTagCompound();
            toAdd.func_74778_a("name", entry.getKey());
            NBTTagCompound data = new NBTTagCompound();
            entry.getValue().writeToNBT(data);
            toAdd.func_74782_a("data", (NBTBase)data);
            tagList.func_74742_a((NBTBase)toAdd);
        }
        tag.func_74782_a("props", (NBTBase)tagList);
        return tag;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public NBTHelper getData() {
        return this.data;
    }

    public static abstract class ExtendedProperties {
        private UUID uuid;

        public EntityPlayer getPlayer() {
            return ServerHelper.instance.getRealPlayer(this.uuid);
        }

        public boolean isPlayerOnline() {
            return ServerHelper.instance.isPlayerOnline(this.uuid);
        }

        public UUID getPlayerUUID() {
            return this.uuid;
        }

        public abstract void readFromNBT(NBTTagCompound var1);

        public abstract void writeToNBT(NBTTagCompound var1);

        private void init(ElecPlayer player) {
            this.uuid = player.getPlayerUUID();
        }
    }
}

