/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DirectionHelper {
    public static final int[][] ROTATION_MATRIX_YAW = new int[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 4, 5, 3, 2}, {0, 1, 3, 2, 5, 4}, {0, 1, 5, 4, 2, 3}};

    public static ForgeDirection getFacingOnPlacement(EntityLivingBase entityLivingBase) {
        return DirectionHelper.getDirectionFromNumber(DirectionHelper.getDirectionNumberOnPlacement(entityLivingBase));
    }

    public static int getNumberForDirection(ForgeDirection forgeDirection) {
        switch (forgeDirection) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return -1;
    }

    public static ForgeDirection getDirectionFromNumber(int i) {
        switch (i) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection rotateLeft(ForgeDirection direction) {
        switch (direction) {
            case NORTH: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.NORTH;
            }
        }
        return direction;
    }

    public static ForgeDirection rotateRight(ForgeDirection direction) {
        switch (direction) {
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.NORTH;
            }
        }
        return direction;
    }

    @Deprecated
    public static ForgeDirection getOppositeSide(ForgeDirection direction) {
        switch (direction) {
            case SOUTH: {
                return ForgeDirection.NORTH;
            }
            case WEST: {
                return ForgeDirection.EAST;
            }
            case NORTH: {
                return ForgeDirection.SOUTH;
            }
            case EAST: {
                return ForgeDirection.WEST;
            }
            case UP: {
                return ForgeDirection.DOWN;
            }
            case DOWN: {
                return ForgeDirection.UP;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static int getDirectionNumberOnPlacement(EntityLivingBase entityLivingBase) {
        return MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static void setFacing_YAW(World world, int i, int i1, int i2, ForgeDirection forgeDirection) {
        world.func_147471_g(i, i1, i2);
        world.func_72921_c(i, i1, i2, DirectionHelper.getNumberForDirection(forgeDirection), 2);
    }
}

