/*
 * Decompiled with CFR 0.152.
 */
package xyz.domi1819.uniq;

import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import xyz.domi1819.uniq.ResourceUnifier;
import xyz.domi1819.uniq.UniQ;
import xyz.domi1819.uniq.tweaker.IRecipeTweaker;

public class RecipeProcessor {
    private HashMap<String, IRecipeTweaker> recipeTweakers = new HashMap();

    public void registerRecipeTweaker(IRecipeTweaker tweaker, String recipeClassName) {
        String modId = tweaker.getModId();
        if (modId.equals("") || Loader.isModLoaded((String)modId)) {
            this.recipeTweakers.put(recipeClassName, tweaker);
        }
    }

    public void setup() {
        Iterator<Map.Entry<String, IRecipeTweaker>> iterator = this.recipeTweakers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IRecipeTweaker> entry = iterator.next();
            try {
                entry.getValue().prepareTransform(entry.getKey());
            }
            catch (Exception ex) {
                UniQ.instance.logger.error("Crafting tweaker " + entry.getValue().getName() + " threw an exception while preparing and was disabled:", (Throwable)ex);
                iterator.remove();
            }
        }
    }

    public void transform(ResourceUnifier unifier, List<IRecipe> recipes) {
        HashSet<String> unknownRecipeClasses = new HashSet<String>();
        for (IRecipe recipe : recipes) {
            IRecipeTweaker tweaker = this.recipeTweakers.get(recipe.getClass().getName());
            if (tweaker != null) {
                try {
                    tweaker.transform(unifier, recipe);
                }
                catch (Exception ex) {
                    UniQ.instance.logger.error("Crafting tweaker " + tweaker.getName() + " threw an exception while transforming:", (Throwable)ex);
                }
                continue;
            }
            unknownRecipeClasses.add(recipe.getClass().getName());
        }
        if (UniQ.instance.config.debug) {
            System.out.println("Unknown recipe classes:");
            unknownRecipeClasses.forEach(System.out::println);
        }
    }
}

