/*
 * Decompiled with CFR 0.152.
 */
package xyz.domi1819.uniq.tweakers;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import xyz.domi1819.uniq.Reflect;
import xyz.domi1819.uniq.ResourceUnifier;
import xyz.domi1819.uniq.UniQ;
import xyz.domi1819.uniq.tweaker.IGeneralTweaker;

public class RailcraftTweaker
implements IGeneralTweaker {
    @Override
    public String getName() {
        return "Railcraft";
    }

    @Override
    public String getModId() {
        return "Railcraft";
    }

    @Override
    public void run(ResourceUnifier unifier) throws Exception {
        Class<?> cCraftingManager = Class.forName("mods.railcraft.api.crafting.RailcraftCraftingManager");
        this.processRecipes(unifier, "blastFurnace", cCraftingManager, "mods.railcraft.common.util.crafting.BlastFurnaceCraftingManager", "BlastFurnaceRecipe", true);
        this.processRecipes(unifier, "cokeOven", cCraftingManager, "mods.railcraft.common.util.crafting.CokeOvenCraftingManager", "CokeOvenRecipe", true);
        this.processRecipes(unifier, "rockCrusher", cCraftingManager, "mods.railcraft.common.util.crafting.RockCrusherCraftingManager", "CrusherRecipe", false);
        this.processRollingMachineRecipes(unifier, cCraftingManager);
    }

    private void processRecipes(ResourceUnifier unifier, String machineName, Class craftingManager, String className, String recipeClassName, boolean singleOutput) throws Exception {
        Class<?> cBase = Class.forName(className);
        Field fInstance = craftingManager.getDeclaredField(machineName);
        Field fRecipes = cBase.getDeclaredField("recipes");
        fRecipes.setAccessible(true);
        Object instance = fInstance.get(null);
        if (singleOutput) {
            Field fOutput = Reflect.getNestedClass(cBase, recipeClassName).getDeclaredField("output");
            fOutput.setAccessible(true);
            for (Object recipe : (List)fRecipes.get(instance)) {
                unifier.setPreferredStack(fOutput, recipe);
            }
        } else {
            Field fOutputs = Reflect.getNestedClass(cBase, recipeClassName).getDeclaredField("outputs");
            fOutputs.setAccessible(true);
            for (Object recipe : (List)fRecipes.get(instance)) {
                List outputs = (List)fOutputs.get(recipe);
                for (int i = 0; i < outputs.size(); ++i) {
                    ItemStack replacement;
                    Map.Entry entry = (Map.Entry)outputs.get(i);
                    ItemStack output = (ItemStack)entry.getKey();
                    if (output.func_77969_a(replacement = unifier.getPreferredStack(output))) continue;
                    outputs.set(i, Maps.immutableEntry((Object)replacement, entry.getValue()));
                }
            }
        }
    }

    private void processRollingMachineRecipes(ResourceUnifier unifier, Class craftingManager) throws Exception {
        Field fRecipes = Class.forName("mods.railcraft.common.util.crafting.RollingMachineCraftingManager").getDeclaredField("recipes");
        fRecipes.setAccessible(true);
        UniQ.instance.recipeProcessor.transform(unifier, (List)fRecipes.get(craftingManager.getDeclaredField("rollingMachine").get(null)));
    }
}

