/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.cmd;

import ftb.lib.FTBLib;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.cmd.FeatureDisabledException;
import ftb.lib.api.cmd.MissingArgsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import latmod.lib.LMListUtils;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public abstract class CommandLM
extends CommandBase {
    public final String commandName;
    public final CommandLevel level;

    public CommandLM(String s, CommandLevel l) {
        this.commandName = (s == null ? "" : s).trim();
        this.level = l == null || this.commandName.isEmpty() ? CommandLevel.NONE : l;
    }

    public int func_82362_a() {
        return this.level.requiredPermsLevel();
    }

    public boolean func_71519_b(ICommandSender ics) {
        if (FTBLib.getEffectiveSide().isClient()) {
            return true;
        }
        return this.level != CommandLevel.NONE && (this.level == CommandLevel.ALL || !FTBLib.isDedicatedServer() || super.func_71519_b(ics));
    }

    public final String func_71517_b() {
        return this.commandName;
    }

    public String func_71518_a(ICommandSender ics) {
        return '/' + this.commandName;
    }

    public final void func_71515_b(ICommandSender ics, String[] args) throws CommandException {
        IChatComponent s;
        if (!this.level.isEnabled()) {
            throw new FeatureDisabledException();
        }
        if (args == null) {
            args = new String[]{};
        }
        if ((s = this.onCommand(ics, args)) != null) {
            FTBLib.printChat(ics, s);
        }
        this.onPostCommand(ics, args);
    }

    public abstract IChatComponent onCommand(ICommandSender var1, String[] var2) throws CommandException;

    public static IChatComponent error(IChatComponent c) {
        c.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        return c;
    }

    public void onPostCommand(ICommandSender ics, String[] args) throws CommandException {
    }

    public final List<String> func_71516_a(ICommandSender ics, String[] args) {
        if (!this.level.isEnabled()) {
            return null;
        }
        try {
            Object[] s = this.getTabStrings(ics, args, args.length - 1);
            if (s != null && s.length > 0) {
                if (this.sortStrings(ics, args, args.length - 1)) {
                    Arrays.sort(s);
                }
                return CommandLM.func_71530_a((String[])args, (String[])s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Boolean getUsername(String[] args, int i) {
        return null;
    }

    public final boolean func_82358_a(String[] args, int i) {
        return false;
    }

    public static boolean isArg(String[] args, int i, String ... s) {
        if (args != null && i >= 0 && i < args.length) {
            for (int j = 0; j < s.length; ++j) {
                if (!args[i].equals(s[j])) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
        Boolean b = this.getUsername(args, i);
        if (b == null) {
            return new String[0];
        }
        if (FTBLib.ftbu != null) {
            return FTBLib.ftbu.getPlayerNames(b);
        }
        ArrayList<String> l = new ArrayList<String>();
        for (EntityPlayerMP ep : FTBLib.getAllOnlinePlayers(null)) {
            l.add(ep.func_146103_bH().getName());
        }
        return LMListUtils.toStringArray(l);
    }

    public boolean sortStrings(ICommandSender ics, String[] args, int i) {
        return this.getUsername(args, i) == null;
    }

    public static void checkArgs(String[] args, int i) throws CommandException {
        if (args == null || args.length < i) {
            throw new MissingArgsException();
        }
    }

    public static void checkArgsStrong(String[] args, int i) throws CommandException {
        if (args == null || args.length != i) {
            throw new MissingArgsException();
        }
    }

    public static List<EntityPlayerMP> findPlayers(ICommandSender ics, String arg) throws CommandException {
        EntityPlayerMP player = null;
        if (arg.equals("@a")) {
            return FTBLib.getAllOnlinePlayers(null);
        }
        if (arg.equals("@r")) {
            List<EntityPlayerMP> l = FTBLib.getAllOnlinePlayers(null);
            if (!l.isEmpty()) {
                player = l.get(ics.func_130014_f_().field_73012_v.nextInt(l.size()));
            }
        } else {
            if (arg.equals("@p")) {
                if (ics instanceof EntityPlayerMP) {
                    return Collections.singletonList((EntityPlayerMP)ics);
                }
                List<EntityPlayerMP> l = FTBLib.getAllOnlinePlayers(null);
                if (l.size() < 2) {
                    return l;
                }
                EntityPlayerMP closest = null;
                double distSq = Double.POSITIVE_INFINITY;
                ChunkCoordinates c = ics.func_82114_b();
                for (EntityPlayerMP ep : l) {
                    if (closest == null) {
                        closest = ep;
                        continue;
                    }
                    double d = ep.func_70092_e((double)c.field_71574_a + 0.5, (double)c.field_71572_b + 0.5, (double)c.field_71573_c + 0.5);
                    if (!(d < distSq)) continue;
                    distSq = d;
                    closest = ep;
                }
                return Collections.singletonList(closest);
            }
            player = (EntityPlayerMP)ics.func_130014_f_().func_72924_a(arg);
        }
        if (player == null) {
            return new ArrayList<EntityPlayerMP>();
        }
        return Collections.singletonList(player);
    }
}

