/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.TextureCoords;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.MouseLM;
import ftb.lib.api.gui.widgets.PanelLM;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class GuiLM
extends GuiScreen
implements IGuiLM {
    private static final ArrayList<String> tempTextList = new ArrayList();
    public final GuiScreen parentScreen;
    public final ResourceLocation texture;
    public final PanelLM mainPanel;
    private final MouseLM mouse;
    public float delta;
    private boolean refreshWidgets = true;

    public GuiLM(GuiScreen parent, ResourceLocation tex) {
        this.parentScreen = parent;
        this.texture = tex;
        this.field_146297_k = FTBLibClient.mc;
        if (parent != null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        ScaledResolution scr = new ScaledResolution(this.field_146297_k, FTBLibClient.mc.field_71443_c, FTBLibClient.mc.field_71440_d);
        this.mainPanel = new PanelLM(this, 0, 0, scr.func_78326_a(), scr.func_78328_b()){

            @Override
            public void addWidgets() {
                GuiLM.this.addWidgets();
            }
        };
        this.mouse = new MouseLM();
        this.refreshWidgets();
    }

    @Override
    public void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public abstract void addWidgets();

    public ItemStack getHeldItem() {
        return this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
    }

    @Override
    public GuiScreen getGui() {
        return this;
    }

    @Override
    public PanelLM getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public MouseLM mouse() {
        return this.mouse;
    }

    @Override
    public final float getZLevel() {
        return this.field_73735_i;
    }

    @Override
    public final void setZLevel(float z) {
        this.field_73735_i = z;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public final void close(GuiScreen g) {
        FTBLibClient.openGui(g == null ? this.parentScreen : g);
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
        this.initLMGui();
        this.mainPanel.posX = (this.field_146294_l - this.mainPanel.width) / 2;
        this.mainPanel.posY = (this.field_146295_m - this.mainPanel.height) / 2;
        this.refreshWidgets();
    }

    @Override
    public void initLMGui() {
    }

    public boolean func_73868_f() {
        return false;
    }

    protected final void func_73864_a(int mx, int my, int b) {
        this.mouse.onClicked(b, true);
        this.mainPanel.mousePressed(b);
        super.func_73864_a(mx, my, b);
        this.mouseClicked();
    }

    public void mouseClicked() {
    }

    protected void func_73869_a(char keyChar, int key) {
        if (this.mainPanel.keyPressed(key, keyChar)) {
            return;
        }
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.onClosedByKey();
        }
        super.func_73869_a(keyChar, key);
    }

    public void onClosedByKey() {
        this.close(null);
    }

    public void drawBackground() {
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.texture != null) {
            FTBLibClient.setTexture(this.texture);
            this.func_73729_b(this.mainPanel.posX, this.mainPanel.posY, 0, 0, this.mainPanel.width, this.mainPanel.height);
        }
    }

    public void drawForeground() {
    }

    public final void func_73863_a(int mx, int my, float f) {
        this.mouse.onUpdate(mx, my);
        this.delta = f;
        if (this.refreshWidgets) {
            this.mainPanel.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.func_146276_q_();
        this.drawBackground();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        super.func_73863_a(mx, my, f);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        tempTextList.clear();
        this.drawText(tempTextList);
        if (!tempTextList.isEmpty()) {
            this.drawHoveringText(tempTextList, this.mouse.x, Math.max(this.mouse.y, 18), this.field_146289_q);
        }
        GlStateManager.disableLighting();
        this.drawForeground();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawText(List<String> l) {
        this.mainPanel.addMouseOverText(l);
    }

    public final void func_146281_b() {
        super.func_146281_b();
        this.onLMGuiClosed();
    }

    public void onLMGuiClosed() {
    }

    public void func_73729_b(int x, int y, int u, int v, int w, int h) {
        this.drawTexturedModalRectD(x, y, u, v, w, h);
    }

    public void drawTexturedModalRectD(double x, double y, double u, double v, double w, double h) {
        GuiLM.drawTexturedModalRectD(x, y, this.field_73735_i, u, v, w, h, 256, 256);
    }

    public static void drawTexturedModalRectD(double x, double y, double z, double u, double v, double w, double h, int width, int height) {
        GuiLM.drawTexturedRect(x, y, z, w, h, u, v, u + w, v + h, width, height);
    }

    public static void drawTexturedRectD(double x, double y, double z, double w, double h, double u0, double v0, double u1, double v1) {
        if (u0 == 0.0 && v0 == 0.0 && u1 == 0.0 && v1 == 0.0) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78377_a(x + 0.0, y + h, z);
            tessellator.func_78377_a(x + w, y + h, z);
            tessellator.func_78377_a(x + w, y + 0.0, z);
            tessellator.func_78377_a(x + 0.0, y + 0.0, z);
            tessellator.func_78381_a();
        } else {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a(x + 0.0, y + h, z, u0, v1);
            tessellator.func_78374_a(x + w, y + h, z, u1, v1);
            tessellator.func_78374_a(x + w, y + 0.0, z, u1, v0);
            tessellator.func_78374_a(x + 0.0, y + 0.0, z, u0, v0);
            tessellator.func_78381_a();
        }
    }

    public static void drawTexturedRect(double x, double y, double z, double w, double h, double u0, double v0, double u1, double v1, int textureW, int textureH) {
        double scX = 1.0 / (double)textureW;
        double scY = 1.0 / (double)textureH;
        GuiLM.drawTexturedRectD(x, y, z, w, h, u0 * scX, v0 * scY, u1 * scX, v1 * scY);
    }

    public void playSoundFX(ResourceLocation s, float pitch) {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)s, (float)pitch));
    }

    public static void drawPlayerHead(String username, double x, double y, double w, double h, double z) {
        FTBLibClient.setTexture(FTBLibClient.getSkinTexture(username));
        GuiLM.drawTexturedRectD(x, y, z, w, h, 0.125, 0.25, 0.25, 0.5);
        GuiLM.drawTexturedRectD(x, y, z, w, h, 0.625, 0.25, 0.75, 0.5);
    }

    public static void drawBlankRect(double x, double y, double z, double w, double h) {
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(770, 771);
        GlStateManager.disableTexture2D();
        GuiLM.drawTexturedRectD(x, y, z, w, h, 0.0, 0.0, 0.0, 0.0);
        GlStateManager.enableTexture2D();
    }

    public static void drawItem(IGuiLM gui, ItemStack is, int x, int y) {
        if (is == null) {
            return;
        }
        FTBLibClient.setTexture(TextureMap.field_110576_c);
        gui.setZLevel(200.0f);
        GuiLM.field_146296_j.field_77023_b = 200.0f;
        FTBLibClient.renderGuiItem(is, field_146296_j, gui.getFontRenderer(), x, y);
        gui.setZLevel(0.0f);
        GuiLM.field_146296_j.field_77023_b = 0.0f;
    }

    public static void render(TextureCoords tc, double x, double y, double z, double w, double h) {
        if (tc == null || !tc.isValid()) {
            return;
        }
        FTBLibClient.setTexture(tc.texture);
        GuiLM.drawTexturedRectD(x, y, z, w, h, tc.minU, tc.minV, tc.maxU, tc.maxV);
    }

    public static void render(TextureCoords tc, double x, double y, double z) {
        if (tc != null && tc.isValid()) {
            GuiLM.render(tc, x, y, z, tc.width, tc.height);
        }
    }
}

