/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.net;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import cpw.mods.fml.common.network.simpleimpl.SimpleIndexedCodec;
import cpw.mods.fml.relauncher.Side;
import ftb.lib.api.net.MessageLM;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;

public class LMNetworkWrapper {
    private final FMLEmbeddedChannel serverChannels;
    private final FMLEmbeddedChannel clientChannels;
    private SimpleIndexedCodec packetCodec = new SimpleIndexedCodec();

    public static final LMNetworkWrapper newWrapper(String ID) {
        return new LMNetworkWrapper(ID);
    }

    private LMNetworkWrapper(String s) {
        EnumMap channels = NetworkRegistry.INSTANCE.newChannel(s, new ChannelHandler[]{this.packetCodec});
        this.serverChannels = (FMLEmbeddedChannel)channels.get(Side.SERVER);
        this.clientChannels = (FMLEmbeddedChannel)channels.get(Side.CLIENT);
    }

    private FMLEmbeddedChannel get(Side s) {
        return s.isServer() ? this.serverChannels : this.clientChannels;
    }

    public void register(Class<? extends MessageLM> c, int discriminator, Side s) {
        try {
            IMessageHandler h = c.newInstance();
            this.packetCodec.addDiscriminator(discriminator, c);
            FMLEmbeddedChannel channel = this.get(s);
            String type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
            if (s == Side.SERVER) {
                channel.pipeline().addAfter(type, h.getClass().getName(), (ChannelHandler)new SimpleChannelHandlerWrapper(h, Side.SERVER, c));
            } else {
                channel.pipeline().addAfter(type, h.getClass().getName(), (ChannelHandler)new SimpleChannelHandlerWrapper(h, Side.CLIENT, c));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet getPacketFrom(IMessage message) {
        return this.serverChannels.generatePacketFrom((Object)message);
    }

    public void sendToAll(IMessage message) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.serverChannels.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.serverChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(IMessage message) {
        this.clientChannels.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.clientChannels.writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

