/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.tile;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class Tank {
    public final String name;
    public FluidTank fluidTank;
    private int prevAmount = -1;

    public Tank(String s, double buckets) {
        this.name = s;
        this.fluidTank = new FluidTank((int)(buckets * 1000.0));
    }

    public void setCapacity(double buckets) {
        this.fluidTank.setCapacity((int)(buckets * 1000.0));
    }

    public boolean hasFluid(int amt) {
        return this.getAmount() >= amt;
    }

    public boolean hasFluid() {
        return this.hasFluid(1);
    }

    public boolean isEmpty() {
        return !this.hasFluid();
    }

    public boolean isFull() {
        return this.hasFluid(this.getCapacity());
    }

    public FluidStack getFluidStack() {
        return this.fluidTank.getFluid();
    }

    public Fluid getFluid() {
        return this.hasFluid() ? this.getFluidStack().getFluid() : null;
    }

    public int getAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public double getAmountD() {
        return (double)this.getAmount() / (double)this.getCapacity();
    }

    public int getCapacity() {
        return this.fluidTank.getCapacity();
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound tankTag = tag.func_74775_l(this.name);
        this.fluidTank.readFromNBT(tankTag);
        if (tankTag.func_74764_b("Empty")) {
            this.fluidTank.setFluid(null);
        }
        if (this.fluidTank.getFluidAmount() > this.fluidTank.getCapacity()) {
            FluidStack fs = this.fluidTank.getFluid().copy();
            fs.amount = this.fluidTank.getCapacity();
            this.fluidTank.setFluid(fs);
        }
        this.checkIfChanged();
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound tankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(tankTag);
        tag.func_74782_a(this.name, (NBTBase)tankTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            int i = this.fluidTank.fill(resource, doFill);
            if (doFill) {
                this.checkIfChanged();
            }
            return i;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluidAmount() <= 0) {
            return null;
        }
        if (!this.fluidTank.getFluid().isFluidEqual(resource)) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        FluidStack fs = this.fluidTank.drain(resource.amount, doDrain);
        if (doDrain) {
            this.checkIfChanged();
        }
        return fs;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fs = this.fluidTank.drain(maxDrain, doDrain);
        if (doDrain) {
            this.checkIfChanged();
        }
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    private void checkIfChanged() {
        if (this.prevAmount == -1 || this.prevAmount != this.getAmount()) {
            this.prevAmount = this.getAmount();
            this.onFluidChanged();
        }
    }

    public void onFluidChanged() {
    }
}

