/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.tile;

import ftb.lib.FTBLib;
import ftb.lib.LMSecurity;
import ftb.lib.api.block.BlockLM;
import ftb.lib.api.tile.IClientActionTile;
import ftb.lib.api.tile.IGuiTile;
import ftb.lib.mod.net.MessageClientTileAction;
import latmod.lib.LMUtils;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class TileLM
extends TileEntity
implements IClientActionTile {
    public static final String ACTION_BUTTON_PRESSED = "button";
    public static final String ACTION_OPEN_GUI = "open_gui";
    public static final String ACTION_CUSTOM_NAME = "custom_name";
    public static final int[] NO_SLOTS = new int[0];
    private boolean isDirty = true;
    public boolean isLoaded = false;
    public long tick = 0L;
    public final LMSecurity security = new LMSecurity(null);
    public boolean redstonePowered = false;

    public final void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readTileData(tag);
    }

    public final void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeTileData(tag);
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTileClientData(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public final void onDataPacket(NetworkManager m, S35PacketUpdateTileEntity p) {
        NBTTagCompound tag = p.func_148857_g();
        this.readTileClientData(tag);
        this.onUpdatePacket();
    }

    public void readTileData(NBTTagCompound tag) {
        this.security.readFromNBT(tag, "Security");
        this.tick = tag.func_74763_f("Tick");
        if (this.tick < 0L) {
            this.tick = 0L;
        }
    }

    public void writeTileData(NBTTagCompound tag) {
        this.security.writeToNBT(tag, "Security");
        if (this.tick < 0L) {
            this.tick = 0L;
        }
        tag.func_74772_a("Tick", this.tick);
    }

    public void readTileClientData(NBTTagCompound tag) {
        this.readTileData(tag);
    }

    public void writeTileClientData(NBTTagCompound tag) {
        this.writeTileData(tag);
    }

    public void onUpdatePacket() {
        if (this.rerenderBlock()) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean rerenderBlock() {
        return false;
    }

    public final ChunkCoordinates pos() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        return false;
    }

    public void func_145843_s() {
        if (this.isLoaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.isLoaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        this.field_145854_h = this.getBlockType();
        this.getMeta();
        if (this.field_145854_h != null) {
            this.isLoaded = true;
        }
    }

    public void onUnloaded() {
        this.isLoaded = false;
    }

    public final void func_145845_h() {
        if (!this.isLoaded) {
            this.onLoaded();
        }
        this.onUpdate();
        if (this.isDirty) {
            this.isDirty = false;
            if (this.isServer()) {
                this.sendDirtyUpdate();
            }
        }
        ++this.tick;
    }

    public void onUpdate() {
    }

    public void sendDirtyUpdate() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onPlacedBy(EntityPlayer ep, ItemStack is) {
        this.security.setOwner(ep);
        this.func_70296_d();
    }

    public void onBroken() {
        this.sendDirtyUpdate();
    }

    public final void printOwner(EntityPlayer ep) {
        this.security.printOwner((ICommandSender)ep);
    }

    public BlockLM getBlockType() {
        Block b = super.func_145838_q();
        if (b instanceof BlockLM) {
            return (BlockLM)b;
        }
        return null;
    }

    public boolean recolorBlock(int side, int col) {
        return false;
    }

    public boolean isMinable(EntityPlayer ep) {
        return ep == null || this.security.canInteract(ep);
    }

    public boolean isExplosionResistant() {
        return !this.security.level.isPublic();
    }

    public final void sendClientAction(String action, NBTTagCompound data) {
        new MessageClientTileAction(this, action, data).sendToServer();
    }

    public void clientPressButton(String button, int mouseButton, NBTTagCompound data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ID", button);
        tag.func_74774_a("MB", (byte)mouseButton);
        if (data != null) {
            tag.func_74782_a("D", (NBTBase)data);
        }
        this.sendClientAction(ACTION_BUTTON_PRESSED, tag);
    }

    public final void clientPressButton(String button, int mouseButton) {
        this.clientPressButton(button, mouseButton, null);
    }

    public void clientOpenGui(NBTTagCompound data) {
        this.sendClientAction(ACTION_OPEN_GUI, data);
    }

    public void clientCustomName(String name) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("Name", name);
        this.sendClientAction(ACTION_CUSTOM_NAME, data);
    }

    @Override
    public void onClientAction(EntityPlayerMP ep, String action, NBTTagCompound data) {
        if (action.equals(ACTION_BUTTON_PRESSED)) {
            this.handleButton(data.func_74779_i("ID"), data.func_74771_c("MB"), data.func_74775_l("D"), ep);
            this.func_70296_d();
        } else if (action.equals(ACTION_OPEN_GUI)) {
            FTBLib.openGui((EntityPlayer)ep, (IGuiTile)((Object)this), data);
        } else if (action.equals(ACTION_CUSTOM_NAME)) {
            this.setName(data.func_74779_i("Name"));
            this.func_70296_d();
        }
    }

    public void handleButton(String button, int mouseButton, NBTTagCompound data, EntityPlayerMP ep) {
    }

    public final boolean isServer() {
        return !this.field_145850_b.field_72995_K;
    }

    public void notifyNeighbors() {
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public int getDimension() {
        return this.field_145850_b == null ? 0 : this.field_145850_b.field_73011_w.field_76574_g;
    }

    public final int hashCode() {
        return LMUtils.hashCode(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getDimension());
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.hashCode() == this.hashCode() && o instanceof TileLM) {
            TileLM t = (TileLM)o;
            return t.getDimension() == this.getDimension() && t.field_145851_c == this.field_145851_c && t.field_145848_d == this.field_145848_d && t.field_145849_e == this.field_145849_e;
        }
        return false;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public void onNeighborBlockChange(Block block) {
        this.redstonePowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public LMSecurity getSecurity() {
        return this.security;
    }

    public void setName(String s) {
    }

    public int getMeta() {
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.field_145847_g;
    }

    public void setMeta(int m) {
        this.field_145847_g = m;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, m, 3);
    }
}

