/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import latmod.lib.annotations.Flags;
import latmod.lib.annotations.IAnnotationContainer;
import latmod.lib.annotations.IFlagContainer;
import latmod.lib.annotations.IInfoContainer;
import latmod.lib.annotations.INumberBoundsContainer;
import latmod.lib.annotations.Info;
import latmod.lib.annotations.NumberBounds;

public class AnnotationHelper {
    private static final Map<Class<? extends Annotation>, Handler> map = new HashMap<Class<? extends Annotation>, Handler>();

    public static void register(Class<? extends Annotation> c, Handler h) {
        map.put(c, h);
    }

    public static void inject(Field field, Object parent, Object obj) throws Exception {
        if (field == null || !(obj instanceof IAnnotationContainer)) {
            return;
        }
        IAnnotationContainer container = (IAnnotationContainer)obj;
        for (Annotation a : field.getDeclaredAnnotations()) {
            Handler h = map.get(a.annotationType());
            if (h == null) continue;
            h.onAnnotationDeclared(a, container);
        }
    }

    static {
        AnnotationHelper.register(Info.class, new Handler(){

            @Override
            public boolean onAnnotationDeclared(Annotation a, IAnnotationContainer container) {
                if (container instanceof IInfoContainer) {
                    String[] info = ((Info)a).value();
                    if (info != null && info.length == 0) {
                        info = null;
                    }
                    ((IInfoContainer)container).setInfo(info);
                    if (container instanceof IFlagContainer) {
                        ((IFlagContainer)container).setFlag((byte)5, info != null);
                    }
                    return true;
                }
                return false;
            }
        });
        AnnotationHelper.register(NumberBounds.class, new Handler(){

            @Override
            public boolean onAnnotationDeclared(Annotation a, IAnnotationContainer container) {
                if (container instanceof INumberBoundsContainer) {
                    NumberBounds b = (NumberBounds)a;
                    ((INumberBoundsContainer)container).setBounds(b.min(), b.max());
                    return true;
                }
                return false;
            }
        });
        AnnotationHelper.register(Flags.class, new Handler(){

            @Override
            public boolean onAnnotationDeclared(Annotation a, IAnnotationContainer container) {
                if (container instanceof IFlagContainer) {
                    IFlagContainer fc = (IFlagContainer)container;
                    for (byte flag : ((Flags)a).value()) {
                        fc.setFlag(flag, true);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static interface Handler {
        public boolean onAnnotationDeclared(Annotation var1, IAnnotationContainer var2);
    }
}

