/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationShieldRegistry;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.preferences.PlayerPreferencesProperties;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        float blocker = RadiationShieldRegistry.getBlocker(event.block);
        if (blocker >= 0.99f) {
            return;
        }
        World world = event.world;
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.x;
        int y = event.y;
        int z = event.z;
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalCoordinate gc = entry.getKey();
            Coordinate c = gc.getCoordinate();
            if (!((float)Math.abs(c.getX() - x) < radius) || !((float)Math.abs(c.getY() - y) < radius) || !((float)Math.abs(c.getZ() - z) < radius)) continue;
            Logging.logDebug((String)("Removed blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.getX(), c.getY(), c.getZ());
            radiationTree.addBlocker(x, y, z, 1.0f);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        float blocker = RadiationShieldRegistry.getBlocker(event.block);
        if (blocker >= 0.99f) {
            return;
        }
        World world = event.blockSnapshot.world;
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.blockSnapshot.x;
        int y = event.blockSnapshot.y;
        int z = event.blockSnapshot.z;
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalCoordinate gc = entry.getKey();
            Coordinate c = gc.getCoordinate();
            if (!((float)Math.abs(c.getX() - x) < radius) || !((float)Math.abs(c.getY() - y) < radius) || !((float)Math.abs(c.getZ() - z) < radius)) continue;
            Logging.logDebug((String)("Add blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.getX(), c.getY(), c.getZ());
            radiationTree.addBlocker(x, y, z, blocker);
        }
    }

    @SubscribeEvent
    public void onEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        PlayerPreferencesProperties preferencesProperties;
        if (event.entity instanceof EntityPlayer && (preferencesProperties = (PlayerPreferencesProperties)event.entity.getExtendedProperties("McJtyLibPreferencesProperties")) == null) {
            preferencesProperties = new PlayerPreferencesProperties();
            event.entity.registerExtendedProperties("McJtyLibPreferencesProperties", (IExtendedEntityProperties)preferencesProperties);
        }
    }
}

