/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystals;

import java.util.Random;
import java.util.UUID;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.lib.entity.GenericTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ResonatingCrystalTileEntity
extends GenericTileEntity {
    private float strength = 1.0f;
    private float power = 1.0f;
    private float efficiency = 1.0f;
    private float purity = 1.0f;
    private float powerPerTick = -1.0f;
    private int rfPerTick = -1;
    private boolean glowing = false;

    public boolean canUpdate() {
        return false;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getPower() {
        return this.power;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getPurity() {
        return this.purity;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setStrength(float strength) {
        this.strength = strength;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPower(float power) {
        this.power = power;
        this.func_70296_d();
    }

    public void setEfficiency(float efficiency) {
        this.efficiency = efficiency;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPurity(float purity) {
        this.purity = purity;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setGlowing(boolean glowing) {
        if (this.glowing == glowing) {
            return;
        }
        this.glowing = glowing;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean setOwner(EntityPlayer player) {
        return false;
    }

    public String getOwnerName() {
        return "";
    }

    public UUID getOwnerUUID() {
        return null;
    }

    public float getPowerPerTick() {
        if (this.powerPerTick < 0.0f) {
            float totalRF = ResonatingCrystalTileEntity.getTotalPower(this.strength, this.purity);
            float numticks = totalRF / (float)this.getRfPerTick();
            this.powerPerTick = 100.0f / numticks;
        }
        return this.powerPerTick;
    }

    public static float getTotalPower(float strength, float purity) {
        return 1000.0f * (float)ConfigMachines.Power.maximumKiloRF * strength / 100.0f * (purity + 30.0f) / 130.0f;
    }

    public int getRfPerTick() {
        if (this.rfPerTick == -1) {
            this.rfPerTick = ResonatingCrystalTileEntity.getRfPerTick(this.efficiency, this.purity);
        }
        return this.rfPerTick;
    }

    public static int getRfPerTick(float efficiency, float purity) {
        return (int)((float)ConfigMachines.Power.maximumRFPerTick * efficiency / 100.1f * (purity + 2.0f) / 102.0f + 1.0f);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.strength = tagCompound.func_74760_g("strength");
        this.power = tagCompound.func_74760_g("power");
        this.efficiency = tagCompound.func_74760_g("efficiency");
        this.purity = tagCompound.func_74760_g("purity");
        this.glowing = tagCompound.func_74767_n("glowing");
        byte version = tagCompound.func_74771_c("version");
        if (version < 2) {
            this.power *= 20.0f;
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74776_a("strength", this.strength);
        tagCompound.func_74776_a("power", this.power);
        tagCompound.func_74776_a("efficiency", this.efficiency);
        tagCompound.func_74776_a("purity", this.purity);
        tagCompound.func_74757_a("glowing", this.glowing);
        tagCompound.func_74774_a("version", (byte)2);
    }

    public static void spawnRandomCrystal(World world, Random random, int x, int y, int z, int special) {
        world.func_147465_d(x, y, z, (Block)ModBlocks.resonatingCrystalBlock, 0, 3);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            if (special >= 3) {
                resonatingCrystalTileEntity.setStrength(100.0f);
                resonatingCrystalTileEntity.setPower(100.0f);
                resonatingCrystalTileEntity.setEfficiency(100.0f);
                resonatingCrystalTileEntity.setPurity(special == 4 ? 1.0f : 100.0f);
            } else {
                resonatingCrystalTileEntity.setStrength(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.01f);
                resonatingCrystalTileEntity.setPower(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 60.0f + 0.2f);
                resonatingCrystalTileEntity.setEfficiency(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.1f);
                resonatingCrystalTileEntity.setPurity(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 10.0f + 5.0f);
            }
        }
    }

    private static float getRandomSpecial(Random random, int special) {
        return special == 0 ? random.nextFloat() : (special == 1 ? 0.5f : 1.0f);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

