/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.gencontroller;

import java.util.HashSet;
import mcjty.deepresonance.blocks.gencontroller.ControllerSounds;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.varia.Broadcaster;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GeneratorControllerTileEntity
extends GenericTileEntity {
    private ControllerSounds controllerSounds;
    private int startup = 0;
    private int shutdown = 0;
    private boolean active = false;

    private ControllerSounds getControllerSounds() {
        if (this.controllerSounds == null) {
            this.controllerSounds = new ControllerSounds();
        }
        return this.controllerSounds;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    private void stopSounds() {
        this.getControllerSounds().stopStartup();
        this.getControllerSounds().stopLoop();
        this.getControllerSounds().stopShutdown();
    }

    public boolean canUpdate() {
        return true;
    }

    protected void checkStateClient() {
        if (GeneratorConfiguration.baseGeneratorVolume < 0.01f) {
            return;
        }
        ControllerSounds sounds = this.getControllerSounds();
        if (this.startup != 0) {
            sounds.stopLoop();
            sounds.stopShutdown();
            if (!sounds.isStartupPlaying()) {
                sounds.playStartup(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.shutdown != 0) {
            sounds.stopLoop();
            sounds.stopStartup();
            if (!sounds.isShutdownPlaying()) {
                sounds.playShutdown(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.active) {
            sounds.stopShutdown();
            sounds.stopStartup();
            if (!sounds.isLoopPlaying()) {
                sounds.playLoop(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.stopSounds();
        }
    }

    protected void checkStateServer() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean active = BlockTools.getRedstoneSignalIn((int)meta);
        boolean dirty = false;
        HashSet<Integer> networks = new HashSet<Integer>();
        Coordinate thisCoord = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            GeneratorTileEntity generatorTileEntity;
            int networkId;
            Coordinate newC = thisCoord.addDirection(direction);
            Block b = this.field_145850_b.func_147439_a(newC.getX(), newC.getY(), newC.getZ());
            if (b != GeneratorSetup.generatorBlock || (networkId = (generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(newC.getX(), newC.getY(), newC.getZ())).getNetworkId()) == -1 || networks.contains(networkId)) continue;
            networks.add(networkId);
            if (active) {
                int countCollectors = generatorTileEntity.getNetwork().getCollectorBlocks();
                if (countCollectors == 1) {
                    if (!this.handleActivate(networkId, newC)) continue;
                    dirty = true;
                    continue;
                }
                if (countCollectors < 1) {
                    Broadcaster.broadcast(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "There is no energy collector on this generator!", 100.0f);
                } else {
                    Broadcaster.broadcast(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "There are too many energy collectors on this generator!!", 100.0f);
                }
                if (!this.handleDeactivate(networkId, newC)) continue;
                dirty = true;
                continue;
            }
            if (!this.handleDeactivate(networkId, newC)) continue;
            dirty = true;
        }
        if (dirty) {
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
            generatorNetwork.save(this.field_145850_b);
        }
    }

    private boolean handleActivate(int id, Coordinate coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
        DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(id);
        if (network.isActive() && network.getShutdownCounter() == 0) {
            return false;
        }
        this.startup = network.getStartupCounter();
        if (this.startup == 0) {
            this.startup = GeneratorConfiguration.startupTime;
        }
        --this.startup;
        if (this.startup <= 0) {
            this.startup = 0;
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            generatorTileEntity.activate(true);
        }
        this.active = network.isActive();
        this.shutdown = 0;
        network.setShutdownCounter(0);
        network.setStartupCounter(this.startup);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    private boolean handleDeactivate(int id, Coordinate coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
        DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(id);
        if (!network.isActive() && network.getShutdownCounter() == 0 && network.getStartupCounter() == 0) {
            if (network.getShutdownCounter() != this.shutdown || network.getStartupCounter() != this.startup || network.isActive() != this.active) {
                this.shutdown = network.getShutdownCounter();
                this.startup = network.getStartupCounter();
                this.active = network.isActive();
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return false;
        }
        this.shutdown = network.getShutdownCounter();
        if (network.isActive() || network.getStartupCounter() != 0) {
            this.shutdown = GeneratorConfiguration.shutdownTime;
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            generatorTileEntity.activate(false);
        }
        --this.shutdown;
        if (this.shutdown <= 0) {
            this.shutdown = 0;
        }
        this.startup = 0;
        this.active = network.isActive();
        network.setStartupCounter(0);
        network.setShutdownCounter(this.shutdown);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.startup = tagCompound.func_74762_e("startup");
        this.shutdown = tagCompound.func_74762_e("shutdown");
        this.active = tagCompound.func_74767_n("active");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("startup", this.startup);
        tagCompound.func_74768_a("shutdown", this.shutdown);
        tagCompound.func_74757_a("active", this.active);
    }
}

