/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.generator;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import java.util.HashSet;
import java.util.Set;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.varia.EnergyTools;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class GeneratorTileEntity
extends GenericTileEntity
implements IEnergyProvider {
    private int networkId = -1;

    public void addBlockToNetwork() {
        HashSet<Integer> adjacentGeneratorIds = new HashSet<Integer>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int ox = this.field_145851_c + direction.offsetX;
            int oy = this.field_145848_d + direction.offsetY;
            int oz = this.field_145849_e + direction.offsetZ;
            Block block = this.field_145850_b.func_147439_a(ox, oy, oz);
            if (block != GeneratorSetup.generatorBlock) continue;
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(ox, oy, oz);
            adjacentGeneratorIds.add(generatorTileEntity.getNetworkId());
        }
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
        if (adjacentGeneratorIds.isEmpty()) {
            this.networkId = generatorNetwork.newChannel();
            DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setGeneratorBlocks(1);
        } else if (adjacentGeneratorIds.size() == 1) {
            this.networkId = (Integer)adjacentGeneratorIds.iterator().next();
            DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setActive(false);
            network.incGeneratorBlocks();
        } else {
            int energy = 0;
            for (Integer netId : adjacentGeneratorIds) {
                DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(netId);
                network.setActive(false);
                energy += network.getEnergy();
            }
            int id = (Integer)adjacentGeneratorIds.iterator().next();
            HashSet<Coordinate> done = new HashSet<Coordinate>();
            this.setBlocksToNetwork(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), done, id);
            DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setEnergy(energy);
        }
        generatorNetwork.save(this.field_145850_b);
    }

    private void setBlocksToNetwork(Coordinate c, Set<Coordinate> done, int newId) {
        done.add(c);
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
        GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
        int oldNetworkId = generatorTileEntity.getNetworkId();
        if (oldNetworkId != newId) {
            if (oldNetworkId != -1) {
                generatorNetwork.getOrCreateNetwork(oldNetworkId).decGeneratorBlocks();
            }
            generatorTileEntity.setNetworkId(newId);
            if (newId != -1) {
                generatorNetwork.getOrCreateNetwork(newId).incGeneratorBlocks();
            }
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Block block;
            Coordinate newC = c.addDirection(direction);
            if (done.contains(newC) || (block = this.field_145850_b.func_147439_a(newC.getX(), newC.getY(), newC.getZ())) != GeneratorSetup.generatorBlock) continue;
            this.setBlocksToNetwork(newC, done, newId);
        }
    }

    public void removeBlockFromNetwork() {
        DRGeneratorNetwork generatorNetwork;
        Coordinate thisCoord = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int totalEnergy = 0;
        int totalBlocks = 0;
        if (this.networkId != -1) {
            generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
            DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setActive(false);
            network.decGeneratorBlocks();
            totalEnergy = network.getEnergy();
            totalBlocks = network.getGeneratorBlocks();
            this.setNetworkId(-1);
        }
        if (totalBlocks < 1) {
            totalBlocks = 1;
        }
        generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Coordinate newC = thisCoord.addDirection(direction);
            Block block = this.field_145850_b.func_147439_a(newC.getX(), newC.getY(), newC.getZ());
            if (block != GeneratorSetup.generatorBlock) continue;
            HashSet<Coordinate> done = new HashSet<Coordinate>();
            done.add(thisCoord);
            this.setBlocksToNetwork(newC, done, -1);
        }
        int idToUse = this.networkId;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            GeneratorTileEntity generatorTileEntity;
            Coordinate newC = thisCoord.addDirection(direction);
            Block block = this.field_145850_b.func_147439_a(newC.getX(), newC.getY(), newC.getZ());
            if (block != GeneratorSetup.generatorBlock || (generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(newC.getX(), newC.getY(), newC.getZ())).getNetworkId() != -1) continue;
            if (idToUse == -1) {
                idToUse = generatorNetwork.newChannel();
            }
            HashSet<Coordinate> done = new HashSet<Coordinate>();
            done.add(thisCoord);
            this.setBlocksToNetwork(newC, done, idToUse);
            generatorNetwork.getOrCreateNetwork(idToUse).setEnergy(-1);
            idToUse = -1;
        }
        int energy = totalEnergy / totalBlocks;
        int remainder = totalEnergy % totalBlocks;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            GeneratorTileEntity generatorTileEntity;
            DRGeneratorNetwork.Network network;
            Coordinate newC = thisCoord.addDirection(direction);
            Block block = this.field_145850_b.func_147439_a(newC.getX(), newC.getY(), newC.getZ());
            if (block != GeneratorSetup.generatorBlock || (network = (generatorTileEntity = (GeneratorTileEntity)this.field_145850_b.func_147438_o(newC.getX(), newC.getY(), newC.getZ())).getNetwork()).getEnergy() != -1) continue;
            network.setEnergy(energy * network.getGeneratorBlocks() + remainder);
            remainder = 0;
        }
        generatorNetwork.save(this.field_145850_b);
    }

    public void setNetworkId(int newId) {
        this.networkId = newId;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public DRGeneratorNetwork.Network getNetwork() {
        if (this.networkId == -1) {
            return null;
        }
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
        return generatorNetwork.getOrCreateNetwork(this.networkId);
    }

    public void activate(boolean active) {
        DRGeneratorNetwork.Network network = this.getNetwork();
        if (network != null && network.isActive() != active) {
            network.setActive(active);
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
            generatorNetwork.save(this.field_145850_b);
            HashSet<Coordinate> done = new HashSet<Coordinate>();
            this.activateBlocks(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), done, active);
        }
    }

    private void activateBlocks(Coordinate c, Set<Coordinate> done, boolean active) {
        done.add(c);
        int meta = this.field_145850_b.func_72805_g(c.getX(), c.getY(), c.getZ());
        if ((meta & 1) == 0 == active) {
            if (active) {
                this.field_145850_b.func_72921_c(c.getX(), c.getY(), c.getZ(), meta | 1, 3);
            } else {
                this.field_145850_b.func_72921_c(c.getX(), c.getY(), c.getZ(), meta & 0xFFFFFFFE, 3);
            }
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Block block;
            Coordinate newC = c.addDirection(direction);
            if (done.contains(newC) || (block = this.field_145850_b.func_147439_a(newC.getX(), newC.getY(), newC.getZ())) != GeneratorSetup.generatorBlock) continue;
            this.activateBlocks(newC, done, active);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.networkId = tagCompound.func_74762_e("networkId");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("networkId", this.networkId);
    }

    protected void checkStateServer() {
        int energyStored = this.getEnergyStored(ForgeDirection.DOWN);
        if (energyStored <= 0) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int rfToGive;
            int received;
            ForgeDirection opposite;
            IEnergyConnection connection;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int x = this.field_145851_c + dir.offsetX;
            int y = this.field_145848_d + dir.offsetY;
            int z = this.field_145849_e + dir.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (EnergyTools.isEnergyTE(te) && (connection = (IEnergyConnection)te).canConnectEnergy(opposite = dir.getOpposite()) && (energyStored -= this.extractEnergy(ForgeDirection.DOWN, received = EnergyTools.receiveEnergy(te, opposite, rfToGive = GeneratorConfiguration.rfPerTickGenerator <= energyStored ? GeneratorConfiguration.rfPerTickGenerator : energyStored), false)) <= 0) break;
        }
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.networkId == -1) {
            return 0;
        }
        DRGeneratorNetwork.Network network = this.getNetwork();
        int energy = network.getEnergy();
        if (maxExtract > energy) {
            maxExtract = energy;
        }
        if (maxExtract > GeneratorConfiguration.rfPerTickGenerator) {
            maxExtract = GeneratorConfiguration.rfPerTickGenerator;
        }
        if (!simulate) {
            network.setEnergy(energy - maxExtract);
            DRGeneratorNetwork.getChannels(this.field_145850_b).save(this.field_145850_b);
        }
        return maxExtract;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.networkId == -1) {
            return 0;
        }
        DRGeneratorNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.networkId == -1) {
            return 0;
        }
        DRGeneratorNetwork.Network network = this.getNetwork();
        return network.getGeneratorBlocks() * GeneratorConfiguration.rfPerGeneratorBlock;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

