/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.pedestal;

import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.collector.EnergyCollectorSetup;
import mcjty.deepresonance.blocks.collector.EnergyCollectorTileEntity;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.blocks.pedestal.PedestalContainer;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.varia.InventoryLocator;
import mcjty.deepresonance.varia.Tools;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class PedestalTileEntity
extends GenericTileEntity
implements IInventory {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PedestalContainer.factory, 1);
    private int checkCounter = 0;
    private InventoryLocator inventoryLocator = new InventoryLocator();
    private Coordinate cachedLocator = null;
    private static ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.DOWN};

    public boolean canUpdate() {
        return true;
    }

    protected void checkStateServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 20;
        ForgeDirection orientation = BlockTools.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        int xx = this.field_145851_c + orientation.offsetX;
        int yy = this.field_145848_d + orientation.offsetY;
        int zz = this.field_145849_e + orientation.offsetZ;
        Block block = this.field_145850_b.func_147439_a(xx, yy, zz);
        if (block.isAir((IBlockAccess)this.field_145850_b, xx, yy, zz)) {
            this.placeCrystal(xx, yy, zz);
        } else if (block == ModBlocks.resonatingCrystalBlock) {
            this.checkCrystal(xx, yy, zz);
        }
    }

    private void placeCrystal(int xx, int yy, int zz) {
        ItemStack crystalStack = this.inventoryHelper.getStackInSlot(0);
        if (crystalStack != null && crystalStack.field_77994_a > 0 && crystalStack.func_77973_b() instanceof ItemBlock) {
            TileEntity tileEntity;
            ItemBlock itemBlock = (ItemBlock)crystalStack.func_77973_b();
            itemBlock.placeBlockAt(crystalStack, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)), this.field_145850_b, xx, yy, zz, 0, 0.0f, 0.0f, 0.0f, 0);
            this.inventoryHelper.decrStackSize(0, 1);
            Tools.playSound(this.field_145850_b, ModBlocks.resonatingCrystalBlock.field_149762_H.func_150495_a(), xx, yy, zz, 1.0, 1.0);
            if (this.findCollector(xx, yy, zz) && (tileEntity = this.field_145850_b.func_147438_o(this.cachedLocator.getX(), this.cachedLocator.getY(), this.cachedLocator.getZ())) instanceof EnergyCollectorTileEntity) {
                EnergyCollectorTileEntity energyCollectorTileEntity = (EnergyCollectorTileEntity)tileEntity;
                energyCollectorTileEntity.addCrystal(xx, yy, zz);
            }
        }
    }

    private void checkCrystal(int xx, int yy, int zz) {
        ResonatingCrystalTileEntity resonatingCrystalTileEntity;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(xx, yy, zz);
        if (tileEntity instanceof ResonatingCrystalTileEntity && (resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)tileEntity).getPower() <= 1.0E-5f) {
            ItemStack spentCrystal = new ItemStack((Block)ModBlocks.resonatingCrystalBlock, 1);
            NBTTagCompound tagCompound = new NBTTagCompound();
            resonatingCrystalTileEntity.func_145841_b(tagCompound);
            spentCrystal.func_77982_d(tagCompound);
            this.inventoryLocator.ejectStack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, spentCrystal, this.getCoordinate(), directions);
            this.field_145850_b.func_147468_f(xx, yy, zz);
            Tools.playSound(this.field_145850_b, ModBlocks.resonatingCrystalBlock.field_149762_H.func_150495_a(), xx, yy, zz, 1.0, 1.0);
        }
    }

    private boolean findCollector(int xx, int yy, int zz) {
        if (this.cachedLocator != null) {
            if (this.field_145850_b.func_147439_a(xx, yy, zz) == EnergyCollectorSetup.energyCollectorBlock) {
                return true;
            }
            this.cachedLocator = null;
        }
        Coordinate crystalLocation = new Coordinate(xx, yy, zz);
        float closestDistance = Float.MAX_VALUE;
        for (int y = yy - ConfigMachines.Collector.maxVerticalCrystalDistance; y <= yy + ConfigMachines.Collector.maxVerticalCrystalDistance; ++y) {
            if (y < 0 || y >= this.field_145850_b.func_72800_K()) continue;
            int maxhordist = ConfigMachines.Collector.maxHorizontalCrystalDistance;
            for (int x = xx - maxhordist; x <= xx + maxhordist; ++x) {
                for (int z = zz - maxhordist; z <= zz + maxhordist; ++z) {
                    Coordinate locator;
                    float sqdist;
                    if (this.field_145850_b.func_147439_a(x, y, z) != EnergyCollectorSetup.energyCollectorBlock || !((sqdist = (locator = new Coordinate(x, y, z)).squaredDistance(crystalLocation)) < closestDistance)) continue;
                    closestDistance = sqdist;
                    this.cachedLocator = locator;
                }
            }
        }
        return this.cachedLocator != null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Pedestal Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
    }
}

