/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.tank;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.base.ElecGenericBlockBase;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.client.ClientHandler;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.deepresonance.network.PacketGetTankInfo;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class BlockTank
extends ElecGenericBlockBase {
    private IIcon iconSideProvide;
    private IIcon iconSideAccept;
    private IIcon iconTopProvide;
    private IIcon iconTopAccept;
    private IIcon iconBottomProvide;
    private IIcon iconBottomAccept;
    private long lastTime;
    public int totalFluidAmount = 0;
    public int tankCapacity = 0;
    public LiquidCrystalFluidTagData fluidData = null;
    public Fluid clientRenderFluid = null;

    public BlockTank(String name) {
        super(Material.field_151576_e, TileTank.class, name);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        FluidStack fluidStack;
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (fluidStack = TileTank.getFluidStackFromNBT(tagCompound)) != null) {
            list.add(EnumChatFormatting.GREEN + "Fluid: " + DRFluidRegistry.getFluidName(fluidStack));
            list.add(EnumChatFormatting.GREEN + "Amount: " + DRFluidRegistry.getAmount(fluidStack) + " mb");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("This tank can hold up to 16 buckets of liquid.");
            list.add("It is also capable of mixing the characteristics");
            list.add("of liquid crystal.");
            list.add("Place a comparator next to this tank to detect");
            list.add("how filled the tank is");
        } else {
            list.add(EnumChatFormatting.WHITE + ClientHandler.getShiftMessage());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileTank tankTile = (TileTank)accessor.getTileEntity();
        Map<ForgeDirection, Integer> settings = tankTile.getSettings();
        int i = settings.get(accessor.getSide());
        currentTip.add("Mode: " + (i == 0 ? "none" : (i == 1 ? "accept" : "provide")));
        currentTip.add("Fluid: " + DRFluidRegistry.getFluidName(this.clientRenderFluid));
        currentTip.add("Amount: " + this.totalFluidAmount + " (" + this.tankCapacity + ")");
        if (this.fluidData != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            currentTip.add(EnumChatFormatting.YELLOW + "Quality: " + decimalFormat.format(this.fluidData.getQuality() * 100.0f) + "%");
            currentTip.add(EnumChatFormatting.YELLOW + "Purity: " + decimalFormat.format(this.fluidData.getPurity() * 100.0f) + "%");
            currentTip.add(EnumChatFormatting.YELLOW + "Power: " + decimalFormat.format(this.fluidData.getStrength() * 100.0f) + "%");
            currentTip.add(EnumChatFormatting.YELLOW + "Efficiency: " + decimalFormat.format(this.fluidData.getEfficiency() * 100.0f) + "%");
        }
        if (System.currentTimeMillis() - this.lastTime > 100L) {
            this.lastTime = System.currentTimeMillis();
            DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketGetTankInfo(tankTile.field_145851_c, tankTile.field_145848_d, tankTile.field_145849_e));
        }
        return currentTip;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileTank tank;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTank && (tank = (TileTank)tile).getMultiBlock() != null) {
            return tank.getMultiBlock().getComparatorInputOverride();
        }
        return 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            for (Map.Entry<ITankHook, ForgeDirection> entry : tank.getConnectedHooks().entrySet()) {
                entry.getKey().hook(tank, entry.getValue());
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sidex, float sidey, float sidez) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTank) {
            ForgeDirection direction;
            int i;
            TileTank tank = (TileTank)tile;
            if (player.func_70694_bm() != null) {
                if (FluidContainerRegistry.isEmptyContainer((ItemStack)player.func_70694_bm())) {
                    if (!world.field_72995_K) {
                        this.extractIntoContainer(player, tank);
                    }
                    return true;
                }
                if (FluidContainerRegistry.isFilledContainer((ItemStack)player.func_70694_bm())) {
                    if (!world.field_72995_K) {
                        this.fillFromContainer(player, tank);
                    }
                    return true;
                }
            }
            i = (i = tank.settings.get(direction = ForgeDirection.getOrientation((int)side)).intValue()) < 2 ? ++i : 0;
            tank.settings.put(direction, i);
            tank.func_70296_d();
            world.func_147471_g(x, y, z);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, side, sidex, sidey, sidez);
    }

    private void fillFromContainer(EntityPlayer player, TileTank tank) {
        int fill;
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.func_70694_bm());
        if (fluidStack != null && (fill = tank.fill(ForgeDirection.UNKNOWN, fluidStack, false)) == fluidStack.amount) {
            tank.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)player.func_70694_bm());
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptyContainer);
            }
        }
    }

    private void extractIntoContainer(EntityPlayer player, TileTank tank) {
        int capacity;
        FluidStack fluidStack = tank.drain(ForgeDirection.UNKNOWN, 1, false);
        if (fluidStack != null && (capacity = FluidContainerRegistry.getContainerCapacity((FluidStack)fluidStack, (ItemStack)player.func_70694_bm())) != 0 && (fluidStack = tank.drain(ForgeDirection.UNKNOWN, capacity, false)) != null && fluidStack.amount == capacity) {
            fluidStack = tank.drain(ForgeDirection.UNKNOWN, capacity, true);
            ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)player.func_70694_bm());
            if (filledContainer != null) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                if (!player.field_71071_by.func_70441_a(filledContainer)) {
                    EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, filledContainer);
                    player.field_70170_p.func_72838_d((Entity)entityItem);
                }
                player.field_71070_bA.func_75142_b();
            } else {
                tank.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileTank tank;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTank && (tank = (TileTank)tile).getClientRenderFluid() != null) {
            return tank.getClientRenderFluid().getLuminosity();
        }
        return super.getLightValue(world, x, y, z);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public String getTopIconName() {
        return "tankTop";
    }

    public String getBottomIconName() {
        return "tankBottom";
    }

    public String getSideIconName() {
        return "tankSide";
    }

    public IIcon getSideIcon() {
        return this.iconSide;
    }

    public IIcon getBottomIcon() {
        return this.iconBottom;
    }

    public IIcon getTopIcon() {
        return this.iconTop;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconSideAccept = iconRegister.func_94245_a(this.modBase.getModId() + ":tankSideAccept");
        this.iconSideProvide = iconRegister.func_94245_a(this.modBase.getModId() + ":tankSideProvide");
        this.iconTopAccept = iconRegister.func_94245_a(this.modBase.getModId() + ":tankTopAccept");
        this.iconTopProvide = iconRegister.func_94245_a(this.modBase.getModId() + ":tankTopProvide");
        this.iconBottomAccept = iconRegister.func_94245_a(this.modBase.getModId() + ":tankBottomAccept");
        this.iconBottomProvide = iconRegister.func_94245_a(this.modBase.getModId() + ":tankBottomProvide");
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z) != this;
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileTank) {
            TileTank tileTank = (TileTank)te;
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (dir == ForgeDirection.DOWN) {
                if (tileTank.isInput(dir)) {
                    return this.iconBottomAccept;
                }
                if (tileTank.isOutput(dir)) {
                    return this.iconBottomProvide;
                }
                return this.iconBottom;
            }
            if (dir == ForgeDirection.UP) {
                if (tileTank.isInput(dir)) {
                    return this.iconTopAccept;
                }
                if (tileTank.isOutput(dir)) {
                    return this.iconTopProvide;
                }
                return this.iconTop;
            }
            if (tileTank.isInput(dir)) {
                return this.iconSideAccept;
            }
            if (tileTank.isOutput(dir)) {
                return this.iconSideProvide;
            }
            return this.iconSide;
        }
        return this.func_149691_a(side, 0);
    }

    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (dir == ForgeDirection.DOWN) {
            return this.iconBottom;
        }
        if (dir == ForgeDirection.UP) {
            return this.iconTop;
        }
        return this.iconSide;
    }
}

