/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.tank;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.Event;
import elec332.core.multiblock.dynamic.AbstractDynamicMultiBlockWorldHolder;
import elec332.core.multiblock.dynamic.IDynamicMultiBlockTile;
import elec332.core.util.BlockLoc;
import elec332.core.world.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.api.fluid.IDeepResonanceFluidAcceptor;
import mcjty.deepresonance.api.fluid.IDeepResonanceFluidProvider;
import mcjty.deepresonance.blocks.base.ElecTileBase;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.grid.fluid.event.FluidTileEvent;
import mcjty.deepresonance.grid.tank.DRTankMultiBlock;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTank
extends ElecTileBase
implements IDynamicMultiBlockTile<DRTankMultiBlock>,
IFluidHandler,
IDeepResonanceFluidAcceptor,
IDeepResonanceFluidProvider {
    public static final int SETTING_NONE = 0;
    public static final int SETTING_ACCEPT = 1;
    public static final int SETTING_PROVIDE = 2;
    public static final int SETTING_MAX = 2;
    private Fluid clientRenderFluid;
    private float renderHeight;
    private NBTTagCompound multiBlockSaveData;
    protected Map<ForgeDirection, Integer> settings = Maps.newHashMap();
    private DRTankMultiBlock multiBlock;
    public FluidStack myTank;
    public Fluid lastSeenFluid;

    public TileTank() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.settings.put(direction, 0);
        }
        this.multiBlockSaveData = new NBTTagCompound();
    }

    @Override
    public void onTileLoaded() {
        super.onTileLoaded();
        if (!this.field_145850_b.field_72995_K) {
            ((AbstractDynamicMultiBlockWorldHolder)DeepResonance.worldGridRegistry.getTankRegistry().get(this.func_145831_w())).addTile((TileEntity)this);
            MinecraftForge.EVENT_BUS.post((Event)new FluidTileEvent.Load((TileEntity)this));
            for (Map.Entry<ITankHook, ForgeDirection> entry : this.getConnectedHooks().entrySet()) {
                entry.getKey().hook(this, entry.getValue());
            }
        }
    }

    @Override
    public void onTileUnloaded() {
        super.onTileUnloaded();
        if (!this.field_145850_b.field_72995_K) {
            ((AbstractDynamicMultiBlockWorldHolder)DeepResonance.worldGridRegistry.getTankRegistry().get(this.func_145831_w())).removeTile((TileEntity)this);
            MinecraftForge.EVENT_BUS.post((Event)new FluidTileEvent.Unload((TileEntity)this));
            for (Map.Entry<ITankHook, ForgeDirection> entry : this.getConnectedHooks().entrySet()) {
                entry.getKey().unHook(this, entry.getValue());
            }
        }
    }

    public Map<ForgeDirection, Integer> getSettings() {
        return this.settings;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("settings", 10);
        if (tagList != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                this.settings.put(ForgeDirection.valueOf((String)tag.func_74779_i("dir")), tag.func_74762_e("n"));
            }
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<ForgeDirection, Integer> entry : this.settings.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("dir", entry.getKey().toString());
            tag.func_74768_a("n", entry.getValue().intValue());
            tagList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("settings", (NBTBase)tagList);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.myTank = TileTank.getFluidStackFromNBT(tagCompound);
        this.multiBlockSaveData = tagCompound.func_74775_l("multiBlockData");
        if (tagCompound.func_74764_b("lastSeenFluid")) {
            this.lastSeenFluid = FluidRegistry.getFluid((String)tagCompound.func_74779_i("lastSeenFluid"));
        } else if (this.multiBlockSaveData.func_74764_b("lastSeenFluid")) {
            this.lastSeenFluid = FluidRegistry.getFluid((String)this.multiBlockSaveData.func_74779_i("lastSeenFluid"));
        }
    }

    public static FluidStack getFluidStackFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound mbTag = tagCompound.func_74775_l("multiBlockData");
        Object s = tagCompound.func_74764_b("fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("fluid")) : (mbTag.func_74764_b("fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)mbTag.func_74775_l("fluid")) : null);
        return s;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.multiBlock != null) {
            this.getMultiBlock().setDataToTile(this);
        }
        tagCompound.func_74782_a("multiBlockData", (NBTBase)this.multiBlockSaveData);
    }

    public boolean canUpdate() {
        return false;
    }

    public void setMultiBlock(DRTankMultiBlock multiBlock) {
        this.multiBlock = multiBlock;
    }

    public DRTankMultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public void setSaveData(NBTTagCompound nbtTagCompound) {
        this.multiBlockSaveData = nbtTagCompound;
    }

    public NBTTagCompound getSaveData() {
        return this.multiBlockSaveData;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isInput(from)) {
            return 0;
        }
        this.notifyChanges(doFill);
        return this.multiBlock == null ? 0 : this.multiBlock.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.isOutput(from)) {
            return null;
        }
        this.notifyChanges(doDrain);
        return this.multiBlock == null ? null : this.multiBlock.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.isOutput(from)) {
            return null;
        }
        this.notifyChanges(doDrain);
        return this.multiBlock == null ? null : this.multiBlock.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.isInput(from) && this.multiBlock != null && this.multiBlock.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.isOutput(from) && this.multiBlock != null && this.multiBlock.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.multiBlock == null ? new FluidTankInfo[]{} : this.multiBlock.getTankInfo(from);
    }

    @Override
    public boolean canAcceptFrom(ForgeDirection direction) {
        return this.isInput(direction);
    }

    @Override
    public boolean canProvideTo(ForgeDirection direction) {
        return this.isOutput(direction);
    }

    @Override
    public FluidStack getProvidedFluid(int maxProvided, ForgeDirection from) {
        if (!this.isOutput(from)) {
            return null;
        }
        return this.getMultiBlock() == null ? null : this.getMultiBlock().drain(maxProvided, true);
    }

    @Override
    public int getRequestedAmount(ForgeDirection from) {
        if (!this.isInput(from)) {
            return 0;
        }
        return this.multiBlock == null ? 0 : Math.min(this.multiBlock.getFreeSpace(), 1000);
    }

    @Override
    public FluidStack acceptFluid(FluidStack fluidStack, ForgeDirection from) {
        if (!this.isInput(from)) {
            this.fill(from, fluidStack, true);
            this.notifyChanges(true);
            return null;
        }
        return fluidStack;
    }

    public Fluid getClientRenderFluid() {
        return this.clientRenderFluid;
    }

    public float getRenderHeight() {
        return this.renderHeight;
    }

    public FluidStack getFluid() {
        return this.multiBlock == null ? null : this.multiBlock.getFluid();
    }

    public NBTTagCompound getFluidTag() {
        return this.getFluid() == null ? null : this.getFluid().tag;
    }

    public int getFluidAmount() {
        return this.multiBlock == null ? 0 : this.multiBlock.getFluidAmount();
    }

    public int getCapacity() {
        return this.multiBlock == null ? 0 : this.multiBlock.getCapacity();
    }

    private void notifyChanges(boolean b) {
        if (this.multiBlock != null && b) {
            for (Map.Entry<ITankHook, ForgeDirection> entry : this.getConnectedHooks().entrySet()) {
                entry.getKey().onContentChanged(this, entry.getValue());
            }
        }
    }

    protected Map<ITankHook, ForgeDirection> getConnectedHooks() {
        HashMap ret = Maps.newHashMap();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            try {
                TileEntity tile = WorldHelper.getTileAt((IBlockAccess)this.field_145850_b, (BlockLoc)this.myLocation().atSide(direction));
                if (!(tile instanceof ITankHook)) continue;
                ret.put((ITankHook)tile, direction.getOpposite());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public boolean isInput(ForgeDirection direction) {
        return direction == ForgeDirection.UNKNOWN || this.settings.get(direction) == 1;
    }

    public boolean isOutput(ForgeDirection direction) {
        return direction == ForgeDirection.UNKNOWN || this.settings.get(direction) == 2;
    }

    @Override
    public void onDataPacket(int id, NBTTagCompound tag) {
        switch (id) {
            case 1: {
                this.clientRenderFluid = FluidRegistry.getFluid((String)tag.func_74779_i("fluid"));
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                this.renderHeight = tag.func_74760_g("render");
            }
        }
    }
}

