/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.valve;

import java.awt.Rectangle;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.valve.ValveContainer;
import mcjty.deepresonance.blocks.valve.ValveTileEntity;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiValve
extends GenericGuiContainer<ValveTileEntity> {
    public static final int VALVE_WIDTH = 180;
    public static final int VALVE_HEIGHT = 152;
    private static final ResourceLocation iconLocation = new ResourceLocation("deepresonance", "textures/gui/valve.png");
    private TextField minPurity;
    private TextField minStrength;
    private TextField minEfficiency;
    private TextField maxAmount;

    public GuiValve(ValveTileEntity valveTileEntity, ValveContainer container) {
        super((ModBase)DeepResonance.instance, DeepResonance.networkHandler.getNetworkWrapper(), (GenericTileEntity)valveTileEntity, (Container)container, 0, "valve");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        Panel inputPanel = this.setupInputPanel();
        Panel outputPanel = this.setupOutputPanel();
        Button applyButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Apply")).setTooltips(new String[]{"Apply the new setting"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(112, 49, 60, 14))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiValve.this.updateSettings();
            }
        });
        ((Panel)((Panel)toplevel.addChild((Widget)inputPanel)).addChild((Widget)outputPanel)).addChild((Widget)applyButton);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private Panel setupOutputPanel() {
        this.maxAmount = (TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"The maximum amount of liquid", "in the bottom tank"});
        ((TextField)this.maxAmount.setText(Integer.toString(((ValveTileEntity)this.tileEntity).getMaxMb())).setDesiredWidth(45)).setDesiredHeight(15);
        return (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(2)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Max mb").setDesiredWidth(50).setDesiredHeight(15))).addChild((Widget)this.maxAmount)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(112, 6, 60, 40));
    }

    private Panel setupInputPanel() {
        this.minPurity = (TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"The minimum purity % to", "accept the liquid"});
        this.minStrength = (TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"The minimum strength % to", "accept the liquid"});
        this.minEfficiency = (TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"The minimum efficiency % to", "accept the liquid"});
        ((TextField)this.minPurity.setText(Integer.toString((int)(((ValveTileEntity)this.tileEntity).getMinPurity() * 100.0f))).setDesiredWidth(30)).setDesiredHeight(15);
        ((TextField)this.minStrength.setText(Integer.toString((int)(((ValveTileEntity)this.tileEntity).getMinStrength() * 100.0f))).setDesiredWidth(30)).setDesiredHeight(15);
        ((TextField)this.minEfficiency.setText(Integer.toString((int)(((ValveTileEntity)this.tileEntity).getMinEfficiency() * 100.0f))).setDesiredWidth(30)).setDesiredHeight(15);
        Panel purityPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("Purity").setDesiredWidth(50))).addChild((Widget)this.minPurity);
        Panel strengthPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("Strength").setDesiredWidth(50))).addChild((Widget)this.minStrength);
        Panel efficiencyPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("Efficiency").setDesiredWidth(50))).addChild((Widget)this.minEfficiency);
        return (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(3)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).addChild((Widget)purityPanel)).addChild((Widget)strengthPanel)).addChild((Widget)efficiencyPanel)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(9, 6, 100, 58));
    }

    private void updateSettings() {
        int purity = 0;
        try {
            purity = Integer.parseInt(this.minPurity.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int strength = 0;
        try {
            strength = Integer.parseInt(this.minStrength.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int efficiency = 0;
        try {
            efficiency = Integer.parseInt(this.minEfficiency.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int maxMb = 0;
        try {
            maxMb = Integer.parseInt(this.maxAmount.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        ((ValveTileEntity)this.tileEntity).setMinPurity((float)purity / 100.0f);
        ((ValveTileEntity)this.tileEntity).setMinStrength((float)strength / 100.0f);
        ((ValveTileEntity)this.tileEntity).setMinEfficiency((float)efficiency / 100.0f);
        ((ValveTileEntity)this.tileEntity).setMaxMb(maxMb);
        this.sendServerCommand(DeepResonance.networkHandler.getNetworkWrapper(), ValveTileEntity.CMD_SETTINGS, new Argument[]{new Argument("purity", (double)((float)purity / 100.0f)), new Argument("strength", (double)((float)strength / 100.0f)), new Argument("efficiency", (double)((float)efficiency / 100.0f)), new Argument("maxMb", maxMb)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

