/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.boom;

import elec332.core.explosion.Elexplosion;
import elec332.core.util.BlockLoc;
import elec332.core.world.WorldHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TestExplosion
extends Elexplosion {
    public TestExplosion(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    protected void preExplode() {
        this.damageEntities(this.getRadius(), 4.0f);
    }

    protected void doExplode() {
        if (!this.getWorld().field_72995_K) {
            int x = (int)(-this.getRadius());
            while ((float)x < this.getRadius()) {
                int y = (int)(-this.getRadius());
                while ((float)y < this.getRadius()) {
                    int z = (int)(-this.getRadius());
                    while ((float)z < this.getRadius()) {
                        Block block;
                        BlockLoc targetPosition = this.getLocation().copy().translate(new BlockLoc(x, y, z));
                        double dist = this.getLocation().distance(targetPosition);
                        if (dist < (double)this.getRadius() && (block = WorldHelper.getBlockAt((IBlockAccess)this.getWorld(), (BlockLoc)targetPosition)) != null && !block.isAir((IBlockAccess)this.getWorld(), targetPosition.xCoord, targetPosition.yCoord, targetPosition.zCoord) && block != Blocks.field_150357_h && (dist < (double)(this.getRadius() - 1.0f) || (double)this.getWorld().field_73012_v.nextFloat() > 0.7)) {
                            block.onBlockExploded(this.getWorld(), targetPosition.xCoord, targetPosition.yCoord, targetPosition.zCoord, (Explosion)this);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    protected void damageEntities(float radius, float power) {
        if (!this.getWorld().field_72995_K) {
            BlockLoc minCoord = this.getLocation().copy();
            minCoord.add(-(radius *= 2.0f) - 1.0f);
            BlockLoc maxCoord = this.getLocation().copy();
            maxCoord.add(radius + 1.0f);
            List allEntities = this.getWorld().func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)minCoord.xCoord, (double)minCoord.yCoord, (double)minCoord.zCoord, (double)maxCoord.xCoord, (double)maxCoord.yCoord, (double)maxCoord.zCoord));
            for (Entity entity : allEntities) {
                double distance = entity.func_70011_f((double)this.getLocation().xCoord, (double)this.getLocation().yCoord, (double)this.getLocation().zCoord) / (double)radius;
                if (!(distance <= 1.0)) continue;
                double xDifference = entity.field_70165_t - (double)this.getLocation().xCoord;
                double yDifference = entity.field_70163_u - (double)this.getLocation().yCoord;
                double zDifference = entity.field_70161_v - (double)this.getLocation().zCoord;
                double d1 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
                xDifference /= d1;
                yDifference /= d1;
                zDifference /= d1;
                double density = this.getWorld().func_72842_a(Vec3.func_72443_a((double)this.getLocation().xCoord, (double)this.getLocation().yCoord, (double)this.getLocation().zCoord), entity.field_70121_D);
                double d2 = (1.0 - distance) * density;
                int damage = (int)((d2 * d2 + d2) / 2.0 * 8.0 * (double)power + 1.0);
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
                entity.field_70159_w += xDifference * d2;
                entity.field_70181_x += yDifference * d2;
                entity.field_70179_y += zDifference * d2;
            }
        }
    }
}

