/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.grid;

import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InternalGridTank {
    private int maxAmount;
    private LiquidCrystalFluidTagData tank;
    private FluidTank extraTank;

    public InternalGridTank(int maxAmount) {
        this.maxAmount = maxAmount;
        this.tank = LiquidCrystalFluidTagData.fromNBT(new NBTTagCompound(), 0);
        this.extraTank = new FluidTank(maxAmount);
    }

    public int getStoredAmount() {
        return this.tank.getInternalTankAmount() == 0 ? this.extraTank.getFluidAmount() : this.tank.getInternalTankAmount();
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public Fluid getStoredFluid() {
        FluidStack stored = this.getStoredFluidStack();
        return stored == null ? null : this.getStoredFluidStack().getFluid();
    }

    public FluidStack getStoredFluidStack() {
        return this.tank.getInternalTankAmount() > 0 ? this.tank.getReferenceStack() : (this.extraTank.getFluid() == null ? null : this.extraTank.getFluid().copy());
    }

    public int fill(FluidStack stack, boolean doFill) {
        if (DRFluidRegistry.isValidLiquidCrystalStack(stack)) {
            if (this.extraTank.getFluidAmount() > 0) {
                return 0;
            }
            int ret = stack.amount;
            int compare = this.tank.getInternalTankAmount() + stack.amount;
            FluidStack toAdd = stack.copy();
            if (compare > this.maxAmount) {
                ret = toAdd.amount = this.maxAmount - this.tank.getInternalTankAmount();
            }
            if (doFill) {
                this.tank.merge(LiquidCrystalFluidTagData.fromStack(toAdd));
            }
            return ret;
        }
        if (this.tank.getInternalTankAmount() > 0) {
            return 0;
        }
        return this.extraTank.fill(stack, doFill);
    }

    public FluidStack drain(int toRemoveMax, boolean doDrain) {
        if (this.tank.getInternalTankAmount() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            this.tank.writeDataToNBT(tag);
            int stored = this.tank.getInternalTankAmount();
            if (toRemoveMax > stored) {
                toRemoveMax = stored;
            }
            if (doDrain) {
                this.tank.setInternalAmount(stored - toRemoveMax);
            }
            return new FluidStack(DRFluidRegistry.liquidCrystal, toRemoveMax, tag);
        }
        return this.extraTank.drain(toRemoveMax, doDrain);
    }

    public FluidStack getShare(int i) {
        if (this.tank.getInternalTankAmount() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            this.tank.writeDataToNBT(tag);
            int ret = this.getStoredAmount() / i;
            return new FluidStack(DRFluidRegistry.liquidCrystal, ret, tag);
        }
        if (this.extraTank.getFluidAmount() > 0) {
            FluidStack ret = this.extraTank.getFluid().copy();
            ret.amount = this.extraTank.getFluidAmount() / i;
            return ret;
        }
        return null;
    }

    public void merge(InternalGridTank otherTank) {
        this.maxAmount += otherTank.maxAmount;
        this.tank.merge(otherTank.tank);
        this.extraTank = new FluidTank(this.extraTank.getFluid(), this.maxAmount);
        this.extraTank.fill(otherTank.extraTank.getFluid(), true);
    }

    public String getInfo() {
        return this.getStoredFluid() == DRFluidRegistry.liquidCrystal ? this.tank.toString() : "Fluid: " + this.getStoredFluid() + " Amount: " + this.extraTank.getFluidAmount();
    }
}

