/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.grid.tank;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.multiblock.dynamic.AbstractDynamicMultiBlock;
import elec332.core.multiblock.dynamic.AbstractDynamicMultiBlockWorldHolder;
import elec332.core.util.BlockLoc;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.grid.InternalGridTank;
import mcjty.deepresonance.grid.tank.DRTankWorldHolder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class DRTankMultiBlock
extends AbstractDynamicMultiBlock<DRTankWorldHolder, DRTankMultiBlock>
implements IFluidHandler,
IFluidTank {
    public static final int TANK_BUCKETS = 16;
    private boolean needsSorting;
    private InternalGridTank tank = new InternalGridTank(16000);
    private Map<Integer, List<BlockLoc>> renderData = Maps.newHashMap();
    private Fluid check;

    public DRTankMultiBlock(TileEntity tile, DRTankWorldHolder worldHolder) {
        super(tile, (AbstractDynamicMultiBlockWorldHolder)worldHolder);
        if (tile instanceof TileTank && ((TileTank)tile).getSaveData() != null) {
            this.tank.fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)((TileTank)tile).getSaveData().func_74775_l("fluid")), true);
        }
        this.needsSorting = true;
        this.setClientRenderFluid();
        this.markAllBlocksForUpdate();
    }

    public void tick() {
        if (this.world.func_82737_E() % 20L == 0L) {
            this.setTankFluidHeights();
            this.setClientRenderFluid();
            if (this.check != this.tank.getStoredFluid()) {
                this.markAllBlocksForUpdate();
                this.check = this.tank.getStoredFluid();
            }
        }
    }

    protected void invalidate() {
        super.invalidate();
        for (BlockLoc loc : new ArrayList(this.allLocations)) {
            TileTank tank = this.getTank(loc);
            if (tank == null) continue;
            this.setDataToTile(tank);
        }
    }

    protected void mergeWith(DRTankMultiBlock multiBlock) {
        super.mergeWith((AbstractDynamicMultiBlock)multiBlock);
        this.tank.merge(multiBlock.tank);
        this.setClientRenderFluid();
        this.needsSorting = true;
        this.setTankFluidHeights();
        this.markEverythingDirty();
        this.markAllBlocksForUpdate();
    }

    public void setDataToTile(TileTank tile) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        FluidStack myTank = this.getFluidShare(tile);
        Fluid lastSeenFluid = this.getStoredFluid();
        if (myTank != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            myTank.writeToNBT(fluidTag);
            tagCompound.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        if (lastSeenFluid != null) {
            tagCompound.func_74778_a("lastSeenFluid", FluidRegistry.getFluidName((Fluid)lastSeenFluid));
        }
        tile.setSaveData(tagCompound);
        tile.func_70296_d();
    }

    public int getComparatorInputOverride() {
        float f = (float)this.tank.getStoredAmount() / (float)this.getCapacity();
        return (int)(f * 15.0f);
    }

    public void markEverythingDirty() {
        for (BlockLoc loc : this.allLocations) {
            TileTank tank = this.getTank(loc);
            if (tank == null) continue;
            tank.func_70296_d();
        }
    }

    public void markAllBlocksForUpdate() {
        for (BlockLoc loc : this.allLocations) {
            this.world.func_147471_g(loc.xCoord, loc.yCoord, loc.zCoord);
        }
    }

    private void setTankFluidHeights() {
        if (this.needsSorting) {
            this.renderData.clear();
            Collections.sort(this.allLocations, new Comparator<BlockLoc>(){

                @Override
                public int compare(BlockLoc o1, BlockLoc o2) {
                    return o1.yCoord - o2.yCoord;
                }
            });
            for (BlockLoc loc : this.allLocations) {
                ArrayList list = this.renderData.get(loc.yCoord);
                if (list == null) {
                    list = Lists.newArrayList();
                    this.renderData.put(loc.yCoord, list);
                }
                list.add((BlockLoc)loc);
            }
            this.needsSorting = false;
        }
        int total = this.tank.getStoredAmount();
        ArrayList list8776 = Lists.newArrayList(this.renderData.keySet());
        Collections.sort(list8776);
        for (Integer j : list8776) {
            List<BlockLoc> list = this.renderData.get(j);
            float filled = 0.0f;
            if (total > 0) {
                int i = list.size();
                int toAdd = Math.min(total, i * 16 * 1000);
                total -= toAdd;
                filled = (float)toAdd / (float)(i * 16 * 1000);
            }
            for (BlockLoc loc : list) {
                TileTank tank = this.getTank(loc);
                if (tank == null) continue;
                tank.sendPacket(3, new NBTHelper().addToTag(filled, "render").toNBT());
            }
        }
    }

    public FluidStack getFluidShare(TileTank tile) {
        return this.tank.getShare(this.allLocations.size());
    }

    public Fluid getStoredFluid() {
        return this.tank.getStoredFluid();
    }

    public FluidStack getFluid() {
        return this.tank.getStoredFluidStack();
    }

    public int getFluidAmount() {
        return this.tank.getStoredAmount();
    }

    public int getCapacity() {
        return this.tank.getMaxAmount();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    public int fill(FluidStack resource, boolean doFill) {
        int ret = this.tank.fill(resource, doFill);
        if (doFill) {
            this.setClientRenderFluid();
            this.setTankFluidHeights();
        }
        return ret;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack ret = this.tank.drain(maxDrain, doDrain);
        if (doDrain) {
            this.setTankFluidHeights();
        }
        return ret;
    }

    public String getTankInfo() {
        return this.tank.getInfo();
    }

    public int getFreeSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    private TileTank getTank(BlockLoc loc) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)this.world, (BlockLoc)loc);
        return tile instanceof TileTank ? (TileTank)tile : null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int ret = this.fill(resource, doFill);
        if (doFill) {
            this.setClientRenderFluid();
            this.setTankFluidHeights();
        }
        return ret;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getStoredFluidStack())) {
            return null;
        }
        FluidStack ret = this.drain(resource.amount, doDrain);
        if (doDrain) {
            this.setTankFluidHeights();
        }
        return ret;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack ret = this.drain(maxDrain, doDrain);
        if (doDrain) {
            this.setTankFluidHeights();
        }
        return ret;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    private void setClientRenderFluid() {
        this.markEverythingDirty();
        for (BlockLoc loc : this.allLocations) {
            TileTank tank = this.getTank(loc);
            if (tank == null) continue;
            tank.lastSeenFluid = this.getStoredFluid();
            tank.sendPacket(1, new NBTHelper().addToTag(DRFluidRegistry.getFluidName(this.getFluid()), "fluid").toNBT());
        }
    }
}

