/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.radiation;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.items.armor.ItemRadiationSuit;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RadiationTickEvent {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static Random random = new Random();
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            return;
        }
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.serverTick(doEffects);
        }
    }

    private void serverTick(boolean doEffects) {
        World entityWorld = MinecraftServer.func_71276_C().func_130014_f_();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(entityWorld);
        HashSet<GlobalCoordinate> toRemove = new HashSet<GlobalCoordinate>();
        boolean dirty = false;
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> source : radiationManager.getRadiationSources().entrySet()) {
            GlobalCoordinate coordinate = source.getKey();
            WorldServer world = DimensionManager.getWorld((int)coordinate.getDimension());
            if (world == null || !world.func_72863_F().func_73149_a(coordinate.getCoordinate().getX() >> 4, coordinate.getCoordinate().getZ() >> 4)) continue;
            DRRadiationManager.RadiationSource radiationSource = source.getValue();
            float strength = radiationSource.getStrength();
            strength -= RadiationConfiguration.strengthDecreasePerTick * 10.0f;
            dirty = true;
            if (strength <= 0.0f) {
                toRemove.add(coordinate);
                continue;
            }
            radiationSource.setStrength(strength);
            if (doEffects) {
                this.handleRadiationEffects((World)world, coordinate, radiationSource);
            }
            if (!(strength > RadiationConfiguration.radiationDestructionEventLevel) || !(random.nextFloat() < RadiationConfiguration.destructionEventChance)) continue;
            this.handleDestructionEvent((World)world, coordinate, radiationSource);
        }
        if (dirty) {
            for (GlobalCoordinate coordinate : toRemove) {
                radiationManager.deleteRadiationSource(coordinate);
                Logging.logDebug((String)("Removed radiation source at: " + coordinate.getCoordinate().toString() + " (" + coordinate.getDimension() + ")"));
            }
            radiationManager.save(entityWorld);
        }
    }

    private void handleDestructionEvent(World world, GlobalCoordinate coordinate, DRRadiationManager.RadiationSource radiationSource) {
        float setOnFireChance;
        float poisonBlockChance;
        int damage;
        int cx = coordinate.getCoordinate().getX();
        int cy = coordinate.getCoordinate().getY();
        int cz = coordinate.getCoordinate().getZ();
        double centerx = cx;
        double centery = cy;
        double centerz = cz;
        double radius = radiationSource.getRadius();
        double theta = random.nextDouble() * Math.PI * 2.0;
        double phi = random.nextDouble() * Math.PI - 1.5707963267948966;
        double dist = random.nextDouble() * radius;
        double cosphi = Math.cos(phi);
        double destx = centerx + dist * Math.cos(theta) * cosphi;
        double destz = centerz + dist * Math.sin(theta) * cosphi;
        double desty = random.nextFloat() > 0.5f ? (double)world.func_72825_h((int)destx, (int)destz) : centery + dist * Math.sin(phi);
        Logging.logDebug((String)("Destruction event at: " + destx + "," + desty + "," + destz));
        float baseStrength = radiationSource.getStrength();
        double distanceSq = (centerx - destx) * (centerx - destx) + (centery - desty) * (centery - desty) + (centerz - destz) * (centerz - destz);
        double distance = Math.sqrt(distanceSq);
        float strength = (float)((double)baseStrength * (radius - distance) / radius);
        QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy, cz);
        strength *= (float)radiationTree.factor(cx, cy, cz, (int)destx, (int)desty, (int)destz);
        int eventradius = 8;
        if (strength > RadiationConfiguration.radiationDestructionEventLevel / 2.0f) {
            damage = 30;
            poisonBlockChance = 0.9f;
            setOnFireChance = 0.03f;
        } else if (strength > RadiationConfiguration.radiationDestructionEventLevel / 3.0f) {
            damage = 5;
            poisonBlockChance = 0.6f;
            setOnFireChance = 0.001f;
        } else if (strength > RadiationConfiguration.radiationDestructionEventLevel / 4.0f) {
            damage = 1;
            poisonBlockChance = 0.3f;
            setOnFireChance = 0.0f;
        } else {
            return;
        }
        List list = world.func_82733_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(destx - (double)eventradius), (double)(desty - (double)eventradius), (double)(destz - (double)eventradius), (double)(destx + (double)eventradius), (double)(desty + (double)eventradius), (double)(destz + (double)eventradius)), null);
        for (Object o : list) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)o;
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 10, damage));
        }
        int x = (int)(destx - (double)eventradius);
        while ((double)x <= destx + (double)eventradius) {
            int y = (int)(desty - (double)eventradius);
            while ((double)y <= desty + (double)eventradius) {
                int z = (int)(destz - (double)eventradius);
                while ((double)z <= destz + (double)eventradius) {
                    double dSq = ((double)x - destx) * ((double)x - destx) + ((double)y - desty) * ((double)y - desty) + ((double)z - destz) * ((double)z - destz);
                    double d = Math.sqrt(dSq);
                    double str = ((double)eventradius - d) / (double)eventradius;
                    Block block = world.func_147439_a(x, y, z);
                    if (block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150349_c) {
                        if ((double)random.nextFloat() < (double)poisonBlockChance * str) {
                            world.func_147465_d(x, y, z, (Block)ModBlocks.poisonedDirtBlock, 0, 2);
                        }
                    } else if (block.isLeaves((IBlockAccess)world, x, y, z) && (double)random.nextFloat() < (double)poisonBlockChance * str) {
                        world.func_147468_f(x, y, z);
                    }
                    if ((double)random.nextFloat() < (double)setOnFireChance * str && !world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z)) {
                        Logging.logDebug((String)("Set fire at: " + x + "," + y + "," + z));
                        world.func_147465_d(x, y + 1, z, (Block)Blocks.field_150480_ab, 0, 3);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void handleRadiationEffects(World world, GlobalCoordinate coordinate, DRRadiationManager.RadiationSource radiationSource) {
        int cx = coordinate.getCoordinate().getX();
        int cy = coordinate.getCoordinate().getY();
        int cz = coordinate.getCoordinate().getZ();
        double centerx = cx;
        double centery = cy;
        double centerz = cz;
        double radius = radiationSource.getRadius();
        double radiusSq = radius * radius;
        float baseStrength = radiationSource.getStrength();
        List list = world.func_82733_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(centerx - radius), (double)(centery - radius), (double)(centerz - radius), (double)(centerx + radius), (double)(centery + radius), (double)(centerz + radius)), null);
        for (Object o : list) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)o;
            int pieces = ItemRadiationSuit.countSuitPieces(entityLivingBase);
            float protection = RadiationConfiguration.suitProtection[pieces];
            double distanceSq = entityLivingBase.func_70092_e(centerx, centery, centerz);
            if (!(distanceSq < radiusSq)) continue;
            double distance = Math.sqrt(distanceSq);
            QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy, cz);
            float strength = (float)((double)baseStrength * (radius - distance) / radius);
            strength *= 1.0f - protection;
            if ((strength *= (float)radiationTree.factor(cx, cy, cz, (int)entityLivingBase.field_70165_t, (int)entityLivingBase.field_70163_u, (int)entityLivingBase.field_70161_v)) < RadiationConfiguration.radiationStrenghLevel0) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 1, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationStrenghLevel1) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 1, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationStrenghLevel2) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 180, 1, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationStrenghLevel3) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 180, 1, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationStrenghLevel4) {
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 2, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 180, 3, true));
                entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 180, 2, true));
                continue;
            }
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 2, true));
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 180, 3, true));
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 180, 3, true));
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 180, 2, true));
        }
    }
}

