/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft;

import cpw.mods.fml.common.registry.GameRegistry;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.CrucibleFormula;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.DrillHeadRecipe;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.book.BookRecipeRegistry;
import flaxbeard.steamcraft.handler.CanisterHandler;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.misc.DrillHeadMaterial;
import flaxbeard.steamcraft.tile.TileEntitySmasher;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class SteamcraftRecipes {
    public static CrucibleLiquid liquidIron;
    public static CrucibleLiquid liquidZinc;
    public static CrucibleLiquid liquidCopper;
    public static CrucibleLiquid liquidGold;
    public static CrucibleLiquid liquidBrass;

    public static void registerRecipes() {
        SteamcraftRecipes.registerFluid();
        SteamcraftRecipes.registerCraftingRecipes();
        SteamcraftRecipes.registerSmeltingRecipes();
        SteamcraftRecipes.registerSmashingRecipes();
    }

    private static void registerFluid() {
        liquidIron = new CrucibleLiquid("iron", new ItemStack(Items.field_151042_j), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 2), new ItemStack(SteamcraftItems.steamcraftNugget, 1, 2), null, 200, 200, 200);
        SteamcraftRegistry.registerLiquid(liquidIron);
        liquidGold = new CrucibleLiquid("gold", new ItemStack(Items.field_151043_k), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 3), new ItemStack(Items.field_151074_bl), null, 220, 157, 11);
        SteamcraftRegistry.registerLiquid(liquidGold);
        liquidZinc = new CrucibleLiquid("zinc", new ItemStack(SteamcraftItems.steamcraftIngot, 1, 1), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 1), new ItemStack(SteamcraftItems.steamcraftNugget, 1, 1), null, 225, 225, 225);
        SteamcraftRegistry.registerLiquid(liquidZinc);
        liquidCopper = new CrucibleLiquid("copper", new ItemStack(SteamcraftItems.steamcraftIngot, 1, 0), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 0), new ItemStack(SteamcraftItems.steamcraftNugget, 1, 0), null, 140, 66, 12);
        SteamcraftRegistry.registerLiquid(liquidCopper);
        liquidBrass = new CrucibleLiquid("brass", new ItemStack(SteamcraftItems.steamcraftIngot, 1, 2), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 4), new ItemStack(SteamcraftItems.steamcraftNugget, 1, 3), new CrucibleFormula(liquidZinc, 1, liquidCopper, 3, 4), 242, 191, 66);
        SteamcraftRegistry.registerLiquid(liquidBrass);
        SteamcraftRegistry.registerMeltRecipeOreDict("ingotGold", liquidGold, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("ingotIron", liquidIron, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("ingotZinc", liquidZinc, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("ingotCopper", liquidCopper, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("ingotBrass", liquidBrass, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustTinyGold", liquidGold, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustTinyIron", liquidIron, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustTinyZinc", liquidZinc, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustTinyCopper", liquidCopper, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustTinyBrass", liquidBrass, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("plateSteamcraftGold", liquidGold, 6);
        SteamcraftRegistry.registerMeltRecipeOreDict("plateSteamcraftIron", liquidIron, 6);
        SteamcraftRegistry.registerMeltRecipeOreDict("plateSteamcraftZinc", liquidZinc, 6);
        SteamcraftRegistry.registerMeltRecipeOreDict("plateSteamcraftCopper", liquidCopper, 6);
        SteamcraftRegistry.registerMeltRecipeOreDict("plateSteamcraftBrass", liquidBrass, 6);
        SteamcraftRegistry.registerMeltRecipeOreDict("nuggetGold", liquidGold, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("nuggetIron", liquidIron, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("nuggetZinc", liquidZinc, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("nuggetCopper", liquidCopper, 1);
        SteamcraftRegistry.registerMeltRecipeOreDict("nuggetBrass", liquidBrass, 1);
        SteamcraftRegistry.registerMeltRecipe(Items.field_151074_bl, liquidGold, 1);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151040_l, liquidIron, 18);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151035_b, liquidIron, 27);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151036_c, liquidIron, 27);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151019_K, liquidIron, 18);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151037_a, liquidIron, 9);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151167_ab, liquidIron, 36);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151030_Z, liquidIron, 72);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151028_Y, liquidIron, 45);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151165_aa, liquidIron, 63);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151010_B, liquidGold, 18);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151005_D, liquidGold, 27);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151006_E, liquidGold, 27);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151013_M, liquidGold, 18);
        SteamcraftRegistry.registerMeltRecipeTool(Items.field_151011_C, liquidGold, 9);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151151_aj, liquidGold, 36);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151171_ah, liquidGold, 72);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151169_ag, liquidGold, 45);
        SteamcraftRegistry.registerMeltRecipeTool((Item)Items.field_151149_ai, liquidGold, 63);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.sword("Brass"), liquidBrass, 18);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.pick("Brass"), liquidBrass, 27);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.axe("Brass"), liquidBrass, 27);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.hoe("Brass"), liquidBrass, 18);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.shovel("Brass"), liquidBrass, 9);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.feet("Brass"), liquidBrass, 36);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.chest("Brass"), liquidBrass, 72);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.helm("Brass"), liquidBrass, 45);
        SteamcraftRegistry.registerMeltRecipeTool(SteamcraftItems.legs("Brass"), liquidBrass, 63);
        SteamcraftRegistry.registerOreDictDunkRecipe("ingotIron", liquidGold, 1, new ItemStack(SteamcraftItems.steamcraftIngot, 1, 3));
        SteamcraftRegistry.registerOreDictDunkRecipe("plateSteamcraftIron", liquidGold, 1, new ItemStack(SteamcraftItems.steamcraftPlate, 1, 12));
    }

    private static void registerSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(SteamcraftBlocks.steamcraftOre, 1, 0), (ItemStack)new ItemStack(SteamcraftItems.steamcraftIngot, 1, 0), (float)0.5f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SteamcraftBlocks.steamcraftOre, 1, 1), (ItemStack)new ItemStack(SteamcraftItems.steamcraftIngot, 1, 1), (float)0.5f);
        if (CrossMod.RAILCRAFT) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(SteamcraftBlocks.steamcraftOre, 1, 2), (ItemStack)new ItemStack(SteamcraftItems.steamcraftNugget, 1, 1), (float)0.5f);
        }
    }

    private static void registerCraftingRecipes() {
        if (Config.hasAllCrucial) {
            SteamcraftRecipes.registerMisc();
            SteamcraftRecipes.registerFirearms();
            SteamcraftRecipes.registerExosuit();
            SteamcraftRecipes.registerExoUpgrades();
            SteamcraftRecipes.registerSteamTools();
            SteamcraftRecipes.registerSteamNet();
            SteamcraftRecipes.registerSteamMachines();
            SteamcraftRecipes.registerMetalCrafting();
        }
    }

    public static void registerMisc() {
        BookRecipeRegistry.addRecipe("book", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.book), new Object[]{Items.field_151122_aG, "oreZinc", "oreCopper"}));
        if (Config.enableCanister) {
            GameRegistry.addRecipe((IRecipe)new CanisterHandler());
        }
        if (Config.enableSurvivalist) {
            BookRecipeRegistry.addRecipe("survivalist", new ItemStack(SteamcraftItems.survivalist), "b s", "xwx", "xxx", Character.valueOf('x'), Items.field_151116_aA, Character.valueOf('s'), Items.field_151007_F, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('w'), Items.field_151055_y);
        }
        if (Config.enableAstrolabe) {
            BookRecipeRegistry.addRecipe("astrolabe", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.astrolabe), new Object[]{" x ", "xrx", " x ", Character.valueOf('x'), "ingotBrass", Character.valueOf('r'), Items.field_151137_ax}));
        }
        if (Config.enableEngineering) {
            BookRecipeRegistry.addRecipe("engineering1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.engineering), new Object[]{"xzx", "x x", "xxx", Character.valueOf('x'), "blockCobble", Character.valueOf('z'), "plateSteamcraftIron"}));
            BookRecipeRegistry.addRecipe("engineering2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.engineering), new Object[]{"xzx", "x x", "xxx", Character.valueOf('x'), Blocks.field_150347_e, Character.valueOf('z'), "plateSteamcraftIron"}));
        }
        if (Config.enableSpyglass) {
            BookRecipeRegistry.addRecipe("spyglass1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.spyglass), new Object[]{"gb ", "bgb", " bb", Character.valueOf('b'), "ingotBrass", Character.valueOf('g'), Blocks.field_150410_aZ}));
            BookRecipeRegistry.addRecipe("spyglass2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.spyglass), new Object[]{"gb ", "bgb", " bb", Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('g'), Blocks.field_150410_aZ}));
        }
        BookRecipeRegistry.addRecipe("piston1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), new Object[]{" x ", "xpx", " i ", Character.valueOf('x'), "ingotBrass", Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('i'), SteamcraftBlocks.pipe}));
        BookRecipeRegistry.addRecipe("piston2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), new Object[]{" x ", "xpx", " i ", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('i'), SteamcraftBlocks.pipe}));
        BookRecipeRegistry.addRecipe("turbine1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5), new Object[]{" x ", "xnx", " x ", Character.valueOf('x'), "ingotBrass", Character.valueOf('n'), "nuggetBrass"}));
        BookRecipeRegistry.addRecipe("turbine2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5), new Object[]{" x ", "xnx", " x ", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('n'), "nuggetBrass"}));
        if (Config.enableWrench) {
            BookRecipeRegistry.addRecipe("wrench1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.wrench, 1, 0), new Object[]{"  i", " bb", "b  ", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "plateSteamcraftBrass"}));
            BookRecipeRegistry.addRecipe("wrench2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.wrench, 1, 0), new Object[]{"  i", " bb", "b  ", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "ingotBrass"}));
        }
        if (Config.enableTopHat) {
            BookRecipeRegistry.addRecipe("hat", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.tophatNoEmerald), new Object[]{" l ", " l ", "lll", Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('l'), new ItemStack(Blocks.field_150325_L, 1, 15)}));
            if (Config.enableEmeraldHat) {
                BookRecipeRegistry.addRecipe("hatEmerald", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.tophat), new Object[]{SteamcraftItems.tophatNoEmerald, Blocks.field_150475_bE}));
            }
        }
        if (Config.enableGoggles) {
            BookRecipeRegistry.addRecipe("goggles1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.goggles), new Object[]{" l ", "l l", "tbg", Character.valueOf('b'), "ingotBrass", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('t'), SteamcraftItems.spyglass, Character.valueOf('g'), Blocks.field_150359_w}));
            BookRecipeRegistry.addRecipe("goggles2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.goggles), new Object[]{" l ", "l l", "tbg", Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('t'), SteamcraftItems.spyglass, Character.valueOf('g'), Blocks.field_150359_w}));
            BookRecipeRegistry.addRecipe("monocle1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.monacle), new Object[]{" l ", "l l", "btb", Character.valueOf('b'), "ingotBrass", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('t'), SteamcraftItems.spyglass}));
            BookRecipeRegistry.addRecipe("monocle2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.monacle), new Object[]{" l ", "l l", "btb", Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('t'), SteamcraftItems.spyglass}));
        }
        if (Config.enableCanister) {
            BookRecipeRegistry.addRecipe("canister", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.canister, 4, 0), new Object[]{" i ", "i i", " i ", Character.valueOf('i'), "nuggetZinc"}));
        }
        if (Config.enableHorn) {
            BookRecipeRegistry.addRecipe("whistle1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.horn, 1, 0), new Object[]{" bb", " bn", "pp ", Character.valueOf('n'), "nuggetBrass", Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('p'), new ItemStack(SteamcraftBlocks.pipe, 1, 0)}));
            BookRecipeRegistry.addRecipe("whistle2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.horn, 1, 0), new Object[]{" bb", " bn", "pp ", Character.valueOf('n'), "nuggetBrass", Character.valueOf('b'), "ingotBrass", Character.valueOf('p'), new ItemStack(SteamcraftBlocks.pipe, 1, 0)}));
        }
        if (Config.enableSteamCell) {
            BookRecipeRegistry.addRecipe("steamcell", (IRecipe)new ShapedOreRecipe(SteamcraftItems.steamcellEmpty, new Object[]{"nbn", "bpb", "nbn", Character.valueOf('n'), "nuggetBrass", Character.valueOf('b'), Items.field_151130_bT, Character.valueOf('p'), Items.field_151065_br}));
        }
        if (Config.enableSteamCellBauble && CrossMod.BAUBLES) {
            BookRecipeRegistry.addRecipe("steamcellFiller", (IRecipe)new ShapedOreRecipe(SteamcraftItems.steamcellBauble, new Object[]{" p ", "i i", "i i", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('i'), "plateSteamcraftIron"}));
        }
    }

    public static void registerCasting() {
        if (Config.enableCrucible) {
            BookRecipeRegistry.addRecipe("crucible", new ItemStack(SteamcraftBlocks.crucible), "x x", "x x", "xxx", Character.valueOf('x'), Items.field_151118_aC);
            if (Config.enableHellCrucible) {
                BookRecipeRegistry.addRecipe("hellCrucible", new ItemStack(SteamcraftBlocks.hellCrucible), "x x", "x x", "xxx", Character.valueOf('x'), Items.field_151130_bT);
            }
        }
        if (Config.enableMold) {
            BookRecipeRegistry.addRecipe("mold", new ItemStack(SteamcraftBlocks.mold), "xxx", "xxx", Character.valueOf('x'), Items.field_151118_aC);
            BookRecipeRegistry.addRecipe("blankMold", new ItemStack(SteamcraftItems.blankMold), "xx", Character.valueOf('x'), Items.field_151118_aC);
            BookRecipeRegistry.addRecipe("carving", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.carving), new Object[]{"xzx", "x x", "xxx", Character.valueOf('x'), "plankWood", Character.valueOf('z'), SteamcraftItems.blankMold}));
        }
    }

    public static void registerFirearms() {
        if (Config.enableFirearms || Config.enableRL) {
            BookRecipeRegistry.addRecipe("stock", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1), new Object[]{"p  ", " p ", " pp", Character.valueOf('p'), "plankWood"}));
            if (Config.disableMainBarrelRecipe) {
                BookRecipeRegistry.addRecipe("barrel1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), new Object[]{"i  ", " i ", "  i", Character.valueOf('i'), "ingotIron"}));
            } else {
                BookRecipeRegistry.addRecipe("barrel1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), new Object[]{"i  ", " i ", "  i", Character.valueOf('i'), "plateSteamcraftIron"}));
            }
            BookRecipeRegistry.addRecipe("barrel2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), new Object[]{"i  ", " i ", "  i", Character.valueOf('i'), "plateSteamcraftIron"}));
            BookRecipeRegistry.addRecipe("blunderBarrel1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), new Object[]{"i  ", " i ", "  i", Character.valueOf('i'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("blunderBarrel2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), new Object[]{"i  ", " i ", "  i", Character.valueOf('i'), "plateSteamcraftBrass"}));
            BookRecipeRegistry.addRecipe("flintlock1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), new Object[]{"f i", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('f'), Items.field_151033_d}));
            BookRecipeRegistry.addRecipe("flintlock2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), new Object[]{"f i", "iri", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('f'), Items.field_151033_d}));
        }
        if (Config.enableFirearms) {
            if (!Config.expensiveMusketRecipes) {
                BookRecipeRegistry.addRecipe("cartridge1", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge, 2, 0), new Object[]{"nuggetIron", "nuggetIron", Items.field_151121_aF, Items.field_151121_aF, Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("cartridge2", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge, 2, 0), new Object[]{"nuggetLead", "nuggetLead", Items.field_151121_aF, Items.field_151121_aF, Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("cartridge3", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge, 2, 0), new Object[]{"nuggetSteel", "nuggetSteel", Items.field_151121_aF, Items.field_151121_aF, Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("cartridge4", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge, 2, 0), new Object[]{"nuggetSilver", "nuggetSilver", Items.field_151121_aF, Items.field_151121_aF, Items.field_151016_H}));
            } else {
                BookRecipeRegistry.addRecipe("cartridge1", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge), new Object[]{"nuggetIron", Items.field_151121_aF, Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("cartridge2", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge), new Object[]{"nuggetLead", Items.field_151121_aF, Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("cartridge3", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge), new Object[]{"nuggetSteel", Items.field_151121_aF, Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("cartridge4", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.musketCartridge), new Object[]{"nuggetSilver", Items.field_151121_aF, Items.field_151016_H}));
            }
            BookRecipeRegistry.addRecipe("musket", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.musket), new Object[]{"b  ", " bf", "  s", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('s'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1)}));
            BookRecipeRegistry.addRecipe("pistol", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.pistol), new Object[]{"b  ", " pf", " p ", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('p'), "plankWood"}));
            BookRecipeRegistry.addRecipe("blunderbuss", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.blunderbuss), new Object[]{"b  ", " bf", "  s", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('s'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1)}));
            if (Config.enableEnhancementAblaze) {
                BookRecipeRegistry.addRecipe("ablaze", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementAblaze), new Object[]{"rp ", "pbp", " pr", Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('p'), Items.field_151065_br, Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2)}));
            }
            if (Config.enableEnhancementSpeedloader) {
                BookRecipeRegistry.addRecipe("speedloader1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementSpeedloader), new Object[]{"  n", "iii", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), "nuggetIron"}));
                BookRecipeRegistry.addRecipe("speedloader2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementSpeedloader), new Object[]{"  n", "iii", "iri", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), "nuggetIron"}));
            }
            if (Config.enableEnhancementRecoil) {
                BookRecipeRegistry.addRecipe("recoil", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementRecoil), new Object[]{"ss ", " ss", "ss ", Character.valueOf('s'), "slimeball"}));
            }
            if (Config.enableEnhancementRevolver) {
                BookRecipeRegistry.addRecipe("revolver1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementRevolver), new Object[]{"ni ", "iii", " in", Character.valueOf('i'), "ingotIron", Character.valueOf('n'), "nuggetIron"}));
                BookRecipeRegistry.addRecipe("revolver2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementRevolver), new Object[]{"ni ", "iii", " in", Character.valueOf('i'), "ingotIron", Character.valueOf('n'), "nuggetIron"}));
            }
            if (Config.enableEnhancementSilencer) {
                BookRecipeRegistry.addRecipe("silencer", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementSilencer), new Object[]{"wls", "lll", "slw", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('s'), Items.field_151007_F}));
            }
            if (Config.enableEnhancementSpeedy) {
                BookRecipeRegistry.addRecipe("speedy1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementSpeedy), new Object[]{"iii", "iii", " n ", Character.valueOf('i'), "ingotIron", Character.valueOf('n'), "nuggetIron"}));
                BookRecipeRegistry.addRecipe("speedy2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementSpeedy), new Object[]{"iii", "iii", " n ", Character.valueOf('i'), "ingotIron", Character.valueOf('n'), "nuggetIron"}));
            }
        }
        if (Config.enableRL) {
            BookRecipeRegistry.addRecipe("rocket1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocketLauncher), new Object[]{"bx ", "fic", " pi", Character.valueOf('i'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('c'), "plateSteamcraftCopper", Character.valueOf('p'), "plankWood", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('s'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1)}));
            BookRecipeRegistry.addRecipe("rocket2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocketLauncher), new Object[]{"bx ", "fic", " pi", Character.valueOf('i'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('x'), "ingotBrass", Character.valueOf('c'), "plateSteamcraftCopper", Character.valueOf('p'), "plankWood", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('s'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1)}));
            BookRecipeRegistry.addRecipe("rocket3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocketLauncher), new Object[]{"bx ", "fic", " pi", Character.valueOf('i'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('c'), "ingotCopper", Character.valueOf('p'), "plankWood", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('s'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1)}));
            BookRecipeRegistry.addRecipe("rocket4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocketLauncher), new Object[]{"bx ", "fic", " pi", Character.valueOf('i'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('x'), "ingotBrass", Character.valueOf('c'), "ingotCopper", Character.valueOf('p'), "plankWood", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), Character.valueOf('f'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), Character.valueOf('s'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1)}));
            if (Config.enableRocket) {
                BookRecipeRegistry.addRecipe("normalRocket1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocket), new Object[]{" i ", "igi", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), Items.field_151016_H}));
                BookRecipeRegistry.addRecipe("normalRocket2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocket), new Object[]{" i ", "igi", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('g'), Items.field_151016_H}));
            }
            if (Config.enableRocketConcussive) {
                if (Config.enableRocket) {
                    BookRecipeRegistry.addRecipe("concussiveRocket", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.rocketConcussive), new Object[]{SteamcraftItems.rocket, Blocks.field_150354_m}));
                } else {
                    BookRecipeRegistry.addRecipe("concussiveRocket1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocketConcussive), new Object[]{" i ", "igi", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), Items.field_151016_H}));
                    BookRecipeRegistry.addRecipe("concussiveRocket2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.rocketConcussive), new Object[]{" i ", "igi", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('g'), Items.field_151016_H}));
                }
            }
            if (Config.enableRocketMining) {
                if (Config.enableRocket) {
                    BookRecipeRegistry.addRecipe("miningRocket", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.rocketMiner), new Object[]{SteamcraftItems.rocket, Items.field_151007_F, Items.field_151007_F, Items.field_151016_H}));
                } else {
                    BookRecipeRegistry.addRecipe("miningRocket", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.rocketMiner), new Object[]{SteamcraftItems.rocketConcussive, Items.field_151007_F, Items.field_151007_F, Items.field_151016_H}));
                }
            }
            if (Config.enableEnhancementFastRockets) {
                BookRecipeRegistry.addRecipe("fastRockets", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementFastRockets), new Object[]{"b  ", "gid", "  i", Character.valueOf('i'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), Character.valueOf('d'), SteamcraftBlocks.ruptureDisc, Character.valueOf('g'), SteamcraftBlocks.gauge, Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3)}));
            }
            if (Config.enableEnhancementAmmo) {
                BookRecipeRegistry.addRecipe("ammo1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementAmmo), new Object[]{"icc", "icc", "cc ", Character.valueOf('i'), "nuggetIron", Character.valueOf('c'), "plateSteamcraftCopper"}));
                BookRecipeRegistry.addRecipe("ammo2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enhancementAmmo), new Object[]{"icc", "icc", "cc ", Character.valueOf('i'), "nuggetIron", Character.valueOf('c'), "ingotCopper"}));
            }
            if (Config.enableEnhancementAirStrike) {
                BookRecipeRegistry.addRecipe("airStrike1", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.enhancementAirStrike), new Object[]{"ingotIron", "ingotIron", "plankWood", "plankWood", new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4)}));
                BookRecipeRegistry.addRecipe("airStrike2", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.enhancementAirStrike), new Object[]{"plateSteamcraftIron", "plateSteamcraftIron", "plankWood", "plankWood", new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4)}));
            }
        }
    }

    public static void registerExosuit() {
        if (Config.enableExosuit) {
            BookRecipeRegistry.addRecipe("exoHead", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.exoArmorHead), new Object[]{"xyx", "p p", "xyx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('y'), "nuggetBrass", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
            BookRecipeRegistry.addRecipe("exoBody", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.exoArmorBody, 1, SteamcraftItems.exoArmorBody.func_77612_l() - 1), new Object[]{"p p", "ygy", "xxx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('y'), "nuggetBrass", Character.valueOf('g'), SteamcraftBlocks.gauge, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
            BookRecipeRegistry.addRecipe("exoLegs", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.exoArmorLegs), new Object[]{"yxy", "p p", "x x", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('y'), "nuggetBrass", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
            BookRecipeRegistry.addRecipe("exoFeet", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.exoArmorFeet), new Object[]{"p p", "x x", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('y'), "nuggetBrass", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
    }

    public static void registerExoUpgrades() {
        if (Config.enableCopperPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoCopper", "plateSteamcraftCopper", new ItemStack(SteamcraftItems.exosuitPlate, 1, 0), liquidCopper);
        }
        if (Config.enableZincPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoZinc", "plateSteamcraftZinc", new ItemStack(SteamcraftItems.exosuitPlate, 1, 1), liquidZinc);
        }
        if (Config.enableIronPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoIron", "plateSteamcraftIron", new ItemStack(SteamcraftItems.exosuitPlate, 1, 2), liquidIron);
        }
        if (Config.enableGoldPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoGold", "plateSteamcraftGold", new ItemStack(SteamcraftItems.exosuitPlate, 1, 3), liquidGold);
        }
        if (Config.enableBrassPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoBrass", "plateSteamcraftBrass", new ItemStack(SteamcraftItems.exosuitPlate, 1, 4), liquidBrass);
        }
        if (Config.enableGildedIronPlate) {
            SteamcraftRecipes.addExosuitPlateRecipes("exoGildedIron", "plateSteamcraftGildedIron", new ItemStack(SteamcraftItems.exosuitPlate, 1, 14));
        }
        if (Config.enableEnderShroud) {
            BookRecipeRegistry.addRecipe("enderShroud", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.enderShroud), new Object[]{" g ", "geg", " g ", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('e'), Items.field_151079_bi}));
        }
        if (Config.enableJetpack) {
            BookRecipeRegistry.addRecipe("jetpack1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.jetpack), new Object[]{"p p", "ptg", "p p", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('g'), SteamcraftBlocks.gauge, Character.valueOf('t'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("jetpack2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.jetpack), new Object[]{"p p", "ptg", "p p", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('g'), SteamcraftBlocks.gauge, Character.valueOf('t'), "plateSteamcraftBrass"}));
        }
        if (Config.enableThrusters) {
            BookRecipeRegistry.addRecipe("thrusters1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.thrusters), new Object[]{"tnt", "ptp", "tnt", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), "ingotBrass", Character.valueOf('n'), "nuggetBrass"}));
            BookRecipeRegistry.addRecipe("thrusters2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.thrusters), new Object[]{"tnt", "ptp", "tnt", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), "plateSteamcraftBrass", Character.valueOf('n'), "nuggetBrass"}));
        }
        if (Config.enableReinforcedTank) {
            BookRecipeRegistry.addRecipe("reinforcedTank1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.reinforcedTank), new Object[]{"ppp", "tpt", "ppp", Character.valueOf('t'), new ItemStack(SteamcraftBlocks.tank, 1, 0), Character.valueOf('p'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("reinforcedTank2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.reinforcedTank), new Object[]{"ppp", "tpt", "ppp", Character.valueOf('t'), new ItemStack(SteamcraftBlocks.tank, 1, 0), Character.valueOf('p'), "plateSteamcraftBrass"}));
        }
        if (Config.enableUberReinforcedTank) {
            BookRecipeRegistry.addRecipe("uberReinforcedTank1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.uberReinforcedTank), new Object[]{"ppp", "tbt", "ppp", Character.valueOf('t'), SteamcraftItems.reinforcedTank, Character.valueOf('p'), "ingotBrass", Character.valueOf('b'), "blockBrass"}));
            BookRecipeRegistry.addRecipe("uberReinforcedTank2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.uberReinforcedTank), new Object[]{"ppp", "tbt", "ppp", Character.valueOf('t'), SteamcraftItems.reinforcedTank, Character.valueOf('p'), "plateSteamcraftTank", Character.valueOf('b'), "blockBrass"}));
        }
        if (Config.enableCanningMachine) {
            BookRecipeRegistry.addRecipe("canner1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.canner), new Object[]{"bbn", "p p", "i i", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "ingotBrass", Character.valueOf('n'), "nuggetIron", Character.valueOf('i'), "ingotIron"}));
            BookRecipeRegistry.addRecipe("canner2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.canner), new Object[]{"bbn", "p p", "i i", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('n'), "nuggetIron", Character.valueOf('i'), "plateSteamcraftIron"}));
            BookRecipeRegistry.addRecipe("canner3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.canner), new Object[]{"bbn", "p p", "i i", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "ingotBrass", Character.valueOf('n'), "nuggetIron", Character.valueOf('i'), "ingotIron"}));
            BookRecipeRegistry.addRecipe("canner4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.canner), new Object[]{"bbn", "p p", "i i", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('n'), "nuggetIron", Character.valueOf('i'), "plateSteamcraftIron"}));
        }
        if (Config.enableWings) {
            BookRecipeRegistry.addRecipe("wings1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.wings), new Object[]{"xxx", "ccc", "c c", Character.valueOf('x'), "ingotBrass", Character.valueOf('c'), "plateSteamcraftCopper"}));
            BookRecipeRegistry.addRecipe("wings2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.wings), new Object[]{"xxx", "ccc", "c c", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('c'), "plateSteamcraftCopper"}));
        }
        if (Config.enablePowerFist) {
            BookRecipeRegistry.addRecipe("powerFist1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.powerFist), new Object[]{"b i", "bpi", "b i", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "nuggetBrass"}));
            BookRecipeRegistry.addRecipe("powerFist2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.powerFist), new Object[]{"b i", "bpi", "b i", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "nuggetBrass"}));
        }
        if (Config.enableExtendoFist) {
            BookRecipeRegistry.addRecipe("extendoFist1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.extendoFist), new Object[]{" ii", "bbi", "bb ", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "nuggetBrass"}));
            BookRecipeRegistry.addRecipe("extendoFist2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.extendoFist), new Object[]{" ii", "bbi", "bb ", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('b'), "nuggetBrass"}));
        }
        if (Config.enablePitonDeployer) {
            BookRecipeRegistry.addRecipe("pitonDeployer", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.pitonDeployer), new Object[]{" i ", "lli", "ll ", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('i'), "nuggetIron"}));
        }
        if (Config.enableFallAssist) {
            BookRecipeRegistry.addRecipe("noFall", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.fallAssist), new Object[]{"pbp", "sss", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('s'), Items.field_151123_aH}));
        }
        if (Config.enableJumpAssist) {
            BookRecipeRegistry.addRecipe("jumpAssist1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.jumpAssist), new Object[]{"s s", "pbp", "s s", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('s'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("jumpAssist2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.jumpAssist), new Object[]{"s s", "pbp", "s s", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('s'), "plateSteamcraftBrass"}));
        }
        if (Config.enableRunAssist) {
            BookRecipeRegistry.addRecipe("runAssist1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.runAssist), new Object[]{"p p", "s s", "p p", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('s'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("runAssist2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.runAssist), new Object[]{"p p", "s s", "p p", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('s'), "plateSteamcraftBrass"}));
        }
        if (Config.enableStealthUpgrade) {
            BookRecipeRegistry.addRecipe("stealthUpgrade", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.stealthUpgrade), new Object[]{"lwl", "lsl", "lwl", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('s'), Items.field_151007_F}));
        }
        if (Config.enableDoubleJump) {
            BookRecipeRegistry.addRecipe("doubleJump1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.doubleJump), new Object[]{"s s", "v v", Character.valueOf('v'), SteamcraftBlocks.valvePipe, Character.valueOf('s'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("doubleJump2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.doubleJump), new Object[]{"s s", "v v", Character.valueOf('v'), SteamcraftBlocks.valvePipe, Character.valueOf('s'), "plateSteamcraftBrass"}));
        }
        if (Config.enableAnchorHeels) {
            if (Config.enableLeadPlate && OreDictionary.getOres((String)"ingotLead").size() > 0 && !Config.enableAnchorAnvilRecipe) {
                BookRecipeRegistry.addRecipe("anchorHeels", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.anchorHeels), new Object[]{"p p", "e e", Character.valueOf('p'), "plateSteamcraftLead", Character.valueOf('e'), new ItemStack(SteamcraftItems.exosuitPlate, 1, 11)}));
            } else {
                BookRecipeRegistry.addRecipe("anchorHeels", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.anchorHeels), new Object[]{"p p", "eae", Character.valueOf('p'), "plateSteamcraftIron", Character.valueOf('e'), new ItemStack(SteamcraftItems.exosuitPlate, 1, 2), Character.valueOf('a'), Blocks.field_150467_bQ}));
            }
        }
        if (Config.enableFrequencyShifter) {
            BookRecipeRegistry.addRecipe("frequencyShifter", (IRecipe)new ShapedOreRecipe(SteamcraftItems.frequencyShifter, new Object[]{"t n", "pjp", " p ", Character.valueOf('t'), Blocks.field_150429_aA, Character.valueOf('n'), "nuggetBrass", Character.valueOf('p'), "plateSteamcraftBrass", Character.valueOf('j'), Blocks.field_150421_aI}));
        }
        if (Config.enableRebreather) {
            BookRecipeRegistry.addRecipe("rebreather", (IRecipe)new ShapedOreRecipe(SteamcraftItems.rebreather, new Object[]{" l ", "ptp", " c ", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('p'), SteamcraftBlocks.valvePipe, Character.valueOf('t'), SteamcraftBlocks.tank, Character.valueOf('c'), new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE)}));
        }
        if (Config.enableDragonRoar) {
            BookRecipeRegistry.addRecipe("dragonRoar", (IRecipe)new ShapedOreRecipe(SteamcraftItems.dragonRoar, new Object[]{"ccc", "cfc", "cpc", Character.valueOf('c'), "plateSteamcraftCopper", Character.valueOf('f'), SteamcraftBlocks.fan, Character.valueOf('p'), SteamcraftBlocks.valvePipe}));
        }
        if (Config.enableReloadingHolsters) {
            BookRecipeRegistry.addRecipe("reloadingHolsters", (IRecipe)new ShapedOreRecipe(SteamcraftItems.reloadingHolsters, new Object[]{"lbl", "c c", "p p", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('c'), SteamcraftItems.enhancementRevolver, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
        if (Config.enablePistonPush) {
            BookRecipeRegistry.addRecipe("pistonPush", (IRecipe)new ShapedOreRecipe(SteamcraftItems.pistonPush, new Object[]{"n p", "nbp", "n p", Character.valueOf('n'), "nuggetBrass", Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
        if (Config.enableHydrophobic) {
            BookRecipeRegistry.addRecipe("hydrophobic", (IRecipe)new ShapedOreRecipe(SteamcraftItems.coatingsHydrophobic, new Object[]{"zbz", "hzh", "sss", Character.valueOf('z'), "plateSteamcraftZinc", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('h'), SteamcraftBlocks.heater, Character.valueOf('s'), "slimeball"}));
        }
        if (Config.enablePyrophobic) {
            BookRecipeRegistry.addRecipe("pyrophobic", (IRecipe)new ShapedOreRecipe(SteamcraftItems.coatingsPyrophobic, new Object[]{"cbc", "hch", "mmm", Character.valueOf('c'), "plateSteamcraftCopper", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('h'), SteamcraftBlocks.heater, Character.valueOf('m'), Items.field_151064_bs}));
        }
    }

    public static void registerSteamToolUpgrades() {
        if (!Config.enableSteamTools) {
            return;
        }
        for (Map.Entry<String, DrillHeadMaterial> entry : DrillHeadMaterial.materials.entrySet()) {
            String materialString = entry.getKey();
            DrillHeadMaterial headMat = entry.getValue();
            if (headMat.standard) {
                GameRegistry.addRecipe((IRecipe)new DrillHeadRecipe(SteamcraftItems.drillHead, " n ", "iii", "ppp", Character.valueOf('n'), "nugget" + materialString, Character.valueOf('i'), "ingot" + materialString, Character.valueOf('p'), "plateSteamcraftIron"));
                continue;
            }
            GameRegistry.addRecipe((IRecipe)new DrillHeadRecipe(SteamcraftItems.drillHead, " g ", "ggg", "ppp", Character.valueOf('g'), headMat.oreName, Character.valueOf('p'), "plateSteamcraftIron"));
        }
        if (Config.enableFortune) {
            ItemStack fortuneBook = new ItemStack((Item)Items.field_151134_bR);
            fortuneBook.func_77966_a(Enchantment.field_77346_s, 3);
            BookRecipeRegistry.addRecipe("multiplicativeResonator", (IRecipe)new ShapedOreRecipe(SteamcraftItems.fortuneUpgrade, new Object[]{"rgr", "rbr", "rgr", Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), "plateSteamcraftGildedIron", Character.valueOf('b'), fortuneBook}));
        }
        if (Config.enableBigDrill) {
            BookRecipeRegistry.addRecipe("bigDrill", (IRecipe)new ShapedOreRecipe(SteamcraftItems.bigDrill, new Object[]{" p ", "pip", "ibi", Character.valueOf('p'), "plateSteamcraftIron", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), "blockIron"}));
        }
        if (Config.enableBattleDrill) {
            BookRecipeRegistry.addRecipe("battleDrill", (IRecipe)new ShapedOreRecipe(SteamcraftItems.battleDrill, new Object[]{" s ", "sbs", " p ", Character.valueOf('s'), Items.field_151040_l, Character.valueOf('b'), "plateSteamcraftBrass", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
        if (Config.enablePreciseCuttingHead) {
            BookRecipeRegistry.addRecipe("preciseCuttingHead", (IRecipe)new ShapedOreRecipe(SteamcraftItems.preciseCuttingHead, new Object[]{"f f", "pdp", "p p", Character.valueOf('f'), Items.field_151145_ak, Character.valueOf('p'), "plateSteamcraftBrass", Character.valueOf('d'), "gemDiamond"}));
        }
        if (Config.enableStoneGrinder) {
            BookRecipeRegistry.addRecipe("stoneGrinder", (IRecipe)new ShapedOreRecipe(SteamcraftItems.stoneGrinder, new Object[]{"i i", "ctc", "pcp", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), "cobblestone", Character.valueOf('p'), "plateSteamcraftIron", Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableThermalDrill) {
            BookRecipeRegistry.addRecipe("thermalDrill", (IRecipe)new ShapedOreRecipe(SteamcraftItems.thermalDrill, new Object[]{" b ", "bnb", "iii", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('n'), Blocks.field_150385_bj, Character.valueOf('i'), "ingotBrass"}));
        }
        if (Config.enableChargePlacer) {
            BookRecipeRegistry.addRecipe("chargePlacer", (IRecipe)new ShapedOreRecipe(SteamcraftItems.chargePlacer, new Object[]{"g g", "vbv", "sps", Character.valueOf('g'), Items.field_151010_B, Character.valueOf('v'), SteamcraftBlocks.valvePipe, Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('s'), SteamcraftBlocks.pipe, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
        if (Config.enableInternalProcessingUnit) {
            BookRecipeRegistry.addRecipe("internalProcessingUnit", (IRecipe)new ShapedOreRecipe(SteamcraftItems.internalProcessingUnit, new Object[]{"sco", Character.valueOf('s'), SteamcraftBlocks.smasher, Character.valueOf('c'), Blocks.field_150486_ae, Character.valueOf('o'), Blocks.field_150343_Z}));
        }
        if (Config.enableForestFire) {
            BookRecipeRegistry.addRecipe("forestFire", (IRecipe)new ShapedOreRecipe(SteamcraftItems.forestFire, new Object[]{" b ", "btb", " b ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableTreeFeller) {
            BookRecipeRegistry.addRecipe("treeFeller", (IRecipe)new ShapedOreRecipe(SteamcraftItems.treeFeller, new Object[]{"fpf", "p p", "fpf", Character.valueOf('f'), Items.field_151145_ak, Character.valueOf('p'), "plateSteamcraftIron"}));
        }
        if (Config.enableLeafBlower) {
            BookRecipeRegistry.addRecipe("leafBlower", (IRecipe)new ShapedOreRecipe(SteamcraftItems.leafBlower, new Object[]{" p ", "ptp", " p ", Character.valueOf('p'), "plateSteamcraftBrass", Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableChainsaw) {
            BookRecipeRegistry.addRecipe("chainsaw", (IRecipe)new ShapedOreRecipe(SteamcraftItems.chainsaw, new Object[]{" s ", "sps", " t ", Character.valueOf('s'), Items.field_151040_l, Character.valueOf('p'), "plateSteamcraftBrass", Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableBackhoe) {
            BookRecipeRegistry.addRecipe("backhoe", (IRecipe)new ShapedOreRecipe(SteamcraftItems.backhoe, new Object[]{"s", "p", "p", Character.valueOf('s'), SteamcraftItems.shovel("Brass"), Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
        if (Config.enableCultivator) {
            BookRecipeRegistry.addRecipe("cultivator", (IRecipe)new ShapedOreRecipe(SteamcraftItems.cultivator, new Object[]{"zsz", " z ", Character.valueOf('z'), "plateSteamcraftZinc", Character.valueOf('s'), "stickWood"}));
        }
        if (Config.enableRotaryBlades) {
            BookRecipeRegistry.addRecipe("rotaryBlades", (IRecipe)new ShapedOreRecipe(SteamcraftItems.rotaryBlades, new Object[]{" f ", "ftf", " f ", Character.valueOf('f'), Items.field_151145_ak, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableSifter) {
            BookRecipeRegistry.addRecipe("sifter", (IRecipe)new ShapedOreRecipe(SteamcraftItems.sifter, new Object[]{" p ", "ctc", " p ", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('c'), "cobblestone", Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableOverclocker) {
            BookRecipeRegistry.addRecipe("overclocker", (IRecipe)new ShapedOreRecipe(SteamcraftItems.overclocker, new Object[]{"r r", "btb", "r r", Character.valueOf('r'), "dustRedstone", Character.valueOf('b'), "ingotBrass", Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableAutosmelting) {
            BookRecipeRegistry.addRecipe("autosmelting", (IRecipe)new ShapedOreRecipe(SteamcraftItems.autosmelting, new Object[]{" f ", " h ", "rpr", Character.valueOf('f'), SteamcraftBlocks.fan, Character.valueOf('h'), SteamcraftBlocks.heater, Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('p'), Items.field_151065_br}));
        }
        if (Config.enableTheVoid) {
            BookRecipeRegistry.addRecipe("theVoid", (IRecipe)new ShapelessOreRecipe(SteamcraftItems.theVoid, new Object[]{Blocks.field_150477_bB, Blocks.field_150438_bZ}));
        }
    }

    public static void registerSteamTools() {
        if (Config.enableSteamTools) {
            BookRecipeRegistry.addRecipe("drill1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamDrill, 1, SteamcraftItems.steamDrill.func_77612_l() - 1), new Object[]{"xii", "pti", "xpx", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("drill2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamDrill, 1, SteamcraftItems.steamDrill.func_77612_l() - 1), new Object[]{"xii", "pti", "xpx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("drill3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamDrill, 1, SteamcraftItems.steamDrill.func_77612_l() - 1), new Object[]{"xii", "pti", "xpx", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("drill4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamDrill, 1, SteamcraftItems.steamDrill.func_77612_l() - 1), new Object[]{"xii", "pti", "xpx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("shovel1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamShovel, 1, SteamcraftItems.steamShovel.func_77612_l() - 1), new Object[]{"ixi", "ptx", "xpi", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("shovel2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamShovel, 1, SteamcraftItems.steamShovel.func_77612_l() - 1), new Object[]{"ixi", "ptx", "xpi", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("shovel3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamShovel, 1, SteamcraftItems.steamShovel.func_77612_l() - 1), new Object[]{"ixi", "ptx", "xpi", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("shovel4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamShovel, 1, SteamcraftItems.steamShovel.func_77612_l() - 1), new Object[]{"ixi", "ptx", "xpi", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("axe1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamAxe, 1, SteamcraftItems.steamAxe.func_77612_l() - 1), new Object[]{"ini", "ptn", "xpi", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5), Character.valueOf('n'), "nuggetIron"}));
            BookRecipeRegistry.addRecipe("axe2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamAxe, 1, SteamcraftItems.steamAxe.func_77612_l() - 1), new Object[]{"ini", "ptn", "xpi", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5), Character.valueOf('n'), "nuggetIron"}));
            BookRecipeRegistry.addRecipe("axe3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamAxe, 1, SteamcraftItems.steamAxe.func_77612_l() - 1), new Object[]{"ini", "ptn", "xpi", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5), Character.valueOf('n'), "nuggetIron"}));
            BookRecipeRegistry.addRecipe("axe4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamAxe, 1, SteamcraftItems.steamAxe.func_77612_l() - 1), new Object[]{"ini", "ptn", "xpi", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5), Character.valueOf('n'), "nuggetIron"}));
        }
    }

    public static void registerSteamNet() {
        if (Config.enableTank) {
            BookRecipeRegistry.addRecipe("tank1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.tank), new Object[]{"iii", "i i", "iii", Character.valueOf('i'), "plateSteamcraftBrass"}));
            BookRecipeRegistry.addRecipe("tank2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.tank), new Object[]{"iii", "i i", "iii", Character.valueOf('i'), "ingotBrass"}));
        }
        if (Config.enableBoiler) {
            BookRecipeRegistry.addRecipe("boiler1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.boiler), new Object[]{"xxx", "xfx", "xxx", Character.valueOf('x'), "ingotBrass", Character.valueOf('f'), Blocks.field_150460_al}));
            BookRecipeRegistry.addRecipe("boiler2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.boiler), new Object[]{"xxx", "xfx", "xxx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('f'), Blocks.field_150460_al}));
        }
        if (Config.enablePipe) {
            BookRecipeRegistry.addRecipe("pipe1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.pipe, 4, 0), new Object[]{"xxx", "   ", "xxx", Character.valueOf('x'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("pipe2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.pipe, 4, 0), new Object[]{"xxx", "   ", "xxx", Character.valueOf('x'), "plateSteamcraftBrass"}));
        }
        if (Config.enableValvePipe) {
            BookRecipeRegistry.addRecipe("valvePipe", (IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftBlocks.valvePipe), new Object[]{SteamcraftBlocks.pipe, Blocks.field_150442_at}));
        }
        if (Config.enableGauge) {
            BookRecipeRegistry.addRecipe("gauge", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.gauge), new Object[]{" x ", "xrx", " x ", Character.valueOf('x'), "nuggetBrass", Character.valueOf('r'), Items.field_151111_aL}));
        }
        if (Config.enableRuptureDisc) {
            BookRecipeRegistry.addRecipe("disc", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.ruptureDisc), new Object[]{" x ", "xrx", " x ", Character.valueOf('x'), "nuggetBrass", Character.valueOf('r'), "plateSteamcraftZinc"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftBlocks.ruptureDisc, 1, 0), new Object[]{"plateSteamcraftZinc", new ItemStack(SteamcraftBlocks.ruptureDisc, 1, 1)}));
        }
        if (Config.enableFlashBoiler) {
            BookRecipeRegistry.addRecipe("flashBoiler1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.flashBoiler, 2), new Object[]{"xtx", "pbp", "nnn", Character.valueOf('x'), "ingotBrass", Character.valueOf('b'), SteamcraftBlocks.boiler, Character.valueOf('t'), new ItemStack(SteamcraftBlocks.tank, 1, 0), Character.valueOf('n'), Blocks.field_150385_bj, Character.valueOf('p'), SteamcraftBlocks.pipe}));
            BookRecipeRegistry.addRecipe("flashBoiler2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.flashBoiler, 2), new Object[]{"xtx", "pbp", "nnn", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('b'), SteamcraftBlocks.boiler, Character.valueOf('t'), new ItemStack(SteamcraftBlocks.tank, 1, 0), Character.valueOf('n'), Blocks.field_150385_bj, Character.valueOf('p'), SteamcraftBlocks.pipe}));
        }
    }

    public static void registerSteamMachines() {
        if (Config.enableCharger) {
            BookRecipeRegistry.addRecipe("filler1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.charger), new Object[]{" p ", "xpx", "xpx", Character.valueOf('x'), Blocks.field_150347_e, Character.valueOf('p'), SteamcraftBlocks.pipe}));
            BookRecipeRegistry.addRecipe("filler2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.charger), new Object[]{" p ", "xpx", "xpx", Character.valueOf('x'), "blockCobble", Character.valueOf('p'), SteamcraftBlocks.pipe}));
        }
        if (Config.enableChargingPad && Config.enableCharger) {
            BookRecipeRegistry.addRecipe("fillingPad1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.chargingPad), new Object[]{"p p", "pcp", "pbp", Character.valueOf('c'), SteamcraftBlocks.charger, Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('b'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("fillingPad2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.chargingPad), new Object[]{"p p", "pcp", "pbp", Character.valueOf('c'), SteamcraftBlocks.charger, Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('b'), "plateSteamcraftBrass"}));
        }
        if (Config.enablePump) {
            BookRecipeRegistry.addRecipe("pump1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.pump), new Object[]{"gng", "iii", "ngn", Character.valueOf('i'), "plateSteamcraftBrass", Character.valueOf('n'), "nuggetBrass", Character.valueOf('g'), Blocks.field_150410_aZ}));
            BookRecipeRegistry.addRecipe("pump2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.pump), new Object[]{"gng", "iii", "ngn", Character.valueOf('i'), "ingotBrass", Character.valueOf('n'), "nuggetBrass", Character.valueOf('g'), Blocks.field_150410_aZ}));
        }
        if (Config.enableFluidSteamConverter) {
            BookRecipeRegistry.addRecipe("fsc1", (IRecipe)new ShapedOreRecipe(SteamcraftBlocks.fluidSteamConverter, new Object[]{"xlx", "gpp", "xlx", Character.valueOf('x'), "ingotBrass", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('g'), Blocks.field_150410_aZ}));
            BookRecipeRegistry.addRecipe("fsc1", (IRecipe)new ShapedOreRecipe(SteamcraftBlocks.fluidSteamConverter, new Object[]{"xlx", "gpp", "xlx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('g'), Blocks.field_150410_aZ}));
        }
        if (Config.enableFan) {
            BookRecipeRegistry.addRecipe("fan1", (IRecipe)new ShapedOreRecipe(SteamcraftBlocks.fan, new Object[]{"xxx", "btb", "xxx", Character.valueOf('x'), "ingotBrass", Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
            BookRecipeRegistry.addRecipe("fan2", (IRecipe)new ShapedOreRecipe(SteamcraftBlocks.fan, new Object[]{"xxx", "btb", "xxx", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('t'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 5)}));
        }
        if (Config.enableVacuum && Config.enableFan) {
            BookRecipeRegistry.addRecipe("vacuum1", (IRecipe)new ShapedOreRecipe(SteamcraftBlocks.vacuum, new Object[]{" x ", "pfx", " x ", Character.valueOf('x'), "ingotBrass", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('f'), SteamcraftBlocks.fan}));
            BookRecipeRegistry.addRecipe("vacuum2", (IRecipe)new ShapedOreRecipe(SteamcraftBlocks.vacuum, new Object[]{" x ", "pfx", " x ", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('p'), SteamcraftBlocks.pipe, Character.valueOf('f'), SteamcraftBlocks.fan}));
        }
        if (Config.enableHeater) {
            BookRecipeRegistry.addRecipe("heater1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.heater), new Object[]{"ccc", "xfx", " p ", Character.valueOf('x'), "ingotBrass", Character.valueOf('c'), "nuggetCopper", Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('p'), SteamcraftBlocks.pipe}));
            BookRecipeRegistry.addRecipe("heater2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.heater), new Object[]{"ccc", "xfx", " p ", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('c'), "nuggetCopper", Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('p'), SteamcraftBlocks.pipe}));
        }
        if (Config.enableHammer) {
            BookRecipeRegistry.addRecipe("hammer1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.hammer), new Object[]{" ix", "bix", Character.valueOf('x'), "ingotBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), Blocks.field_150339_S}));
            BookRecipeRegistry.addRecipe("hammer2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.hammer), new Object[]{" ix", "bix", Character.valueOf('x'), "plateSteamcraftBrass", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), Blocks.field_150339_S}));
        }
        if (Config.enableMortar) {
            BookRecipeRegistry.addRecipe("itemMortar1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.itemMortar), new Object[]{"p p", "pbp", "ccc", Character.valueOf('p'), "plateSteamcraftBrass", Character.valueOf('c'), "plateSteamcraftCopper", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
            BookRecipeRegistry.addRecipe("itemMortar2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.itemMortar), new Object[]{"p p", "pbp", "ccc", Character.valueOf('p'), "ingotBrass", Character.valueOf('c'), "plateSteamcraftCopper", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
            BookRecipeRegistry.addRecipe("itemMortar3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.itemMortar), new Object[]{"p p", "pbp", "ccc", Character.valueOf('p'), "plateSteamcraftBrass", Character.valueOf('c'), "ingotCopper", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
            BookRecipeRegistry.addRecipe("itemMortar4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.itemMortar), new Object[]{"p p", "pbp", "ccc", Character.valueOf('p'), "ingotBrass", Character.valueOf('c'), "ingotCopper", Character.valueOf('b'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0)}));
        }
        if (Config.enableSmasher) {
            BookRecipeRegistry.addRecipe("smasher1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.smasher), new Object[]{"bpi", "bpi", "bpi", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "plateSteamcraftBrass"}));
            BookRecipeRegistry.addRecipe("smasher2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.smasher), new Object[]{"bpi", "bpi", "bpi", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "ingotBrass"}));
            BookRecipeRegistry.addRecipe("smasher3", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.smasher), new Object[]{"bpi", "bpi", "bpi", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "plateSteamcraftBrass"}));
            BookRecipeRegistry.addRecipe("smasher4", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.smasher), new Object[]{"bpi", "bpi", "bpi", Character.valueOf('i'), "plateSteamcraftIron", Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('b'), "ingotBrass"}));
        }
        if (Config.enableThumper) {
            BookRecipeRegistry.addRecipe("thumper1", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.thumper), new Object[]{"pbp", "ebe", "xix", Character.valueOf('i'), "blockIron", Character.valueOf('b'), "blockBrass", Character.valueOf('e'), SteamcraftBlocks.pipe, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('x'), "plateSteamcraftBrass"}));
            BookRecipeRegistry.addRecipe("thumper2", (IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.thumper), new Object[]{"pbp", "ebe", "xix", Character.valueOf('i'), "blockIron", Character.valueOf('b'), "blockBrass", Character.valueOf('e'), SteamcraftBlocks.pipe, Character.valueOf('p'), new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 0), Character.valueOf('x'), "ingotBrass"}));
        }
    }

    public static void registerMetalCrafting() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.blockBrass), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), "ingotBrass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftIngot, 9, 2), new Object[]{"i", Character.valueOf('i'), "blockBrass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.blockCopper), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), "ingotCopper"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftIngot, 9, 0), new Object[]{"i", Character.valueOf('i'), "blockCopper"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftBlocks.blockZinc), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), "ingotZinc"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftIngot, 9, 1), new Object[]{"i", Character.valueOf('i'), "blockZinc"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.steamcraftNugget, 9, 0), new Object[]{"ingotCopper"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.steamcraftNugget, 9, 1), new Object[]{"ingotZinc"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.steamcraftNugget, 9, 2), new Object[]{new ItemStack(Items.field_151042_j)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(SteamcraftItems.steamcraftNugget, 9, 3), new Object[]{"ingotBrass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftIngot, 1, 0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetCopper"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftIngot, 1, 1), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetZinc"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151042_j), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(SteamcraftItems.steamcraftIngot, 1, 2), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetBrass"}));
    }

    public static void addExosuitPlateRecipes(String str, Object ingredient, ItemStack plate) {
        BookRecipeRegistry.addRecipe(str, (IRecipe)new ShapedOreRecipe(plate, new Object[]{"xx", "xx", Character.valueOf('x'), ingredient}));
        if (ingredient instanceof ItemStack) {
            ItemStack stack = ((ItemStack)ingredient).func_77946_l();
            stack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(stack, new Object[]{plate}));
        } else if (ingredient instanceof String) {
            ItemStack stack = ((ItemStack)OreDictionary.getOres((String)((String)ingredient)).get(0)).func_77946_l();
            stack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(stack, new Object[]{plate}));
        }
    }

    public static void addExosuitPlateRecipes(String str, Object ingredient, ItemStack plate, CrucibleLiquid liq) {
        BookRecipeRegistry.addRecipe(str, (IRecipe)new ShapedOreRecipe(plate, new Object[]{"xx", "xx", Character.valueOf('x'), ingredient}));
        if (ingredient instanceof ItemStack) {
            ItemStack stack = ((ItemStack)ingredient).func_77946_l();
            stack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(stack, new Object[]{plate}));
        } else if (ingredient instanceof String) {
            ItemStack stack = ((ItemStack)OreDictionary.getOres((String)((String)ingredient)).get(0)).func_77946_l();
            stack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(stack, new Object[]{plate}));
        }
        SteamcraftRegistry.registerMeltRecipe(plate.func_77973_b(), plate.func_77960_j(), liq, 24);
    }

    public static void registerDustLiquids() {
        SteamcraftRegistry.registerMeltRecipeOreDict("dustGold", liquidGold, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustIron", liquidIron, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustZinc", liquidZinc, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustCopper", liquidCopper, 9);
        SteamcraftRegistry.registerMeltRecipeOreDict("dustBrass", liquidBrass, 9);
    }

    private static void registerSmashingRecipes() {
        TileEntitySmasher.REGISTRY.registerSmashable(Blocks.field_150347_e, new ItemStack(Blocks.field_150351_n));
        TileEntitySmasher.REGISTRY.registerSmashable(Blocks.field_150463_bK, new ItemStack(Blocks.field_150351_n));
        TileEntitySmasher.REGISTRY.registerSmashable(Blocks.field_150351_n, new ItemStack((Block)Blocks.field_150354_m));
        TileEntitySmasher.REGISTRY.registerSmashable(Blocks.field_150426_aN, new ItemStack(Items.field_151114_aO, 4));
        TileEntitySmasher.REGISTRY.registerSmashable(Blocks.field_150322_A, new ItemStack((Block)Blocks.field_150354_m));
    }
}

