/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api;

import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.Tuple3;
import flaxbeard.steamcraft.api.book.BookPage;
import flaxbeard.steamcraft.api.book.ICraftingPage;
import flaxbeard.steamcraft.api.enhancement.IEnhancement;
import flaxbeard.steamcraft.api.enhancement.IRocket;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.MutablePair;

public class SteamcraftRegistry {
    public static ArrayList<Item> molds = new ArrayList();
    public static ArrayList<CrucibleLiquid> liquids = new ArrayList();
    public static HashMap<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> liquidRecipes = new HashMap();
    public static HashMap<Tuple3, MutablePair<Integer, ItemStack>> dunkRecipes = new HashMap();
    public static HashMap<MutablePair<Item, IEnhancement>, IIcon> enhancementIcons = new HashMap();
    public static HashMap<String, IEnhancement> enhancements = new HashMap();
    public static ArrayList<IRocket> rockets = new ArrayList();
    public static ArrayList<String> categories = new ArrayList();
    public static ArrayList<MutablePair<String, String>> research = new ArrayList();
    public static HashMap<String, BookPage[]> researchPages = new HashMap();
    public static HashMap<ItemStack, MutablePair<String, Integer>> bookRecipes = new HashMap();
    public static ArrayList<String> entriesWithSubEntries = new ArrayList();
    public static HashMap<String, ExosuitPlate> plates = new HashMap();
    public static HashMap<MutablePair<Integer, ExosuitPlate>, IIcon> plateIcons = new HashMap();
    public static HashMap<MutablePair<Item, Integer>, MutablePair<Item, Integer>> steamingRecipes = new HashMap();

    public static void addSteamingRecipe(Item food1, int i, Item food2, int j) {
        steamingRecipes.put((MutablePair<Item, Integer>)MutablePair.of((Object)food1, (Object)i), (MutablePair<Item, Integer>)MutablePair.of((Object)food2, (Object)j));
    }

    public static void addSteamingRecipe(Item food1, Item food2) {
        steamingRecipes.put((MutablePair<Item, Integer>)MutablePair.of((Object)food1, (Object)0), (MutablePair<Item, Integer>)MutablePair.of((Object)food2, (Object)0));
    }

    public static void removeSteamingRecipe(Item food1, int i) {
        steamingRecipes.remove(MutablePair.of((Object)food1, (Object)i));
    }

    public static void removeSteamingRecipe(Item food1) {
        SteamcraftRegistry.removeSteamingRecipe(food1, 0);
    }

    public static void addExosuitPlate(ExosuitPlate plate) {
        plates.put(plate.getIdentifier(), plate);
    }

    public static void addCarvableMold(Item mold) {
        molds.add(mold);
    }

    public static boolean removeMold(Item mold) {
        return molds.remove(mold);
    }

    public static void addCategory(String string) {
        categories.add(string);
    }

    public static void addResearch(String string, String category, BookPage ... pages) {
        if (!category.substring(0, 1).equals("!")) {
            research.add((MutablePair<String, String>)MutablePair.of((Object)string, (Object)category));
            researchPages.put(string, pages);
            int pageNum = 0;
            for (BookPage page : pages) {
                if (page instanceof ICraftingPage) {
                    for (ItemStack craftedItem : ((ICraftingPage)((Object)page)).getCraftedItem()) {
                        bookRecipes.put(craftedItem, (MutablePair<String, Integer>)MutablePair.of((Object)string, (Object)pageNum));
                    }
                }
                ++pageNum;
            }
        } else {
            entriesWithSubEntries.add(category.substring(1));
            BookPage[] targetPages = researchPages.get(category.substring(1));
            int pageNum = targetPages.length;
            for (BookPage page : pages) {
                if (page instanceof ICraftingPage) {
                    for (ItemStack craftedItem : ((ICraftingPage)((Object)page)).getCraftedItem()) {
                        bookRecipes.put(craftedItem, (MutablePair<String, Integer>)MutablePair.of((Object)category.substring(1), (Object)pageNum));
                    }
                }
                ++pageNum;
            }
            ArrayList<BookPage> pages2 = new ArrayList<BookPage>(Arrays.asList(targetPages));
            pages2.addAll(Arrays.asList(pages));
            researchPages.put(category.substring(1), pages2.toArray(new BookPage[pages2.size()]));
        }
    }

    public static CrucibleLiquid getLiquidFromName(String name) {
        for (CrucibleLiquid liquid : liquids) {
            if (!liquid.name.equals(name)) continue;
            return liquid;
        }
        return null;
    }

    public static void registerDunkRecipe(Item item, int meta, CrucibleLiquid liquid, int liquidAmount, ItemStack result) {
        dunkRecipes.put(new Tuple3(item, meta, liquid), (MutablePair<Integer, ItemStack>)MutablePair.of((Object)liquidAmount, (Object)result));
    }

    public static void registerDunkRecipe(Item item, CrucibleLiquid liquid, int liquidAmount, ItemStack result) {
        SteamcraftRegistry.registerDunkRecipe(item, -1, liquid, liquidAmount, result);
    }

    public static void removeDunkRecipe(Item item, int meta, CrucibleLiquid liquid) {
        if (dunkRecipes != null) {
            Iterator<Map.Entry<Tuple3, MutablePair<Integer, ItemStack>>> iter = dunkRecipes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Tuple3, MutablePair<Integer, ItemStack>> entry = iter.next();
                Tuple3 key = entry.getKey();
                if (key.first != item || (Integer)key.second != meta || key.third != liquid) continue;
                iter.remove();
            }
        }
    }

    public static void removeDunkRecipe(Item item, CrucibleLiquid liquid) {
        SteamcraftRegistry.removeDunkRecipe(item, -1, liquid);
    }

    public static void registerOreDictDunkRecipe(String dict, CrucibleLiquid liquid, int liquidAmount, ItemStack result) {
        ArrayList ores = OreDictionary.getOres((String)dict);
        for (ItemStack ore : ores) {
            SteamcraftRegistry.registerDunkRecipe(ore.func_77973_b(), ore.func_77960_j(), liquid, liquidAmount, result);
        }
    }

    public static void removeOreDictDunkRecipe(String dict, CrucibleLiquid liquid) {
        ArrayList ores = OreDictionary.getOres((String)dict);
        for (ItemStack ore : ores) {
            SteamcraftRegistry.removeDunkRecipe(ore.func_77973_b(), ore.func_77960_j(), liquid);
        }
    }

    public static void registerMeltRecipe(Item item, int i, CrucibleLiquid liquid, int m) {
        liquidRecipes.put((MutablePair<Item, Integer>)MutablePair.of((Object)item, (Object)i), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)liquid, (Object)m));
    }

    public static void registerMeltRecipe(Item item, CrucibleLiquid liquid, int m) {
        liquidRecipes.put((MutablePair<Item, Integer>)MutablePair.of((Object)item, (Object)-1), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)liquid, (Object)m));
    }

    public static void registerMeltRecipeOreDict(String dict, CrucibleLiquid liquid, int m) {
        ArrayList ores = OreDictionary.getOres((String)dict);
        for (ItemStack ore : ores) {
            SteamcraftRegistry.registerMeltRecipe(ore.func_77973_b(), ore.func_77960_j(), liquid, m);
        }
    }

    public static void registerMeltRecipeTool(Item item, CrucibleLiquid liquid, int m) {
        for (int i = 0; i < item.func_77612_l(); ++i) {
            liquidRecipes.put((MutablePair<Item, Integer>)MutablePair.of((Object)item, (Object)i), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)liquid, (Object)MathHelper.func_76128_c((double)((float)m * ((float)(item.func_77612_l() - i) / (float)item.func_77612_l())))));
        }
    }

    public static void removeMeltRecipeOreDict(String dict, CrucibleLiquid liquid) {
        ArrayList ores = OreDictionary.getOres((String)dict);
        for (ItemStack ore : ores) {
            SteamcraftRegistry.removeMeltRecipe(ore.func_77973_b(), ore.func_77960_j(), liquid);
        }
    }

    public static void removeMeltRecipeTool(Item item, CrucibleLiquid liquid) {
        for (int j = 0; j < item.func_77612_l(); ++j) {
            SteamcraftRegistry.removeMeltRecipe(item, j, liquid);
        }
    }

    public static void removeMeltRecipe(Item item, int meta, CrucibleLiquid liquid) {
        MutablePair input = MutablePair.of((Object)item, (Object)meta);
        if (liquidRecipes.containsKey(input)) {
            MutablePair<CrucibleLiquid, Integer> output = liquidRecipes.get(input);
            if (output.left == liquid) {
                liquidRecipes.remove(input);
            }
        }
    }

    public static void removeMeltRecipe(Item item, CrucibleLiquid liquid) {
        SteamcraftRegistry.removeMeltRecipe(item, -1, liquid);
    }

    public static void registerLiquid(CrucibleLiquid liquid) {
        liquids.add(liquid);
    }

    public static void removeLiquid(CrucibleLiquid liquid) {
        liquids.remove(liquid);
        if (liquidRecipes != null) {
            for (Map.Entry<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> entry : liquidRecipes.entrySet()) {
                if (entry.getValue().left != liquid) continue;
                liquidRecipes.remove(entry.getKey());
            }
        }
    }

    public static void registerEnhancement(IEnhancement enhancement) {
        enhancements.put(enhancement.getID(), enhancement);
    }

    public static void registerRocket(IRocket rocket) {
        rockets.add(rocket);
    }
}

