/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api.steamnet;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.steamnet.SteamNetworkRegistry;
import flaxbeard.steamcraft.api.util.Coord4;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import flaxbeard.steamcraft.tile.TileEntityValvePipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SteamNetwork {
    protected static SPLog slog = Steamcraft.log;
    private static Random random = new Random();
    protected SPLog log = Steamcraft.log;
    private int refreshWaitTicks = 0;
    private int globalRefreshTicks = 300;
    private String name;
    private int steam;
    private int capacity;
    private boolean shouldRefresh = false;
    private Coord4[] transporterCoords;
    private int initializedTicks = 0;
    private HashMap<Coord4, ISteamTransporter> transporters = new HashMap();

    public SteamNetwork() {
        this.steam = 0;
        this.capacity = 0;
    }

    public SteamNetwork(int capacity) {
        this.capacity = capacity;
    }

    public SteamNetwork(int capacity, String name, ArrayList<Coord4> coordList) {
        this(capacity);
        for (Coord4 c : coordList) {
            this.transporters.put(c, null);
        }
        this.name = name;
    }

    public static synchronized SteamNetwork newOrJoin(ISteamTransporter trans) {
        if (SteamNetwork.isClosedValvePipe(trans)) {
            return null;
        }
        HashSet<ISteamTransporter> others = SteamNetwork.getNeighboringTransporters(trans);
        HashSet<SteamNetwork> nets = new HashSet<SteamNetwork>();
        SteamNetwork theNetwork = null;
        boolean hasJoinedNetwork = false;
        if (others.size() > 0) {
            for (ISteamTransporter t : others) {
                SteamNetwork net;
                if (SteamNetwork.isClosedValvePipe(t) || t.getNetwork() == null || (net = t.getNetwork()) == null) continue;
                nets.add(net);
            }
            if (nets.size() > 0) {
                SteamNetwork main = null;
                for (SteamNetwork net : nets) {
                    if (main != null) {
                        main.join(net);
                        continue;
                    }
                    main = net;
                }
                if (main != null) {
                    main.addTransporter(trans);
                }
                hasJoinedNetwork = true;
                theNetwork = main;
            }
        }
        if (!hasJoinedNetwork) {
            SteamNetwork net = SteamNetworkRegistry.getInstance().getNewNetwork();
            net.addTransporter(trans);
            SteamNetworkRegistry.getInstance().add(net);
            theNetwork = net;
        }
        return theNetwork;
    }

    public static HashSet<ISteamTransporter> getNeighboringTransporters(ISteamTransporter trans) {
        HashSet<ISteamTransporter> out = new HashSet<ISteamTransporter>();
        Coord4 transCoords = trans.getCoords();
        for (ForgeDirection d : trans.getConnectionSides()) {
            TileEntity te = trans.getWorld().func_147438_o(transCoords.x + d.offsetX, transCoords.y + d.offsetY, transCoords.z + d.offsetZ);
            if (te == null || !(te instanceof ISteamTransporter) || te == trans) continue;
            boolean isNeighbor = false;
            ISteamTransporter t = (ISteamTransporter)te;
            if (t.getConnectionSides().contains(d.getOpposite())) {
                out.add(t);
                if (t instanceof TileEntitySteamPipe) {
                    // empty if block
                }
                isNeighbor = true;
            }
            TileEntitySteamPipe pipe = null;
            TileEntitySteamPipe other = null;
            if (trans instanceof TileEntitySteamPipe) {
                pipe = (TileEntitySteamPipe)trans;
            }
            if (t instanceof TileEntitySteamPipe) {
                other = (TileEntitySteamPipe)t;
            }
            if (pipe != null && other != null && (!pipe.isOriginalPipe || !other.isOtherPipe) && pipe.isOtherPipe && !other.isOriginalPipe) continue;
        }
        return out;
    }

    private static boolean isClosedValvePipe(ISteamTransporter trans) {
        return trans instanceof TileEntityValvePipe && !((TileEntityValvePipe)trans).isOpen();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbtl = new NBTTagList();
        return nbt;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean tick() {
        if (this.transporters.size() == 0) {
            this.log.debug("No transporters (" + this.getShortName() + ")");
            return false;
        }
        if (this.shouldRefresh) {
            if (this.refreshWaitTicks > 0) {
                --this.refreshWaitTicks;
            } else {
                this.refresh();
                this.shouldRefresh = false;
            }
        }
        if (this.globalRefreshTicks > 0) {
            --this.globalRefreshTicks;
        } else {
            this.refresh();
            this.globalRefreshTicks = 300;
        }
        if (this.initializedTicks >= 1200) {
            if (Config.wimpMode) {
                if (!(this.getPressure() > 1.09f)) return true;
                this.steam = (int)Math.floor((double)this.capacity * 1.09);
                return true;
            } else {
                if (this.transporters == null) return false;
                if (!(this.getPressure() > 1.2f)) return true;
                for (Coord4 coords : this.transporters.keySet()) {
                    ISteamTransporter trans = this.transporters.get(coords);
                    if (trans == null || ((TileEntity)trans).func_145837_r()) {
                        this.transporters.remove(coords);
                        continue;
                    }
                    if (trans.getWorld().field_72995_K || !this.shouldExplode(this.oneInX(this.getPressure(), trans.getPressureResistance()))) continue;
                    this.log.debug(trans.getName() + " is exploding.  (" + this.getSteam() + " " + this.getCapacity() + " " + this.getPressure() + ")");
                    trans.explode();
                }
            }
            return true;
        } else {
            ++this.initializedTicks;
        }
        return true;
    }

    public synchronized void addSteam(int amount) {
        this.steam += amount;
        this.shouldRefresh();
    }

    public synchronized void decrSteam(int amount) {
        this.steam -= amount;
        if (this.steam < 0) {
            this.steam = 0;
        }
    }

    public int getSteam() {
        return this.steam;
    }

    public int getCapacity() {
        return this.capacity;
    }

    private int oneInX(float pressure, float resistance) {
        return Math.max(1, (int)Math.floor(500.0f - pressure / (1.1f + resistance) * 100.0f));
    }

    private boolean shouldExplode(int oneInX) {
        return oneInX <= 1 || random.nextInt(oneInX - 1) == 0;
    }

    public float getPressure() {
        if (this.capacity > 0) {
            return (float)this.steam / (float)this.capacity;
        }
        return 0.0f;
    }

    public int getSize() {
        return this.transporters.size();
    }

    public synchronized void addTransporter(ISteamTransporter trans) {
        if (trans != null && !this.contains(trans)) {
            this.capacity += trans.getCapacity();
            Coord4 transCoords = trans.getCoords();
            this.transporters.put(transCoords, trans);
            trans.setNetworkName(this.name);
            trans.setNetwork(this);
            this.addSteam(trans.getSteam());
            trans.wasAdded();
            SteamNetworkRegistry.markDirty(this);
        }
    }

    public void setTransporterCoords(Coord4[] coords) {
        this.transporterCoords = coords;
    }

    public synchronized void init(World world) {
        if (this.transporterCoords != null) {
            this.loadTransporters(world);
        }
    }

    public synchronized void loadTransporters(World world) {
        for (int i = this.transporterCoords.length - 1; i >= 0; --i) {
            Coord4 coords = this.transporterCoords[i];
            int x = coords.x;
            int y = coords.y;
            int z = coords.z;
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof ISteamTransporter)) continue;
            this.transporters.put(this.transporterCoords[i], (ISteamTransporter)te);
        }
    }

    public synchronized int split(ISteamTransporter split, boolean removeCapacity) {
        int steamRemoved = 0;
        if (removeCapacity && (float)this.steam >= (float)split.getCapacity() * this.getPressure()) {
            steamRemoved = (int)Math.floor((double)split.getCapacity() * (double)this.getPressure());
            this.steam -= steamRemoved;
            this.capacity -= split.getCapacity();
        }
        for (ISteamTransporter trans : this.transporters.values()) {
            trans.updateSteam((int)((float)trans.getCapacity() * this.getPressure()));
        }
        HashSet<SteamNetwork> newNets = new HashSet<SteamNetwork>();
        boolean hasrun = false;
        for (ISteamTransporter trans : SteamNetwork.getNeighboringTransporters(split)) {
            if (SteamNetwork.isClosedValvePipe(trans)) continue;
            boolean isInNetwork = false;
            if (newNets.size() > 0) {
                for (SteamNetwork net : newNets) {
                    if (!net.contains(trans)) continue;
                    isInNetwork = true;
                    break;
                }
            }
            if (isInNetwork) continue;
            SteamNetwork net = SteamNetworkRegistry.getInstance().getNewNetwork();
            ISteamTransporter ignore = null;
            if (removeCapacity) {
                ignore = split;
            }
            net.buildFromTransporter(trans, net, ignore);
            newNets.add(net);
            hasrun = true;
        }
        if (newNets.size() > 0) {
            for (SteamNetwork net : newNets) {
                int steamShare = (int)Math.floor((float)net.capacity * this.getPressure());
                SteamNetworkRegistry.getInstance().add(net);
                net.shouldRefresh();
            }
        }
        this.shouldRefresh();
        return steamRemoved;
    }

    public synchronized void buildFromTransporter(ISteamTransporter trans, SteamNetwork target, ISteamTransporter ignore) {
        HashSet<ISteamTransporter> checked = new HashSet<ISteamTransporter>();
        HashSet<ISteamTransporter> members = target.crawlNetwork(trans, checked, ignore);
        boolean targetIsThis = target == this;
        SteamNetwork net = targetIsThis ? this : SteamNetworkRegistry.getInstance().getNewNetwork();
        for (ISteamTransporter member : members) {
            if (this.transporters.containsValue(member)) continue;
            target.addTransporter(member);
        }
        net.addTransporter(trans);
    }

    public boolean contains(ISteamTransporter trans) {
        return this.transporters.containsValue(trans);
    }

    protected HashSet<ISteamTransporter> crawlNetwork(ISteamTransporter trans, HashSet<ISteamTransporter> checked, ISteamTransporter ignore) {
        if (checked == null) {
            checked = new HashSet();
        }
        if (!checked.contains(trans) && !SteamNetwork.isClosedValvePipe(trans)) {
            checked.add(trans);
        }
        HashSet<ISteamTransporter> neighbors = SteamNetwork.getNeighboringTransporters(trans);
        for (ISteamTransporter neighbor : neighbors) {
            if (checked.contains(neighbor) || neighbor == ignore || SteamNetwork.isClosedValvePipe(neighbor)) continue;
            checked.add(neighbor);
            this.crawlNetwork(neighbor, checked, ignore);
        }
        return checked;
    }

    private HashSet<ISteamTransporter> getNeighborTransporters(ISteamTransporter trans) {
        HashSet<ISteamTransporter> out = new HashSet<ISteamTransporter>();
        Coord4 coords = trans.getCoords();
        int x = coords.x;
        int y = coords.y;
        int z = coords.z;
        for (ForgeDirection dir : trans.getConnectionSides()) {
            TileEntity te = trans.getWorld().func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (te == null || !(te instanceof ISteamTransporter)) continue;
            ISteamTransporter neighbor = (ISteamTransporter)te;
            out.add(neighbor);
        }
        return out;
    }

    public void join(SteamNetwork other) {
        for (ISteamTransporter trans : other.transporters.values()) {
            this.addTransporter(trans);
        }
        SteamNetworkRegistry.getInstance().remove(other);
    }

    public int getDimension() {
        if (this.transporters.size() > 0) {
            return this.transporters.keySet().iterator().next().dimension;
        }
        return -999;
    }

    public World getWorld() {
        if (this.transporters.values().iterator().hasNext() && this.transporters.values().iterator().next() != null) {
            return this.transporters.values().iterator().next().getWorld();
        }
        return null;
    }

    public void markDirty() {
        SteamNetworkRegistry.markDirty(this);
    }

    public synchronized void refresh() {
        float press = this.getPressure();
        int targetCapacity = 0;
        if (this.transporters.size() == 0) {
            SteamNetworkRegistry.getInstance().remove(this);
            return;
        }
        try {
            HashMap temp = (HashMap)this.transporters.clone();
            for (Coord4 c : temp.keySet()) {
                TileEntity te = c.getTileEntity((IBlockAccess)this.getWorld());
                if (te == null || !(te instanceof ISteamTransporter)) {
                    this.transporters.remove(c);
                    continue;
                }
                ISteamTransporter trans = (ISteamTransporter)te;
                if (trans.getNetwork() != this) {
                    this.transporters.remove(c);
                    this.steam = (int)((float)this.steam - this.getPressure() * (float)trans.getCapacity());
                    this.transporters.remove(c);
                    continue;
                }
                targetCapacity += trans.getCapacity();
            }
        }
        catch (Exception e) {
            this.log.error("SteamNetwork: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.capacity != targetCapacity) {
            this.log.debug("target: " + targetCapacity + "; curent: " + this.capacity);
            this.log.debug("steam: " + this.steam + "; pressure: " + this.getPressure());
            int idealSteam = (int)((float)targetCapacity * press);
            this.log.debug("idealSteam: " + idealSteam + "; ideal steam: " + (float)targetCapacity * this.getPressure());
            this.steam = idealSteam;
            this.capacity = targetCapacity;
        }
    }

    public void shouldRefresh() {
        this.shouldRefresh = true;
        this.refreshWaitTicks = 40;
    }

    public String getShortName() {
        return this.name.subSequence(0, 5).toString();
    }
}

