/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.block.BlockSteamTransporter;
import flaxbeard.steamcraft.misc.FluidHelper;
import flaxbeard.steamcraft.tile.TileEntityFlashBoiler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class BlockFlashBoiler
extends BlockSteamTransporter {
    private final Random rand = new Random();
    public IIcon otherIcon;
    public IIcon specialIcon;
    public IIcon topLeft;
    public IIcon topLeftSide;
    public IIcon bottomLeft;
    public IIcon topRight;
    public IIcon topRightSide;
    public IIcon bottomRight;
    public IIcon topLeftF;
    public IIcon bottomLeftF;
    public IIcon topRightF;
    public IIcon bottomRightF;
    public IIcon topLeftO;
    public IIcon bottomLeftO;
    public IIcon topRightO;
    public IIcon bottomRightO;

    public BlockFlashBoiler() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFlashBoiler();
    }

    @Override
    public void func_149725_f(World world, int x, int y, int z, int meta) {
        super.func_149725_f(world, x, y, z, meta);
        TileEntityFlashBoiler boiler = (TileEntityFlashBoiler)world.func_147438_o(x, y, z);
        if (boiler != null) {
            for (int i1 = 0; i1 < boiler.func_70302_i_(); ++i1) {
                ItemStack itemstack = boiler.func_70301_a(i1);
                if (itemstack != null) {
                    float f = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int j1 = this.rand.nextInt(21) + 10;
                        if (j1 > itemstack.field_77994_a) {
                            j1 = itemstack.field_77994_a;
                        }
                        itemstack.field_77994_a -= j1;
                        EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                        if (itemstack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                        }
                        float f3 = 0.05f;
                        entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                        entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                        entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                        world.func_72838_d((Entity)entityitem);
                    }
                }
                boiler.func_70299_a(i1, null);
            }
        }
        if (meta > 0) {
            TileEntityFlashBoiler te = (TileEntityFlashBoiler)world.func_147438_o(x, y, z);
            te.destroyMultiblock();
        }
    }

    public void checkMultiblock(World world, int x, int y, int z, boolean isBreaking, int frontSide) {
        if (!world.field_72995_K) {
            TileEntityFlashBoiler boiler = (TileEntityFlashBoiler)world.func_147438_o(x, y, z);
            boiler.checkMultiblock(isBreaking, frontSide);
        }
    }

    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("steamcraft:flashBoiler");
        this.otherIcon = ir.func_94245_a("steamcraft:testFront");
        this.specialIcon = ir.func_94245_a("steamcraft:testSpecial");
        this.topLeft = ir.func_94245_a("steamcraft:flashBoilerTopLeft");
        this.topLeftSide = ir.func_94245_a("steamcraft:flashBoilerTopLeftSide");
        this.bottomLeft = ir.func_94245_a("steamcraft:flashBoilerBottomLeft");
        this.topRight = ir.func_94245_a("steamcraft:flashBoilerTopRight");
        this.topRightSide = ir.func_94245_a("steamcraft:flashBoilerTopRightSide");
        this.bottomRight = ir.func_94245_a("steamcraft:flashBoilerBottomRight");
        this.topLeftF = ir.func_94245_a("steamcraft:flashBoilerTopLeftO");
        this.bottomLeftF = ir.func_94245_a("steamcraft:flashBoilerBottomLeftO");
        this.topRightF = ir.func_94245_a("steamcraft:flashBoilerTopRightO");
        this.bottomRightF = ir.func_94245_a("steamcraft:flashBoilerBottomRightO");
        this.topLeftO = ir.func_94245_a("steamcraft:flashBoilerTopLeftT");
        this.bottomLeftO = ir.func_94245_a("steamcraft:flashBoilerBottomLeftT");
        this.topRightO = ir.func_94245_a("steamcraft:flashBoilerTopRightT");
        this.bottomRightO = ir.func_94245_a("steamcraft:flashBoilerBottomRightT");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xf, float yf, float zf) {
        boolean isClient;
        if (world.func_72805_g(x, y, z) <= 0) {
            return false;
        }
        TileEntityFlashBoiler tileEntity = (TileEntityFlashBoiler)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        boolean bl = isClient = !world.field_72995_K;
        if (!FluidHelper.playerIsHoldingWaterContainer(player) && isClient) {
            player.openGui((Object)Steamcraft.instance, 0, world, x, y, z);
        } else {
            FluidHelper.fillTankFromHeldItem(player, (IFluidTank)tileEntity.getTank());
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int frontSide = -1;
        switch (l) {
            case 0: {
                frontSide = 2;
                break;
            }
            case 1: {
                frontSide = 5;
                break;
            }
            case 2: {
                frontSide = 3;
                break;
            }
            case 3: {
                frontSide = 4;
                break;
            }
        }
        this.checkMultiblock(world, x, y, z, false, frontSide);
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        int meta = block.func_72805_g(x, y, z);
        if (meta == 0) {
            return this.field_149761_L;
        }
        TileEntityFlashBoiler boiler = (TileEntityFlashBoiler)block.func_147438_o(x, y, z);
        IIcon tex = this.otherIcon;
        if (meta == 1) {
            tex = side == 0 ? this.topLeft : (side == 4 ? this.bottomLeft : this.bottomRight);
        }
        if (meta == 2) {
            tex = side == 2 ? this.bottomLeft : (side == 0 ? this.topRight : this.bottomRight);
        }
        if (meta == 3) {
            tex = side == 3 || side == 0 ? this.bottomLeft : this.bottomRight;
        }
        if (meta == 4) {
            tex = side == 5 ? this.bottomLeft : this.bottomRight;
        }
        if (meta == 5) {
            tex = side == 1 ? this.topLeft : (side == 4 ? this.topLeftSide : this.topRightSide);
        }
        if (meta == 6) {
            tex = side == 2 ? this.topLeftSide : (side == 1 ? this.topRight : this.topRightSide);
        }
        if (meta == 7) {
            tex = side == 3 ? this.topLeftSide : (side == 1 ? this.bottomLeft : this.topRightSide);
        }
        if (meta == 8) {
            tex = side == 1 ? this.bottomRight : (side == 5 ? this.topLeftSide : this.topRightSide);
        }
        if (side == boiler.getFront()) {
            if (boiler.getBurning()) {
                if (tex == this.topLeftSide) {
                    return this.topLeftO;
                }
                if (tex == this.topRightSide) {
                    return this.topRightO;
                }
                if (tex == this.bottomRight) {
                    return this.bottomRightO;
                }
                if (tex == this.bottomLeft) {
                    return this.bottomLeftO;
                }
            }
            if (tex == this.topLeftSide) {
                return this.topLeftF;
            }
            if (tex == this.topRightSide) {
                return this.topRightF;
            }
            if (tex == this.bottomRight) {
                return this.bottomRightF;
            }
            if (tex == this.bottomLeft) {
                return this.bottomLeftF;
            }
        }
        return tex;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityFlashBoiler boiler;
        if (world.func_72805_g(x, y, z) < 5 && (boiler = (TileEntityFlashBoiler)world.func_147438_o(x, y, z)).isBurning()) {
            int front = boiler.getFront();
            float xOffset = (float)x + 0.5f;
            float yOffset = (float)y + 0.25f + random.nextFloat() * 0.8f;
            float zOffset = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = this.getRandomFlameOffset(random);
            if (front == 4) {
                world.func_72869_a("smoke", (double)(xOffset - f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset - f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset - f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset - f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset - f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset - f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
            } else if (front == 5) {
                world.func_72869_a("smoke", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f3), (double)yOffset, (double)(zOffset + f4), 0.0, 0.0, 0.0);
            } else if (front == 2) {
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset - f3), 0.0, 0.0, 0.0);
            } else if (front == 3) {
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                f4 = this.getRandomFlameOffset(random);
                world.func_72869_a("smoke", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xOffset + f4), (double)yOffset, (double)(zOffset + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    private float getRandomFlameOffset(Random random) {
        return random.nextFloat() * 0.8f - 0.4f;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

