/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.ISteamChargable;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.block.BlockSteamTransporter;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.tile.TileEntitySteamCharger;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.tools.ToolCore;

public class BlockSteamCharger
extends BlockSteamTransporter
implements IWrenchable {
    private final Random rand = new Random();
    @SideOnly(value=Side.CLIENT)
    public IIcon top;
    private IIcon bottom;

    public BlockSteamCharger() {
        super(Material.field_151573_f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + 0.5f), (double)(z + 1));
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase elb, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(elb.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, l, 2);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float px = 0.0625f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    private boolean canItemBeCharged(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ISteamChargable) {
            return ((ISteamChargable)item.func_77973_b()).canCharge(item);
        }
        if (CrossMod.TINKERS_CONSTRUCT && item.func_77973_b() instanceof ToolCore) {
            NBTTagCompound nbt = item.func_77978_p();
            return nbt.func_74775_l("InfiTool").func_74764_b("Steam");
        }
        return item.func_77973_b() == SteamcraftItems.steamcellEmpty;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileEntitySteamCharger tile = (TileEntitySteamCharger)world.func_147438_o(x, y, z);
        if (tile.func_70301_a(0) != null) {
            if (!world.field_72995_K) {
                tile.dropItem(tile.func_70301_a(0));
            }
            tile.func_70299_a(0, null);
        } else if (this.canItemBeCharged(player.func_70694_bm())) {
            ItemStack copy = player.func_71045_bC().func_77946_l();
            copy.field_77994_a = 1;
            tile.func_70299_a(0, copy);
            --player.func_71045_bC().field_77994_a;
            tile.randomDegrees = world.field_73012_v.nextInt(361);
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.bottom : (side == 0 ? this.bottom : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("steamcraft:blockCharger");
        this.top = ir.func_94245_a("steamcraft:blockChargerTop");
        this.bottom = ir.func_94245_a("steamcraft:blockBrass");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySteamCharger();
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return Steamcraft.chargerRenderID;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntitySteamCharger tileentitysteamcharger = (TileEntitySteamCharger)world.func_147438_o(x, y, z);
        if (tileentitysteamcharger != null) {
            for (int i1 = 0; i1 < tileentitysteamcharger.func_70302_i_(); ++i1) {
                ItemStack itemstack = tileentitysteamcharger.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.rand.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        int meta = world.func_72805_g(x, y, z);
        if (side != 0 && side != 1) {
            int output = meta;
            switch (side) {
                case 2: {
                    output = 2;
                    break;
                }
                case 3: {
                    output = 0;
                    break;
                }
                case 4: {
                    output = 1;
                    break;
                }
                case 5: {
                    output = 3;
                }
            }
            if (output == meta && side > 1 && side < 6) {
                switch (ForgeDirection.getOrientation((int)side).getOpposite().ordinal()) {
                    case 2: {
                        output = 2;
                        break;
                    }
                    case 3: {
                        output = 0;
                        break;
                    }
                    case 4: {
                        output = 1;
                        break;
                    }
                    case 5: {
                        output = 3;
                    }
                }
            }
            world.func_72921_c(x, y, z, output, 2);
            return true;
        }
        return false;
    }
}

