/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.block.BlockPipe;
import flaxbeard.steamcraft.tile.TileEntitySteamHeater;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockSteamHeaterRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        IIcon icon = block.func_149733_h(1);
        IIcon icon2 = block.func_149733_h(0);
        float baseMin = 0.3125f;
        float baseMax = 0.6875f;
        float ringMin = 0.25f;
        float ringMax = 0.75f;
        float px = 0.0625f;
        float minY = 0.0f + 2.0f * px;
        float maxY = baseMax;
        float minX = baseMin;
        float maxX = baseMax;
        float minZ = baseMin;
        float maxZ = baseMax;
        block.func_149676_a(baseMin, minY, baseMin, baseMax, maxY, baseMax);
        renderer.func_147775_a(block);
        this.drawSides(icon, block, renderer);
        block.func_149676_a(ringMin, 0.0f, ringMin, ringMax, minY, ringMax);
        renderer.func_147775_a(block);
        this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).sideIcon, block, renderer);
        renderer.func_147771_a();
        block.func_149676_a(0.0f, maxY, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.func_147775_a(block);
        this.drawSidesMultiple(new IIcon[]{icon, icon, icon, icon, icon, icon2}, block, renderer);
    }

    private void drawSidesMultiple(IIcon[] icon, Block block, RenderBlocks renderer) {
        boolean x = false;
        boolean y = false;
        boolean z = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, (double)((float)x), (double)y, (double)z, icon[0]);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, (double)((float)x), (double)y, (double)z, icon[1]);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon[2]);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon[3]);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon[4]);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon[5]);
        tessellator.func_78381_a();
    }

    private void drawSides(IIcon icon, Block block, RenderBlocks renderer) {
        boolean x = false;
        boolean y = false;
        boolean z = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, (double)((float)x), (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, (double)((float)x), (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntitySteamHeater heater = (TileEntitySteamHeater)world.func_147438_o(x, y, z);
        float baseMin = 0.3125f;
        float baseMax = 0.6875f;
        float ringMin = 0.25f;
        float ringMax = 0.75f;
        float px = 0.0625f;
        float minX = baseMin;
        float maxX = baseMax;
        float minY = baseMin;
        float maxY = baseMax;
        float minZ = baseMin;
        float maxZ = baseMax;
        ArrayList<ForgeDirection> myDirections = new ArrayList<ForgeDirection>();
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection direction = ForgeDirection.getOrientation((int)meta).getOpposite();
        for (ForgeDirection dir : ForgeDirection.values()) {
            ISteamTransporter target;
            TileEntity tile;
            if (dir == direction.getOpposite() || world.func_147438_o(heater.field_145851_c + dir.offsetX, heater.field_145848_d + dir.offsetY, heater.field_145849_e + dir.offsetZ) == null || !((tile = world.func_147438_o(heater.field_145851_c + dir.offsetX, heater.field_145848_d + dir.offsetY, heater.field_145849_e + dir.offsetZ)) instanceof ISteamTransporter) || !(target = (ISteamTransporter)tile).doesConnect(dir.getOpposite())) continue;
            myDirections.add(dir);
            if (dir.offsetX == 1) {
                maxX = 1.0f - 2.0f * px;
            }
            if (dir.offsetY == 1) {
                maxY = 1.0f - 2.0f * px;
            }
            if (dir.offsetZ == 1) {
                maxZ = 1.0f - 2.0f * px;
            }
            if (dir.offsetX == -1) {
                minX = 0.0f + 2.0f * px;
            }
            if (dir.offsetY == -1) {
                minY = 0.0f + 2.0f * px;
            }
            if (dir.offsetZ != -1) continue;
            minZ = 0.0f + 2.0f * px;
        }
        if (direction == ForgeDirection.WEST) {
            renderer.func_147771_a();
            block.func_149676_a(maxX, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (direction == ForgeDirection.EAST) {
            renderer.func_147771_a();
            block.func_149676_a(0.0f, 0.0f, 0.0f, minX, 1.0f, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (direction == ForgeDirection.NORTH) {
            renderer.func_147771_a();
            block.func_149676_a(0.0f, 0.0f, maxZ, 1.0f, 1.0f, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (direction == ForgeDirection.SOUTH) {
            renderer.func_147771_a();
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, minZ);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (direction == ForgeDirection.DOWN) {
            renderer.func_147771_a();
            block.func_149676_a(0.0f, maxY, 0.0f, 1.0f, 1.0f, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (direction == ForgeDirection.UP) {
            renderer.func_147771_a();
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, minY, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        renderer.field_147840_d = ((BlockPipe)SteamcraftBlocks.pipe).sideIcon;
        if (minX == 2.0f * px) {
            block.func_149676_a(0.0f, ringMin, ringMin, minX, ringMax, ringMax);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (maxX == 1.0f - 2.0f * px) {
            block.func_149676_a(maxX, ringMin, ringMin, 1.0f, ringMax, ringMax);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (minY == 2.0f * px) {
            block.func_149676_a(ringMin, 0.0f, ringMin, ringMax, minY, ringMax);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (maxY == 1.0f - 2.0f * px) {
            block.func_149676_a(ringMin, maxY, ringMin, ringMax, 1.0f, ringMax);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (minZ == 2.0f * px) {
            block.func_149676_a(ringMin, ringMin, 0.0f, ringMax, ringMax, minZ);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        if (maxZ == 1.0f - 2.0f * px) {
            block.func_149676_a(ringMin, ringMin, maxZ, ringMax, ringMax, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
        }
        renderer.func_147771_a();
        int type = -1;
        if (myDirections.size() == 1) {
            renderer.field_147840_d = ((BlockPipe)SteamcraftBlocks.pipe).sideIcon;
            minX -= px;
            maxX += px;
            minY -= px;
            maxY += px;
            minZ -= px;
            maxZ += px;
        }
        block.func_149676_a(minX, baseMin, baseMin, maxX, baseMax, baseMax);
        renderer.func_147775_a(block);
        renderer.func_147784_q(block, x, y, z);
        block.func_149676_a(baseMin, baseMin, minZ, baseMax, baseMax, maxZ);
        renderer.func_147775_a(block);
        renderer.func_147784_q(block, x, y, z);
        block.func_149676_a(baseMin, minY, baseMin, baseMax, maxY, baseMax);
        renderer.func_147775_a(block);
        renderer.func_147784_q(block, x, y, z);
        renderer.func_147771_a();
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return Steamcraft.heaterRenderID;
    }
}

