/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.IPipeWrench;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.block.BlockPipe;
import flaxbeard.steamcraft.misc.BlockContainer;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockSteamPipeRenderer
implements ISimpleBlockRenderingHandler {
    public static boolean updateWrenchStatus() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IPipeWrench && ((IPipeWrench)equipped).canWrench((EntityPlayer)player, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v) && !player.func_70093_af();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        IIcon icon = block.func_149733_h(0);
        float baseMin = 0.3125f;
        float baseMax = 0.6875f;
        float ringMin = 0.25f;
        float ringMax = 0.75f;
        float px = 0.0625f;
        float minX = 0.0f + 2.0f * px;
        float maxX = 1.0f - 2.0f * px;
        float minY = baseMin;
        float maxY = baseMax;
        float minZ = baseMin;
        float maxZ = baseMax;
        block.func_149676_a(minX, baseMin, baseMin, maxX, baseMax, baseMax);
        renderer.func_147775_a(block);
        this.drawSides(icon, block, renderer);
        block.func_149676_a(0.0f, ringMin, ringMin, minX, ringMax, ringMax);
        renderer.func_147775_a(block);
        this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).sideIcon, block, renderer);
        block.func_149676_a(maxX, ringMin, ringMin, 1.0f, ringMax, ringMax);
        renderer.func_147775_a(block);
        this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).sideIcon, block, renderer);
        if (block == SteamcraftBlocks.valvePipe) {
            block.func_149676_a(4.5f * px, 1.0f - 5.5f * px, baseMax + 1.0f * px, 1.0f - 4.5f * px, 1.0f - 4.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
            block.func_149676_a(4.5f * px, 4.5f * px, baseMax + 1.0f * px, 1.0f - 4.5f * px, 5.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
            block.func_149676_a(4.5f * px, 5.5f * px, baseMax + 1.0f * px, 5.5f * px, 1.0f - 5.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
            block.func_149676_a(1.0f - 5.5f * px, 5.5f * px, baseMax + 1.0f * px, 1.0f - 4.5f * px, 1.0f - 5.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
            block.func_149676_a(5.5f * px, 7.5f * px, baseMax + 1.0f * px, 1.0f - 5.5f * px, 8.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
            block.func_149676_a(7.5f * px, 5.5f * px, baseMax + 1.0f * px, 8.5f * px, 1.0f - 5.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
            block.func_149676_a(6.5f * px, 6.5f * px, baseMax, 9.5f * px, 9.5f * px, baseMax + 2.0f * px);
            renderer.func_147775_a(block);
            this.drawSides(((BlockPipe)SteamcraftBlocks.pipe).copperIcon, block, renderer);
        }
    }

    private void drawSides(IIcon icon, Block block, RenderBlocks renderer) {
        boolean x = false;
        boolean y = false;
        boolean z = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, (double)((float)x), (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, (double)((float)x), (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntitySteamPipe pipe = (TileEntitySteamPipe)world.func_147438_o(x, y, z);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (BlockSteamPipeRenderer.updateWrenchStatus() || pipe.disguiseBlock == null || pipe.disguiseBlock == Blocks.field_150350_a || !pipe.disguiseBlock.func_149686_d()) {
            float baseMin = 0.3125f;
            float baseMax = 0.6875f;
            float ringMin = 0.25f;
            float ringMax = 0.75f;
            float px = 0.0625f;
            float minX = baseMin;
            float maxX = baseMax;
            float minY = baseMin;
            float maxY = baseMax;
            float minZ = baseMin;
            float maxZ = baseMax;
            baseMin = 0.3126f;
            baseMax = 0.6874f;
            ArrayList<ForgeDirection> myDirections = new ArrayList<ForgeDirection>();
            for (ForgeDirection direction : ForgeDirection.values()) {
                ISteamTransporter target;
                TileEntity tile;
                if (!pipe.doesConnect(direction)) {
                    // empty if block
                }
                if (!pipe.doesConnect(direction) || world.func_147438_o(pipe.field_145851_c + direction.offsetX, pipe.field_145848_d + direction.offsetY, pipe.field_145849_e + direction.offsetZ) == null || !((tile = world.func_147438_o(pipe.field_145851_c + direction.offsetX, pipe.field_145848_d + direction.offsetY, pipe.field_145849_e + direction.offsetZ)) instanceof ISteamTransporter) || !(target = (ISteamTransporter)tile).doesConnect(direction.getOpposite())) continue;
                myDirections.add(direction);
                if (direction.offsetX == 1) {
                    maxX = 1.0f - 2.0f * px;
                }
                if (direction.offsetY == 1) {
                    maxY = 1.0f - 2.0f * px;
                }
                if (direction.offsetZ == 1) {
                    maxZ = 1.0f - 2.0f * px;
                }
                if (direction.offsetX == -1) {
                    minX = 0.0f + 2.0f * px;
                }
                if (direction.offsetY == -1) {
                    minY = 0.0f + 2.0f * px;
                }
                if (direction.offsetZ != -1) continue;
                minZ = 0.0f + 2.0f * px;
            }
            if (myDirections.size() == 1) {
                renderer.field_147840_d = ((BlockPipe)SteamcraftBlocks.pipe).sideIcon;
                minX -= px;
                maxX += px;
                minY -= px;
                maxY += px;
                minZ -= px;
                maxZ += px;
            }
            if (myDirections.size() == 2) {
                ForgeDirection direction = ((ForgeDirection)myDirections.get(0)).getOpposite();
                while (!pipe.doesConnect(direction) || direction == myDirections.get(0)) {
                    direction = ForgeDirection.getOrientation((int)((direction.ordinal() + 1) % 5));
                }
                if (direction.offsetX == 1) {
                    maxX = 1.0f - 2.0f * px;
                }
                if (direction.offsetY == 1) {
                    maxY = 1.0f - 2.0f * px;
                }
                if (direction.offsetZ == 1) {
                    maxZ = 1.0f - 2.0f * px;
                }
                if (direction.offsetX == -1) {
                    minX = 0.0f + 2.0f * px;
                }
                if (direction.offsetY == -1) {
                    minY = 0.0f + 2.0f * px;
                }
                if (direction.offsetZ == -1) {
                    minZ = 0.0f + 2.0f * px;
                }
            }
            block.func_149676_a(minX, baseMin, baseMin, maxX, baseMax, baseMax);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
            block.func_149676_a(baseMin, baseMin, minZ, baseMax, baseMax, maxZ);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
            block.func_149676_a(baseMin, minY, baseMin, baseMax, maxY, baseMax);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
            renderer.field_147840_d = ((BlockPipe)SteamcraftBlocks.pipe).sideIcon;
            if (minX == 2.0f * px) {
                block.func_149676_a(0.0f, ringMin, ringMin, minX, ringMax, ringMax);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
            }
            if (maxX == 1.0f - 2.0f * px) {
                block.func_149676_a(maxX, ringMin, ringMin, 1.0f, ringMax, ringMax);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
            }
            if (minY == 2.0f * px) {
                block.func_149676_a(ringMin, 0.0f, ringMin, ringMax, minY, ringMax);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
            }
            if (maxY == 1.0f - 2.0f * px) {
                block.func_149676_a(ringMin, maxY, ringMin, ringMax, 1.0f, ringMax);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
            }
            if (minZ == 2.0f * px) {
                block.func_149676_a(ringMin, ringMin, 0.0f, ringMax, ringMax, minZ);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
            }
            if (maxZ == 1.0f - 2.0f * px) {
                block.func_149676_a(ringMin, ringMin, maxZ, ringMax, ringMax, 1.0f);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
            }
            renderer.func_147771_a();
            if (pipe.disguiseBlock != null && pipe.disguiseBlock != Blocks.field_150350_a && !pipe.disguiseBlock.func_149686_d() && !BlockSteamPipeRenderer.updateWrenchStatus()) {
                GL11.glPushMatrix();
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                renderer.func_147775_a(block);
                if (pipe.disguiseMeta != 0) {
                    renderer.func_147757_a(pipe.disguiseBlock.func_149691_a(0, pipe.disguiseMeta));
                }
                renderer.func_147784_q(pipe.disguiseBlock, x, y, z);
                renderer.func_147771_a();
                GL11.glPopMatrix();
            }
        } else {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderer.func_147775_a(block);
            renderer.func_147753_b(false);
            if (pipe.disguiseMeta != 0) {
                BlockContainer cont = null;
                for (int i = 0; i < 6; ++i) {
                    renderer.func_147757_a(pipe.disguiseBlock.func_149691_a(i, pipe.disguiseMeta));
                    cont = new BlockContainer(pipe.disguiseBlock, i);
                    renderer.func_147784_q((Block)cont, x, y, z);
                }
                cont = null;
            } else {
                renderer.func_147784_q(pipe.disguiseBlock, x, y, z);
            }
            renderer.func_147771_a();
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return Steamcraft.tubeRenderID;
    }
}

