/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.block.BlockBoiler;
import flaxbeard.steamcraft.gui.ContainerBoiler;
import flaxbeard.steamcraft.tile.TileEntityBoiler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBoiler
extends GuiContainer {
    private static final ResourceLocation furnaceGuiTextures = new ResourceLocation("steamcraft:textures/gui/boiler.png");
    private TileEntityBoiler furnaceInventory;

    public GuiBoiler(InventoryPlayer par1InventoryPlayer, TileEntityBoiler par2TileEntityBoiler) {
        super((Container)new ContainerBoiler(par1InventoryPlayer, par2TileEntityBoiler));
        this.furnaceInventory = par2TileEntityBoiler;
    }

    protected void func_146979_b(int par1, int par2) {
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        try {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(furnaceGuiTextures);
            int k = (this.field_146294_l - this.field_146999_f) / 2;
            int l = (this.field_146295_m - this.field_147000_g) / 2;
            GL11.glEnable((int)3042);
            this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
            int i1 = this.furnaceInventory.getBurnTimeRemainingScaled(14);
            this.func_73729_b(k + 58, l + 15 + 14 - i1, 176, 14 - i1, 14, i1);
            GL11.glDisable((int)3042);
            float fill = (float)this.furnaceInventory.getTankInfo((ForgeDirection)ForgeDirection.UP)[0].fluid.amount / (float)this.furnaceInventory.myTank.getCapacity();
            this.drawFluid(new FluidStack(FluidRegistry.WATER, 1), (int)(fill * 58.0f), k + 81, l + 14, 16, 58, false);
            this.field_146297_k.func_110434_K().func_110577_a(furnaceGuiTextures);
            this.func_73729_b(k + 80, l + 13, 190, 0, 18, 60);
            fill = this.furnaceInventory.pressure;
            fill = Math.min(fill, 1.0f);
            FluidStack stack = new FluidStack(FluidRegistry.WATER, 1);
            if (FluidRegistry.isFluidRegistered((String)"steam")) {
                stack = new FluidStack(FluidRegistry.getFluid((String)"steam"), 1);
            }
            this.drawFluid(stack, (int)(fill * 58.0f), k + 104, l + 14, 16, 58, true);
            this.field_146297_k.func_110434_K().func_110577_a(furnaceGuiTextures);
            this.func_73729_b(k + 103, l + 13, 190, 0, 18, 60);
            GL11.glDisable((int)3042);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void drawFluid(FluidStack fluid, int level, int x, int y, int width, int height, boolean steam) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        if (steam) {
            icon = BlockBoiler.steamIcon;
        }
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
            }
        }
        for (i = 0; i < fullX; ++i) {
            this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
        }
        this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }
}

