/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class PhobicCoatingHandler {
    private static final UUID uuid4 = UUID.fromString("ddb705e1-f95d-40e7-8cda-1be73a4739a1");
    private static final AttributeModifier exoWaterBoost = new AttributeModifier(uuid4, "EXOWATERBOOST", 0.4, 2).func_111168_a(true);
    private static final UUID uuid5 = UUID.fromString("ecc2b61a-b8ca-4411-9158-e4d365e3ca7c");
    private static final AttributeModifier exoLavaBoost = new AttributeModifier(uuid5, "EXOLAVABOOST", 0.4, 2).func_111168_a(true);
    private boolean isWalkingInLava = false;
    private boolean isJumping = false;

    @SubscribeEvent
    public void preventLavaDamage(LivingAttackEvent event) {
        if (this.isWalkingInLava && (event.source == DamageSource.field_76371_c || event.source == DamageSource.field_76372_a || event.source == DamageSource.field_76370_b)) {
            event.entity.field_70181_x = 0.5;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void walkOnFluid(TickEvent.PlayerTickEvent event) {
        EntityPlayer entity = event.player;
        int consumptionHydro = Config.hydrophobicConsumption;
        int consumptionPyro = Config.pyrophobicConsumption;
        IAttributeInstance attributes = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        AttributeModifier modifierWater = attributes.func_111127_a(uuid4);
        AttributeModifier modifierLava = attributes.func_111127_a(uuid5);
        boolean canHydro = this.canWalkOnFluid(entity, consumptionHydro, SteamcraftItems.coatingsHydrophobic, modifierWater);
        boolean canPyro = this.canWalkOnFluid(entity, consumptionPyro, SteamcraftItems.coatingsPyrophobic, modifierLava);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72338_b - (double)0.11f));
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        Block blockUnder = entity.field_70170_p.func_147439_a(x, y, z);
        if (event.side == Side.CLIENT) {
            this.isJumping = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        }
        if (canHydro) {
            if (blockUnder == Blocks.field_150355_j || blockUnder == Blocks.field_150358_i) {
                entity.field_70143_R = 0.0f;
                entity.field_70181_x = this.isJumping ? 0.5 : 0.0;
                if (modifierWater == null) {
                    attributes.func_111121_a(exoWaterBoost);
                }
                SteamcraftEventHandler.drainSteam(entity.func_71124_b(3), consumptionHydro);
            }
            if (entity.func_70090_H()) {
                entity.func_70664_aZ();
                entity.field_70143_R = 0.0f;
            }
        } else if (modifierWater != null) {
            attributes.func_111124_b(exoWaterBoost);
        }
        if (canPyro) {
            if (entity.func_70027_ad()) {
                this.isWalkingInLava = true;
                entity.func_70066_B();
                entity.field_70181_x = 0.5;
            }
            if (blockUnder == Blocks.field_150353_l || blockUnder == Blocks.field_150356_k) {
                this.isWalkingInLava = true;
                entity.field_70181_x = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151468_f() ? 0.5 : 0.0;
                if (modifierLava == null) {
                    attributes.func_111121_a(exoLavaBoost);
                }
                SteamcraftEventHandler.drainSteam(entity.func_71124_b(3), consumptionPyro);
            }
            if (entity.func_70058_J()) {
                this.isWalkingInLava = true;
                entity.field_70181_x = 0.5;
                entity.field_70143_R = 0.0f;
            }
        } else if (modifierLava != null) {
            attributes.func_111124_b(exoLavaBoost);
        }
    }

    private boolean canWalkOnFluid(EntityPlayer player, int consumption, Item coating, AttributeModifier modifier) {
        ItemExosuitArmor bootsArmor;
        Item boots;
        ItemStack equipment;
        return SteamcraftEventHandler.hasPower((EntityLivingBase)player, consumption) && modifier == null && (equipment = player.func_71124_b(1)) != null && (boots = equipment.func_77973_b()) instanceof ItemExosuitArmor && (bootsArmor = (ItemExosuitArmor)boots).hasUpgrade(equipment, coating);
    }
}

