/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration.minetweaker;

import flaxbeard.steamcraft.api.SteamcraftRegistry;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.Item;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.CarvingTable")
public class CarvingTableTweaker {
    @ZenMethod
    public static void addCarvable(IItemStack stack) {
        Item item = MineTweakerMC.getItemStack((IItemStack)stack).func_77973_b();
        MineTweakerAPI.apply((IUndoableAction)new Add(item));
    }

    @ZenMethod
    public static void removeCarvable(IItemStack stack) {
        Item item = MineTweakerMC.getItemStack((IItemStack)stack).func_77973_b();
        MineTweakerAPI.apply((IUndoableAction)new Remove(item));
    }

    private static class Remove
    implements IUndoableAction {
        private final Item item;

        public Remove(Item item) {
            this.item = item;
        }

        public void apply() {
            SteamcraftRegistry.removeMold(this.item);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SteamcraftRegistry.addCarvableMold(this.item);
        }

        public String describe() {
            return "Removing " + this.item.func_77658_a() + " from the list of Carving Table molds";
        }

        public String describeUndo() {
            return "Adding " + this.item.func_77658_a() + " to the list of Carving Table molds";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final Item item;

        public Add(Item item) {
            this.item = item;
        }

        public void apply() {
            SteamcraftRegistry.addCarvableMold(this.item);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SteamcraftRegistry.removeMold(this.item);
        }

        public String describe() {
            return "Adding " + this.item.func_77658_a() + " to list of Carving Table molds";
        }

        public String describeUndo() {
            return "Removing " + this.item.func_77658_a() + " from the list of Carving Table molds";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

