/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration.minetweaker;

import cpw.mods.fml.common.FMLLog;
import flaxbeard.steamcraft.api.CrucibleFormula;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.Crucible")
public class CrucibleTweaker {
    @ZenMethod
    public static void addBasicLiquid(String name, IItemStack ingot, IItemStack plate, IItemStack nugget, int r, int g, int b) {
        ItemStack iStack = MineTweakerMC.getItemStack((IItemStack)ingot);
        ItemStack pStack = MineTweakerMC.getItemStack((IItemStack)plate);
        ItemStack nStack = MineTweakerMC.getItemStack((IItemStack)nugget);
        CrucibleLiquid liquid = new CrucibleLiquid(name, iStack, pStack, nStack, null, r, g, b);
        MineTweakerAPI.apply((IUndoableAction)new AddLiquid(liquid));
    }

    @ZenMethod
    public static void addAlloyLiquid(String name, IItemStack ingot, IItemStack plate, IItemStack nugget, String liquid1, int amount1, String liquid2, int amount2, int amountOut, int r, int g, int b) {
        ItemStack iStack = MineTweakerMC.getItemStack((IItemStack)ingot);
        ItemStack pStack = MineTweakerMC.getItemStack((IItemStack)plate);
        ItemStack nStack = MineTweakerMC.getItemStack((IItemStack)nugget);
        CrucibleLiquid crucibleLiquid1 = SteamcraftRegistry.getLiquidFromName(liquid1);
        CrucibleLiquid crucibleLiquid2 = SteamcraftRegistry.getLiquidFromName(liquid2);
        if (crucibleLiquid1 != null && crucibleLiquid2 != null) {
            CrucibleFormula formula = new CrucibleFormula(crucibleLiquid1, amount1, crucibleLiquid2, amount2, amountOut);
            CrucibleLiquid out = new CrucibleLiquid(name, iStack, pStack, nStack, formula, r, g, b);
            MineTweakerAPI.apply((IUndoableAction)new AddLiquid(out));
        } else {
            FMLLog.warning((String)("[FSP-MT] One of your liquids is null: " + liquid1 + ", " + liquid2), (Object[])new Object[0]);
        }
    }

    @ZenMethod
    public static void removeLiquid(String name) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(name);
        if (liquid != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveLiquid(liquid));
        } else {
            FMLLog.warning((String)("[FSP-MT] Could not remove non-existant liquid " + name), (Object[])new Object[0]);
        }
    }

    @ZenMethod
    public static void addMeltRecipe(IItemStack item, String liquidName, int amountOut) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        ItemStack stack = MineTweakerMC.getItemStack((IItemStack)item);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMeltRecipe(stack, liquid, amountOut));
        }
    }

    @ZenMethod
    public static void addOreMeltRecipe(String dict, String liquidName, int amountOut) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMeltRecipe(dict, liquid, amountOut));
        }
    }

    @ZenMethod
    public static void addToolMeltRecipe(IItemStack itemstack, String liquidName, int amountOut) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        Item item = MineTweakerMC.getItemStack((IItemStack)itemstack).func_77973_b();
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMeltRecipe(item, liquid, amountOut));
        }
    }

    @ZenMethod
    public static void removeMeltRecipe(IItemStack input, String output) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(output);
        ItemStack stack = MineTweakerMC.getItemStack((IItemStack)input);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + output), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMeltRecipe(stack, liquid));
        }
    }

    @ZenMethod
    public static void removeOreMeltRecipe(String dict, String liquidName) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMeltRecipe(dict, liquid));
        }
    }

    @ZenMethod
    public static void removeToolMeltRecipe(IItemStack itemstack, String liquidName) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        Item item = MineTweakerMC.getItemStack((IItemStack)itemstack).func_77973_b();
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMeltRecipe(item, liquid));
        }
    }

    @ZenMethod
    public static void addDunkRecipe(IItemStack in, String inLiq, int liquidAmount, IItemStack out) {
        ItemStack inStack = MineTweakerMC.getItemStack((IItemStack)in);
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(inLiq);
        ItemStack outStack = MineTweakerMC.getItemStack((IItemStack)out);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + inLiq), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddDunkRecipe(inStack, liquid, liquidAmount, outStack));
        }
    }

    @ZenMethod
    public static void addOreDunkRecipe(String dict, String liq, int amount, IItemStack out) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liq);
        ItemStack outStack = MineTweakerMC.getItemStack((IItemStack)out);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liq), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddDunkRecipe(dict, liquid, amount, outStack));
        }
    }

    @ZenMethod
    public static void removeDunkRecipe(IItemStack in, String liquidName) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        ItemStack stack = MineTweakerMC.getItemStack((IItemStack)in);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveDunkRecipe(stack, liquid));
        }
    }

    @ZenMethod
    public static void removeOreDunkRecipe(String dict, String liquidName) {
        CrucibleLiquid liquid = SteamcraftRegistry.getLiquidFromName(liquidName);
        if (liquid == null) {
            FMLLog.warning((String)("[FSP-MT] Could not find liquid " + liquidName), (Object[])new Object[0]);
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveDunkRecipe(dict, liquid));
        }
    }

    private static class RemoveDunkRecipe
    implements IUndoableAction {
        private final Object in;
        private final CrucibleLiquid liquid;

        public RemoveDunkRecipe(Object in, CrucibleLiquid liquid) {
            this.in = in;
            this.liquid = liquid;
        }

        public void apply() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.removeDunkRecipe(item, meta, this.liquid);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.removeOreDictDunkRecipe((String)this.in, this.liquid);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.removeDunkRecipe(item, meta, this.liquid);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.removeOreDictDunkRecipe((String)this.in, this.liquid);
            }
        }

        public String describe() {
            if (this.in instanceof ItemStack) {
                return "Removing dunking recipe for " + ((ItemStack)this.in).func_77977_a() + " and " + this.liquid.name;
            }
            if (this.in instanceof String) {
                return "Removing dunking recipe for " + this.in + " and " + this.liquid.name;
            }
            return null;
        }

        public String describeUndo() {
            if (this.in instanceof ItemStack) {
                return "Adding dunk recipe for " + ((ItemStack)this.in).func_77977_a() + " and " + this.liquid.name;
            }
            if (this.in instanceof String) {
                return "Adding dunk recipe for " + this.in + " and " + this.liquid.name;
            }
            return null;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddDunkRecipe
    implements IUndoableAction {
        private final Object in;
        private final CrucibleLiquid liquid;
        private final int liquidAmount;
        private final ItemStack out;

        public AddDunkRecipe(Object in, CrucibleLiquid liquid, int liquidAmount, ItemStack out) {
            this.in = in;
            this.liquid = liquid;
            this.liquidAmount = liquidAmount;
            this.out = out;
        }

        public void apply() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.registerDunkRecipe(item, meta, this.liquid, this.liquidAmount, this.out);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.registerOreDictDunkRecipe((String)this.in, this.liquid, this.liquidAmount, this.out);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.removeDunkRecipe(item, meta, this.liquid);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.removeOreDictDunkRecipe((String)this.in, this.liquid);
            }
        }

        public String describe() {
            if (this.in instanceof ItemStack) {
                return "Adding dunk recipe for " + ((ItemStack)this.in).func_77977_a() + " and " + this.liquid.name;
            }
            if (this.in instanceof String) {
                return "Adding dunk recipe for " + this.in + " and " + this.liquid.name;
            }
            return null;
        }

        public String describeUndo() {
            if (this.in instanceof ItemStack) {
                return "Removing dunking recipe for " + ((ItemStack)this.in).func_77977_a() + " and " + this.liquid.name;
            }
            if (this.in instanceof String) {
                return "Removing dunking recipe for " + this.in + " and " + this.liquid.name;
            }
            return null;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveMeltRecipe
    implements IUndoableAction {
        private final Object in;
        private final CrucibleLiquid liquid;

        public RemoveMeltRecipe(Object in, CrucibleLiquid liquid) {
            this.in = in;
            this.liquid = liquid;
        }

        public void apply() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.removeMeltRecipe(item, meta, this.liquid);
            } else if (this.in instanceof Item) {
                SteamcraftRegistry.removeMeltRecipeTool((Item)this.in, this.liquid);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.removeMeltRecipeOreDict((String)this.in, this.liquid);
            }
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Removing melting recipe for " + this.liquid.name;
        }

        public String describeUndo() {
            return null;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddMeltRecipe
    implements IUndoableAction {
        private final Object in;
        private final CrucibleLiquid liquid;
        private final int amountOut;

        public AddMeltRecipe(Object in, CrucibleLiquid liquid, int amountOut) {
            this.in = in;
            this.liquid = liquid;
            this.amountOut = amountOut;
        }

        public void apply() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.registerMeltRecipe(item, meta, this.liquid, this.amountOut);
            } else if (this.in instanceof Item) {
                SteamcraftRegistry.registerMeltRecipeTool((Item)this.in, this.liquid, this.amountOut);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.registerMeltRecipeOreDict((String)this.in, this.liquid, this.amountOut);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.in instanceof ItemStack) {
                Item item = ((ItemStack)this.in).func_77973_b();
                int meta = ((ItemStack)this.in).func_77960_j();
                SteamcraftRegistry.removeMeltRecipe(item, meta, this.liquid);
            } else if (this.in instanceof Item) {
                SteamcraftRegistry.removeMeltRecipeTool((Item)this.in, this.liquid);
            } else if (this.in instanceof String) {
                SteamcraftRegistry.removeMeltRecipeOreDict((String)this.in, this.liquid);
            }
        }

        public String describe() {
            return "Adding Crucible melt recipe for " + this.liquid.name;
        }

        public String describeUndo() {
            return "Removing Crucible melt recipe for " + this.liquid.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveLiquid
    implements IUndoableAction {
        private final CrucibleLiquid liquid;

        public RemoveLiquid(CrucibleLiquid liquid) {
            this.liquid = liquid;
        }

        public void apply() {
            SteamcraftRegistry.removeLiquid(this.liquid);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SteamcraftRegistry.registerLiquid(this.liquid);
        }

        public String describe() {
            return "Removing CrucibleLiquid " + this.liquid.name;
        }

        public String describeUndo() {
            return "Adding CrucibleLiquid " + this.liquid.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddLiquid
    implements IUndoableAction {
        private final CrucibleLiquid liquid;

        public AddLiquid(CrucibleLiquid liquid) {
            this.liquid = liquid;
        }

        public void apply() {
            SteamcraftRegistry.registerLiquid(this.liquid);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SteamcraftRegistry.removeLiquid(this.liquid);
        }

        public String describe() {
            return "Adding CrucibleLiquid " + this.liquid.name;
        }

        public String describeUndo() {
            return "Removing CrucibleLiquid " + this.liquid.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

