/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration.minetweaker;

import flaxbeard.steamcraft.api.SteamcraftRegistry;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.SteamHeater")
public class SteamHeaterTweaker {
    @ZenMethod
    public static void addSteamingRecipe(IItemStack originalI, IItemStack steamedI) {
        ItemStack original = MineTweakerMC.getItemStack((IItemStack)originalI);
        ItemStack steamed = MineTweakerMC.getItemStack((IItemStack)steamedI);
        MineTweakerAPI.apply((IUndoableAction)new Add(original.func_77973_b(), original.func_77960_j(), steamed.func_77973_b(), steamed.func_77960_j()));
    }

    @ZenMethod
    public static void removeSteamingRecipe(IItemStack original) {
        ItemStack stack = MineTweakerMC.getItemStack((IItemStack)original);
        MineTweakerAPI.apply((IUndoableAction)new Remove(stack.func_77973_b(), stack.func_77960_j()));
    }

    private static class Remove
    implements IUndoableAction {
        private final Item item;
        private final int meta;

        public Remove(Item item, int meta) {
            this.item = item;
            this.meta = meta;
        }

        public void apply() {
            SteamcraftRegistry.removeSteamingRecipe(this.item, this.meta);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Removing steaming alternative recipe for " + this.item.func_77658_a();
        }

        public String describeUndo() {
            return null;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final Item originalItem;
        private final int originalMeta;
        private final Item steamedItem;
        private final int steamedMeta;

        public Add(Item originalItem, int originalMeta, Item steamedItem, int steamedMeta) {
            this.originalItem = originalItem;
            this.originalMeta = originalMeta;
            this.steamedItem = steamedItem;
            this.steamedMeta = steamedMeta;
        }

        public void apply() {
            SteamcraftRegistry.addSteamingRecipe(this.originalItem, this.originalMeta, this.steamedItem, this.steamedMeta);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SteamcraftRegistry.removeSteamingRecipe(this.originalItem, this.originalMeta);
        }

        public String describe() {
            return "Adding steaming recipe alternative for " + this.originalItem.func_77658_a();
        }

        public String describeUndo() {
            return "Removing steaming recipe alternative for " + this.originalItem.func_77658_a();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

