/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item.tool.steam;

import flaxbeard.steamcraft.api.tool.ISteamToolUpgrade;
import flaxbeard.steamcraft.api.tool.SteamToolSlot;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemSteamToolUpgrade
extends Item
implements ISteamToolUpgrade {
    protected String[] myOverlays;
    protected String myInfo;
    protected int prio;
    private SteamToolSlot mySlot;
    public IIcon[] icons;

    public ItemSteamToolUpgrade(SteamToolSlot slot, String resourceLocation, String info, int priority) {
        this.mySlot = slot;
        this.myInfo = info != null && !info.isEmpty() ? info : null;
        if (resourceLocation != null && !resourceLocation.isEmpty()) {
            if (this.isUniversal()) {
                this.myOverlays = new String[]{resourceLocation + "Drill0", resourceLocation + "Drill1", resourceLocation + "Saw0", resourceLocation + "Saw1", resourceLocation + "Shovel0", resourceLocation + "Shovel1"};
                this.icons = new IIcon[6];
            } else {
                this.myOverlays = new String[]{resourceLocation + "0", resourceLocation + "1"};
                this.icons = new IIcon[2];
            }
        } else {
            this.myOverlays = null;
        }
        this.prio = priority;
    }

    @Override
    public boolean isUniversal() {
        return this.getToolSlot() == SteamToolSlot.TOOL_CORE;
    }

    @Override
    public int renderPriority() {
        return this.prio;
    }

    @Override
    public SteamToolSlot getToolSlot() {
        return this.mySlot;
    }

    @Override
    public String getInformation(ItemStack me, ItemStack tool) {
        return this.myInfo;
    }

    public void func_94581_a(IIconRegister ir) {
        if (this.myOverlays == null) {
            return;
        }
        if (this.isUniversal()) {
            ArrayList<String> list = new ArrayList<String>();
            for (String overlay : this.myOverlays) {
                int index;
                int n = index = overlay.contains("0") ? 0 : 1;
                if (overlay.contains("Drill")) {
                    index += 0;
                } else if (overlay.contains("Saw")) {
                    index += 2;
                } else if (overlay.contains("Shovel")) {
                    index += 4;
                }
                list.add(index, overlay);
            }
            for (int i = 0; i < list.size(); ++i) {
                this.icons[i] = ir.func_94245_a((String)list.get(i));
            }
        } else {
            for (int i = 0; i < this.myOverlays.length; ++i) {
                this.icons[i] = ir.func_94245_a(this.myOverlays[i]);
            }
        }
    }

    @Override
    public IIcon[] getIIcons() {
        return this.icons;
    }

    public IIcon getIcon(ItemStack self, int pass) {
        return this.func_77650_f(self);
    }

    public IIcon func_77650_f(ItemStack self) {
        return this.icons[0];
    }
}

