/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item.tool.steam;

import flaxbeard.steamcraft.api.tool.ISteamToolUpgrade;
import flaxbeard.steamcraft.api.tool.SteamToolSlot;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.MutablePair;

public class SteamToolHelper {
    public static final MutablePair<Integer, Integer>[] ENGINEER_COORDINATES = new MutablePair[]{MutablePair.of((Object)60, (Object)12), MutablePair.of((Object)37, (Object)40)};

    public static ArrayList<String> getInformationFromStacks(ArrayList<ItemStack> upgrades, SteamToolSlot redSlot, ItemStack tool) {
        if (upgrades == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (ItemStack stack : upgrades) {
            ISteamToolUpgrade upgrade = (ISteamToolUpgrade)stack.func_77973_b();
            EnumChatFormatting format = upgrade.getToolSlot() == redSlot ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GREEN;
            String info = upgrade.getInformation(stack, tool);
            String toAdd = info == null ? stack.func_77973_b().func_77658_a() + ".name" : info;
            strings.add(format + "" + StatCollector.func_74838_a((String)toAdd));
        }
        if (strings.isEmpty()) {
            return null;
        }
        return strings;
    }

    public static void setNBTInventory(ItemStack me, int slot, ItemStack stack) {
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (!me.field_77990_d.func_74764_b("upgrades")) {
            me.field_77990_d.func_74782_a("upgrades", (NBTBase)new NBTTagCompound());
        }
        if (me.field_77990_d.func_74775_l("upgrades").func_74764_b(Integer.toString(slot))) {
            me.field_77990_d.func_74775_l("upgrades").func_82580_o(Integer.toString(slot));
        }
        NBTTagCompound stc = new NBTTagCompound();
        if (stack != null) {
            stack.func_77955_b(stc);
            me.field_77990_d.func_74775_l("upgrades").func_74782_a(Integer.toString(slot), (NBTBase)stc);
        }
    }

    public static NBTTagCompound checkNBT(ItemStack me) {
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (!me.func_77978_p().func_74764_b("Speed")) {
            me.func_77978_p().func_74768_a("Speed", 0);
        }
        if (!me.func_77978_p().func_74764_b("Ticks")) {
            me.func_77978_p().func_74768_a("Ticks", 0);
        }
        return me.func_77978_p();
    }
}

