/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import flaxbeard.steamcraft.Steamcraft;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.MutablePair;

public class DrillHeadMaterial {
    public static HashMap<String, DrillHeadMaterial> materials = new HashMap();
    public static HashMap<String, MutablePair<ArrayList<ItemStack>, ArrayList<ItemStack>>> materialOres = new HashMap();
    public static HashMap<String, ArrayList<ItemStack>> nonStandardMaterials = new HashMap();
    public String materialName;
    public String locName;
    public int harvestLevel;
    public boolean standard;
    public String oreName;
    private String color;

    public DrillHeadMaterial(String materialIngot, String locName, int harvestLevel, boolean standard, String color) {
        this(materialIngot, locName, harvestLevel, standard, color, null);
    }

    public DrillHeadMaterial(String materialIngot, String locName, int harvestLevel, boolean standard, String color, String oreName) {
        this.materialName = materialIngot;
        this.locName = locName;
        this.harvestLevel = harvestLevel;
        this.standard = standard;
        this.oreName = oreName;
        this.color = color;
    }

    public int getColorInt() {
        return new Color(Integer.parseInt(this.color.replace("#", ""), 16)).getRGB();
    }

    public String getColorString() {
        return this.color;
    }

    public String toString() {
        String s = this.standard ? "Standard" : "Non-Standard";
        String o = this.oreName == null ? "" : "(" + this.oreName + ")";
        return String.format("%s DrillHeadMaterial %s %s, localized at %s, with %s harvest level", s, this.materialName, o, this.locName, this.harvestLevel);
    }

    public static void registerDrillMaterial(String materialName, String locName, int harvestLevel, String color) {
        DrillHeadMaterial material = new DrillHeadMaterial(materialName, locName, harvestLevel, true, color);
        materials.put(materialName, material);
        ArrayList ingots = OreDictionary.getOres((String)("ingot" + materialName));
        ArrayList nuggets = OreDictionary.getOres((String)("nugget" + materialName));
        materialOres.put(materialName, (MutablePair<ArrayList<ItemStack>, ArrayList<ItemStack>>)MutablePair.of((Object)ingots, (Object)nuggets));
    }

    public static void registerNonStandardDrillMaterial(String material, String ore, String loc, int harvestLevel, String color) {
        DrillHeadMaterial head = new DrillHeadMaterial(material, loc, harvestLevel, false, color, ore);
        materials.put(material, head);
        ArrayList ores = OreDictionary.getOres((String)ore);
        nonStandardMaterials.put(material, ores);
    }

    public static void registerDefaults() {
        String jsonFilePath = Steamcraft.CONFIG_DIR + "/FSP-materials.json";
        File jsonFile = new File(jsonFilePath);
        if (jsonFile.exists()) {
            try {
                Set entries;
                String str = FileUtils.readFileToString((File)jsonFile);
                JsonElement jsonObject = new JsonParser().parse(str);
                if (jsonObject.isJsonObject() && (entries = ((JsonObject)jsonObject).entrySet()) != null) {
                    for (Map.Entry entry : entries) {
                        JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                        if (obj.get("standard").getAsBoolean()) {
                            DrillHeadMaterial.registerDrillMaterial((String)entry.getKey(), obj.get("locName").getAsString(), obj.get("harvestLevel").getAsInt(), obj.get("color").getAsString());
                            continue;
                        }
                        DrillHeadMaterial.registerNonStandardDrillMaterial((String)entry.getKey(), obj.get("oreName").getAsString(), obj.get("locName").getAsString(), obj.get("harvestLevel").getAsInt(), obj.get("color").getAsString());
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DrillHeadMaterial.registerDrillMaterial("Gold", "drill.gold", 1, "#CED652");
        DrillHeadMaterial.registerDrillMaterial("Iron", "drill.iron", 2, "#DEDEDE");
        DrillHeadMaterial.registerDrillMaterial("Brass", "drill.brass", 2, "#FABD3F");
        DrillHeadMaterial.registerNonStandardDrillMaterial("Diamond", "gemDiamond", "drill.diamond", 3, "#29C6AD");
        DrillHeadMaterial.registerNonStandardDrillMaterial("Emerald", "gemEmerald", "drill.emerald", 3, "#17DD62");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(materials);
        try {
            FileWriter writer = new FileWriter(jsonFilePath);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

