/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.misc;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;

public class FluidHelper {
    private static Fluid water = FluidRegistry.WATER;

    public static void changeWaterFluid(Fluid newWater) {
        water = newWater;
    }

    public static boolean playerIsHoldingWaterContainer(EntityPlayer player) {
        ItemStack heldItem = player.func_70694_bm();
        return FluidHelper.itemStackIsWaterContainer(heldItem);
    }

    public static boolean itemStackIsWaterContainer(ItemStack itemStack) {
        FluidStack fluid = FluidHelper.getFluidFromItemStack(itemStack);
        return itemStack != null && fluid != null && fluid.getFluid() == water;
    }

    private static FluidStack getFluidFromItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (fluid != null) {
            return fluid;
        }
        if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)itemStack.func_77973_b();
            return fluidContainerItem.getFluid(itemStack);
        }
        return null;
    }

    public static void fillTankFromHeldItem(EntityPlayer player, IFluidTank tank) {
        ItemStack newContainer = FluidHelper.fillTankFromItem(player.func_70694_bm(), tank);
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        FluidHelper.replaceHeldItemWithDrainedContainer(player, newContainer);
    }

    public static ItemStack fillTankFromItem(ItemStack container, IFluidTank tank) {
        if (container == null) {
            return null;
        }
        if (container.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)container.func_77973_b();
            int roomLeftInContainer = FluidHelper.getRoomLeftInTank(tank);
            if (roomLeftInContainer > 0) {
                FluidStack drained = fluidContainerItem.drain(container, roomLeftInContainer, true);
                tank.fill(drained, true);
            }
            return container;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        int amountFilled = tank.fill(fluid, true);
        if (amountFilled == 0) {
            return container;
        }
        FluidStack leftovers = fluid.copy();
        leftovers.amount = fluid.amount - amountFilled;
        return FluidHelper.getContainerWithUpdatedAmount(container, leftovers);
    }

    private static int getRoomLeftInTank(IFluidTank tank) {
        return tank.getCapacity() - tank.getFluidAmount();
    }

    private static void replaceHeldItemWithDrainedContainer(EntityPlayer player, ItemStack newContainer) {
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newContainer);
        player.field_71069_bz.func_75142_b();
    }

    private static ItemStack getContainerWithUpdatedAmount(ItemStack container, FluidStack newFluidAmount) {
        if (container.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)container.func_77973_b();
            fluidContainerItem.drain(container, newFluidAmount.amount, true);
            return container;
        }
        ItemStack newContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)container);
        if (newFluidAmount.amount > 0) {
            return FluidContainerRegistry.fillFluidContainer((FluidStack)newFluidAmount, (ItemStack)newContainer);
        }
        return newContainer;
    }
}

