/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.misc;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.event.AnimalTradeEvent;
import flaxbeard.steamcraft.entity.ExtendedPropertiesMerchant;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.integration.natura.NaturaIntegration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.MutablePair;

public class FrequencyMerchant
implements IMerchant {
    private final EntityLiving entity;
    private EntityPlayer customer;
    private MerchantRecipeList existingList = null;
    private ArrayList<ItemStack> currencies = new ArrayList();
    ArrayList<MutablePair<ItemStack, Integer>> saleItems = new ArrayList();
    private ExtendedPropertiesMerchant nbt;

    public FrequencyMerchant(EntityLiving entity, String name) {
        this.entity = entity;
        this.nbt = (ExtendedPropertiesMerchant)entity.getExtendedProperties(Steamcraft.MERCHANT_PROPERTY_ID);
        this.nbt.merchantName = name;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        Random random = this.entity.field_70170_p.field_73012_v;
        if (this.existingList != null) {
            return this.existingList;
        }
        if (this.nbt.stock != null) {
            this.existingList = this.nbt.stock.isEmpty() ? new MerchantRecipeList() : this.nbt.stock;
            return this.existingList;
        }
        this.existingList = new MerchantRecipeList();
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151065_br, 2), (Object)10));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151042_j), (Object)7));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151074_bl, 4), (Object)9));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151145_ak, 3), (Object)4));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151119_aD, 7), (Object)3));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151118_aC), (Object)3));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151044_h, 2), (Object)4));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151174_bG, 3), (Object)2));
        this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151146_bM), (Object)3));
        if (this.entity instanceof EntityWolf) {
            this.currencies.add(new ItemStack(SteamcraftItems.steamedBeef));
            this.currencies.add(new ItemStack(SteamcraftItems.steamedPorkchop));
            this.currencies.add(new ItemStack(SteamcraftItems.steamedChicken));
            this.currencies.add(new ItemStack(Items.field_151103_aS));
            if (CrossMod.NATURA) {
                this.currencies.add(new ItemStack(NaturaIntegration.steamedImphide));
            }
            if (random.nextDouble() < 0.09) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.musketCartridge, 2), (Object)12));
            }
            if (random.nextDouble() < 0.08) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 1), (Object)15));
            }
            if (random.nextDouble() < 0.07) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 2), (Object)15));
            }
            if (random.nextDouble() < 0.06) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 3), (Object)15));
            }
            if (random.nextDouble() < 0.05) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.steamcraftCrafting, 1, 4), (Object)15));
            }
            if (random.nextDouble() < 0.04) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151040_l), (Object)20));
            }
        } else if (this.entity instanceof EntityOcelot) {
            this.currencies.add(new ItemStack(SteamcraftItems.steamedFish));
            this.currencies.add(new ItemStack(SteamcraftItems.steamedSalmon));
            if (random.nextDouble() < 0.09) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.blankMold, 2), (Object)6));
            }
            if (random.nextDouble() < 0.08) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.ingotMold), (Object)8));
            }
            if (random.nextDouble() < 0.07) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.plateMold), (Object)8));
            }
            if (random.nextDouble() < 0.06) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.nuggetMold), (Object)8));
            }
            if (random.nextDouble() < 0.05) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.steamcraftIngot, 2, 2), (Object)4));
            }
            if (random.nextDouble() < 0.04) {
                this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(SteamcraftItems.canister), (Object)5));
            }
        }
        if (random.nextDouble() < 0.03) {
            this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151137_ax), (Object)20));
        }
        if (random.nextDouble() < 0.2) {
            this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151166_bC), (Object)24));
        }
        if (random.nextDouble() < 0.1) {
            this.saleItems.add((MutablePair<ItemStack, Integer>)MutablePair.of((Object)new ItemStack(Items.field_151045_i), (Object)28));
        }
        for (MutablePair<ItemStack, Integer> saleItem : this.saleItems) {
            ItemStack stack = (ItemStack)saleItem.left;
            if (stack == null || stack.func_77973_b() == null) continue;
            ItemStack currency = this.currencies.get(random.nextInt(this.currencies.size()));
            int multiplier = (Integer)saleItem.right;
            ItemStack cost = currency.func_77946_l();
            cost.field_77994_a = multiplier;
            MerchantRecipe recipe = new MerchantRecipe(cost, stack);
            recipe.func_82783_a(0 - (6 - random.nextInt(2)));
            this.existingList.add((Object)recipe);
        }
        Collections.shuffle(this.existingList);
        this.nbt.stock = this.existingList;
        return this.existingList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList list) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
        if (this.entity != null && this.entity.func_70089_S() && !this.entity.field_70170_p.field_72995_K) {
            recipe.func_77399_f();
            if (this.existingList != null) {
                NBTTagCompound nbt = this.entity.getEntityData();
                nbt.func_74782_a("stock", (NBTBase)this.existingList.func_77202_a());
                ItemStack toSell = recipe.func_77397_d();
                ItemStack toBuy = recipe.func_77394_a();
                AnimalTradeEvent event = new AnimalTradeEvent(this.entity, this.customer, toBuy, toSell);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.entity.func_70642_aH();
        }
    }

    public void func_110297_a_(ItemStack stack) {
        this.entity.func_70642_aH();
    }
}

